/*
 * Decompiled with CFR 0.152.
 */
package io.rx_cache2.internal;

import io.reactivex.Observable;
import io.rx_cache2.ConfigProvider;
import io.rx_cache2.DynamicKey;
import io.rx_cache2.DynamicKeyGroup;
import io.rx_cache2.Encrypt;
import io.rx_cache2.EvictProvider;
import io.rx_cache2.Expirable;
import io.rx_cache2.LifeCache;
import io.rx_cache2.Reply;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;

public final class ProxyTranslator {
    private final Map<Method, ConfigProvider> configProviderMethodCache = new HashMap<Method, ConfigProvider>();

    @Inject
    ProxyTranslator() {
    }

    ConfigProvider processMethod(Method method, Object[] objectsMethod) {
        ConfigProvider prev = this.loadConfigProviderMethod(method);
        ConfigProvider configProvider = new ConfigProvider(prev.getProviderKey(), null, prev.getLifeTimeMillis(), prev.requiredDetailedResponse(), prev.isExpirable(), prev.isEncrypted(), this.getDynamicKey(method, objectsMethod), this.getDynamicKeyGroup(method, objectsMethod), this.getLoaderObservable(method, objectsMethod), this.evictProvider(method, objectsMethod));
        return configProvider;
    }

    private String getProviderKey(Method method) {
        return method.getName();
    }

    private String getDynamicKey(Method method, Object[] objectsMethod) {
        DynamicKey dynamicKey = this.getObjectFromMethodParam(method, DynamicKey.class, objectsMethod);
        if (dynamicKey != null) {
            return dynamicKey.getDynamicKey().toString();
        }
        DynamicKeyGroup dynamicKeyGroup = this.getObjectFromMethodParam(method, DynamicKeyGroup.class, objectsMethod);
        if (dynamicKeyGroup != null) {
            return dynamicKeyGroup.getDynamicKey().toString();
        }
        return "";
    }

    private String getDynamicKeyGroup(Method method, Object[] objectsMethod) {
        DynamicKeyGroup dynamicKeyGroup = this.getObjectFromMethodParam(method, DynamicKeyGroup.class, objectsMethod);
        return dynamicKeyGroup != null ? dynamicKeyGroup.getGroup().toString() : "";
    }

    private Observable getLoaderObservable(Method method, Object[] objectsMethod) {
        Observable observable = this.getObjectFromMethodParam(method, Observable.class, objectsMethod);
        if (observable != null) {
            return observable;
        }
        String errorMessage = method.getName() + " requires an instance of type observable";
        throw new IllegalArgumentException(errorMessage);
    }

    private Long getLifeTimeCache(Method method) {
        LifeCache lifeCache = method.getAnnotation(LifeCache.class);
        if (lifeCache == null) {
            return null;
        }
        return lifeCache.timeUnit().toMillis(lifeCache.duration());
    }

    private boolean getExpirable(Method method) {
        Expirable expirable = method.getAnnotation(Expirable.class);
        if (expirable != null) {
            return expirable.value();
        }
        return true;
    }

    private boolean isEncrypted(Method method) {
        Encrypt encrypt = method.getAnnotation(Encrypt.class);
        return encrypt != null;
    }

    private boolean requiredDetailResponse(Method method) {
        if (method.getReturnType() != Observable.class) {
            String errorMessage = method.getName() + " needs to return an Observable<T> or Observable<Reply<T>>";
            throw new IllegalArgumentException(errorMessage);
        }
        return method.getGenericReturnType().toString().contains(Reply.class.getName());
    }

    private EvictProvider evictProvider(Method method, Object[] objectsMethod) {
        EvictProvider evictProvider = this.getObjectFromMethodParam(method, EvictProvider.class, objectsMethod);
        if (evictProvider != null) {
            return evictProvider;
        }
        return new EvictProvider(false);
    }

    private <T> T getObjectFromMethodParam(Method method, Class<T> expectedClass, Object[] objectsMethod) {
        int countSameObjectsType = 0;
        Object expectedObject = null;
        for (Object objectParam : objectsMethod) {
            if (!expectedClass.isAssignableFrom(objectParam.getClass())) continue;
            expectedObject = objectParam;
            ++countSameObjectsType;
        }
        if (countSameObjectsType > 1) {
            String errorMessage = method.getName() + " requires just one instance of type " + expectedObject.getClass().getSimpleName();
            throw new IllegalArgumentException(errorMessage);
        }
        return (T)expectedObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConfigProvider loadConfigProviderMethod(Method method) {
        ConfigProvider result;
        Map<Method, ConfigProvider> map = this.configProviderMethodCache;
        synchronized (map) {
            result = this.configProviderMethodCache.get(method);
            if (result == null) {
                result = new ConfigProvider(this.getProviderKey(method), null, this.getLifeTimeCache(method), this.requiredDetailResponse(method), this.getExpirable(method), this.isEncrypted(method), null, null, null, null);
                this.configProviderMethodCache.put(method, result);
            }
        }
        return result;
    }
}

