/*
 * Decompiled with CFR 0.152.
 */
package rx_activity_result;

import android.app.Activity;
import android.app.Application;
import android.os.Bundle;
import java.util.concurrent.TimeUnit;
import rx.Observable;
import rx.functions.Func1;

class ActivitiesLifecycleCallbacks {
    final Application application;
    volatile Activity liveActivityOrNull;
    Application.ActivityLifecycleCallbacks activityLifecycleCallbacks;
    volatile boolean emitted = false;

    public ActivitiesLifecycleCallbacks(Application application) {
        this.application = application;
        this.registerActivityLifeCycle();
    }

    private void registerActivityLifeCycle() {
        if (this.activityLifecycleCallbacks != null) {
            this.application.unregisterActivityLifecycleCallbacks(this.activityLifecycleCallbacks);
        }
        this.activityLifecycleCallbacks = new Application.ActivityLifecycleCallbacks(){

            public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
                ActivitiesLifecycleCallbacks.this.liveActivityOrNull = activity;
            }

            public void onActivityStarted(Activity activity) {
            }

            public void onActivityResumed(Activity activity) {
                ActivitiesLifecycleCallbacks.this.liveActivityOrNull = activity;
            }

            public void onActivityPaused(Activity activity) {
                ActivitiesLifecycleCallbacks.this.liveActivityOrNull = null;
            }

            public void onActivityStopped(Activity activity) {
            }

            public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
            }

            public void onActivityDestroyed(Activity activity) {
            }
        };
        this.application.registerActivityLifecycleCallbacks(this.activityLifecycleCallbacks);
    }

    Activity getLiveActivity() {
        return this.liveActivityOrNull;
    }

    Observable<Activity> getOLiveActivity() {
        this.emitted = false;
        return Observable.interval((long)50L, (long)50L, (TimeUnit)TimeUnit.MILLISECONDS).map((Func1)new Func1<Long, Activity>(){

            public Activity call(Long aLong) {
                return ActivitiesLifecycleCallbacks.this.liveActivityOrNull;
            }
        }).takeWhile((Func1)new Func1<Activity, Boolean>(){

            public Boolean call(Activity activity) {
                boolean continueEmitting = true;
                if (ActivitiesLifecycleCallbacks.this.emitted) {
                    continueEmitting = false;
                }
                if (activity != null) {
                    ActivitiesLifecycleCallbacks.this.emitted = true;
                }
                return continueEmitting;
            }
        }).filter((Func1)new Func1<Activity, Boolean>(){

            public Boolean call(Activity activity) {
                return activity != null;
            }
        });
    }
}

