/*
 * Decompiled with CFR 0.152.
 */
package rx_activity_result;

import android.app.Activity;
import android.app.Application;
import android.os.Bundle;
import io.reactivex.Observable;
import io.reactivex.functions.Function;
import io.reactivex.functions.Predicate;
import java.util.concurrent.TimeUnit;

class ActivitiesLifecycleCallbacks {
    private final Application application;
    private Activity liveActivityOrNull;
    private Application.ActivityLifecycleCallbacks activityLifecycleCallbacks;
    private boolean emitted = false;

    public ActivitiesLifecycleCallbacks(Application application) {
        this.application = application;
        this.registerActivityLifeCycle();
    }

    private void registerActivityLifeCycle() {
        if (this.activityLifecycleCallbacks != null) {
            this.application.unregisterActivityLifecycleCallbacks(this.activityLifecycleCallbacks);
        }
        this.activityLifecycleCallbacks = new Application.ActivityLifecycleCallbacks(){

            public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
                ActivitiesLifecycleCallbacks.this.liveActivityOrNull = activity;
            }

            public void onActivityStarted(Activity activity) {
            }

            public void onActivityResumed(Activity activity) {
                ActivitiesLifecycleCallbacks.this.liveActivityOrNull = activity;
            }

            public void onActivityPaused(Activity activity) {
                ActivitiesLifecycleCallbacks.this.liveActivityOrNull = null;
            }

            public void onActivityStopped(Activity activity) {
            }

            public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
            }

            public void onActivityDestroyed(Activity activity) {
            }
        };
        this.application.registerActivityLifecycleCallbacks(this.activityLifecycleCallbacks);
    }

    Activity getLiveActivity() {
        return this.liveActivityOrNull;
    }

    Observable<Activity> getOLiveActivity() {
        this.emitted = false;
        return Observable.interval((long)50L, (long)50L, (TimeUnit)TimeUnit.MILLISECONDS).map((Function)new Function<Long, Object>(){

            public Object apply(Long aLong) throws Exception {
                if (ActivitiesLifecycleCallbacks.this.liveActivityOrNull == null) {
                    return 0;
                }
                return ActivitiesLifecycleCallbacks.this.liveActivityOrNull;
            }
        }).takeWhile((Predicate)new Predicate<Object>(){

            public boolean test(Object candidate) throws Exception {
                boolean continueEmitting = true;
                if (ActivitiesLifecycleCallbacks.this.emitted) {
                    continueEmitting = false;
                }
                if (candidate instanceof Activity) {
                    ActivitiesLifecycleCallbacks.this.emitted = true;
                }
                return continueEmitting;
            }
        }).filter((Predicate)new Predicate<Object>(){

            public boolean test(Object candidate) throws Exception {
                return candidate instanceof Activity;
            }
        }).map((Function)new Function<Object, Activity>(){

            public Activity apply(Object activity) throws Exception {
                return (Activity)activity;
            }
        });
    }
}

