/*
 * Decompiled with CFR 0.152.
 */
package rx_activity_result;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import java.util.List;
import rx.Observable;
import rx.Subscriber;
import rx.functions.Action1;
import rx_activity_result.ActivitiesLifecycleCallbacks;
import rx_activity_result.HolderActivity;
import rx_activity_result.OnResult;
import rx_activity_result.Request;
import rx_activity_result.Result;

public class RxActivityResult {
    private static ActivitiesLifecycleCallbacks activitiesLifecycle;

    public static void register(Application application) {
        activitiesLifecycle = new ActivitiesLifecycleCallbacks(application);
    }

    public static <T extends Activity> Builder<T> on(T activity) {
        return new Builder<T>(activity);
    }

    public static <T extends Fragment> Builder<T> on(T fragment) {
        return new Builder<T>(fragment);
    }

    public static class Builder<T> {
        private final Class clazz;
        private Subscriber<? super Result<T>> subscriber;
        private final boolean uiTargetActivity;

        public Builder(T t) {
            if (activitiesLifecycle == null) {
                throw new IllegalStateException("You must call RxActivityResult.register(application) before attempting to use startIntent");
            }
            this.clazz = t.getClass();
            this.uiTargetActivity = t instanceof Activity;
        }

        public Observable<Result<T>> startIntent(Intent intent) {
            Observable observable = Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<Result<T>>(){

                public void call(Subscriber<? super Result<T>> aSubscriber) {
                    Builder.this.subscriber = aSubscriber;
                }
            });
            OnResult onResult = this.uiTargetActivity ? this.onResultActivity() : this.onResultFragment();
            HolderActivity.setRequest(new Request(intent, onResult));
            activitiesLifecycle.getOLiveActivity().subscribe((Action1)new Action1<Activity>(){

                public void call(Activity activity) {
                    activity.startActivity(new Intent((Context)activity, HolderActivity.class));
                }
            });
            return observable;
        }

        private OnResult onResultActivity() {
            return new OnResult(){

                @Override
                public void response(int resultCode, Intent data) {
                    if (activitiesLifecycle.getLiveActivity() == null) {
                        return;
                    }
                    if (activitiesLifecycle.getLiveActivity().getClass() != Builder.this.clazz) {
                        return;
                    }
                    Activity activity = activitiesLifecycle.getLiveActivity();
                    Builder.this.subscriber.onNext(new Result<Activity>(activity, resultCode, data));
                    Builder.this.subscriber.onCompleted();
                }
            };
        }

        private OnResult onResultFragment() {
            return new OnResult(){

                @Override
                public void response(int resultCode, Intent data) {
                    if (activitiesLifecycle.getLiveActivity() == null) {
                        return;
                    }
                    Activity activity = activitiesLifecycle.getLiveActivity();
                    FragmentActivity fragmentActivity = (FragmentActivity)activity;
                    FragmentManager fragmentManager = fragmentActivity.getSupportFragmentManager();
                    List fragments = fragmentManager.getFragments();
                    if (fragments != null) {
                        for (Fragment fragment : fragments) {
                            if (fragment == null || !fragment.isVisible() || fragment.getClass() != Builder.this.clazz) continue;
                            Builder.this.subscriber.onNext(new Result<Fragment>(fragment, resultCode, data));
                            Builder.this.subscriber.onCompleted();
                            return;
                        }
                    }
                }
            };
        }
    }
}

