/*
 * Decompiled with CFR 0.152.
 */
package nl.fountain.xelem.lex;

import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import nl.fountain.xelem.excel.AutoFilter;
import nl.fountain.xelem.excel.Cell;
import nl.fountain.xelem.excel.Column;
import nl.fountain.xelem.excel.DocumentProperties;
import nl.fountain.xelem.excel.ExcelWorkbook;
import nl.fountain.xelem.excel.NamedRange;
import nl.fountain.xelem.excel.Row;
import nl.fountain.xelem.excel.Table;
import nl.fountain.xelem.excel.Worksheet;
import nl.fountain.xelem.excel.WorksheetOptions;
import nl.fountain.xelem.lex.ExcelReader;
import nl.fountain.xelem.lex.ExcelReaderListener;

public class ExcelReaderListenerTest
extends TestCase {
    protected boolean docStart;
    protected String sysId;
    protected int wbCounter;
    protected DocumentProperties props;
    protected int propsCounter;
    protected ExcelWorkbook excelWB;
    protected int excelWBCounter;
    protected NamedRange workbookNamedRange;
    protected int workbookNamedRangeCounter;
    protected String lastWorksheetName;
    protected int lastWorksheetIndex;
    protected int worksheetCounter;
    protected NamedRange worksheetNamedRange;
    protected int worksheetNamedRangeCounter;
    protected String lastWorksheetWithNamedRange;
    protected String lastSheetWithTable;
    protected int tableCounter;
    protected int lastExpandedRowCount;
    protected int lastExpandedColumnCount;
    protected int columnCounter;
    protected int lastColumnIndex;

    public static void main(String[] args) {
        TestRunner.run(ExcelReaderListenerTest.class);
    }

    public void testAddRemoveClearListener() throws Exception {
        ExcelReader xlReader = new ExcelReader();
        List<ExcelReaderListener> listeners = xlReader.getListeners();
        ExcelReaderListenerTest.assertEquals((int)0, (int)listeners.size());
        Listener listener = new Listener();
        xlReader.addExcelReaderListener(listener);
        ExcelReaderListenerTest.assertEquals((int)1, (int)listeners.size());
        xlReader.addExcelReaderListener(listener);
        ExcelReaderListenerTest.assertEquals((int)1, (int)listeners.size());
        Listener listener2 = new Listener();
        xlReader.addExcelReaderListener(listener2);
        ExcelReaderListenerTest.assertEquals((int)2, (int)listeners.size());
        ExcelReaderListenerTest.assertSame((Object)listener, (Object)listeners.get(0));
        ExcelReaderListenerTest.assertSame((Object)listener2, (Object)listeners.get(1));
        ExcelReaderListenerTest.assertTrue((boolean)xlReader.removeExcelReaderListener(listener));
        ExcelReaderListenerTest.assertFalse((boolean)xlReader.removeExcelReaderListener(new Listener()));
        ExcelReaderListenerTest.assertEquals((int)1, (int)listeners.size());
        xlReader.clearExcelReaderListeners();
        ExcelReaderListenerTest.assertEquals((int)0, (int)listeners.size());
    }

    public void testListener() throws Exception {
        ExcelReader xlReader = new ExcelReader();
        Listener listener = new Listener();
        xlReader.addExcelReaderListener(listener);
        xlReader.read("testsuitefiles/ReaderTest/reader.xml");
        ExcelReaderListenerTest.assertEquals((int)1, (int)this.wbCounter);
        ExcelReaderListenerTest.assertTrue((boolean)this.sysId.endsWith("testsuitefiles/ReaderTest/reader.xml"));
        ExcelReaderListenerTest.assertEquals((int)1, (int)this.propsCounter);
        ExcelReaderListenerTest.assertEquals((String)"Asterix", (String)this.props.getAuthor());
        ExcelReaderListenerTest.assertEquals((int)1, (int)this.excelWBCounter);
        ExcelReaderListenerTest.assertEquals((int)360, (int)this.excelWB.getWindowTopX());
        ExcelReaderListenerTest.assertEquals((int)1, (int)this.workbookNamedRangeCounter);
        ExcelReaderListenerTest.assertEquals((String)"='Tom Poes'!R9C4:R11C4", (String)this.workbookNamedRange.getRefersTo());
        ExcelReaderListenerTest.assertEquals((String)"foo", (String)this.workbookNamedRange.getName());
        ExcelReaderListenerTest.assertEquals((int)5, (int)this.worksheetCounter);
        ExcelReaderListenerTest.assertEquals((int)4, (int)this.lastWorksheetIndex);
        ExcelReaderListenerTest.assertEquals((String)"window", (String)this.lastWorksheetName);
        ExcelReaderListenerTest.assertEquals((int)1, (int)this.worksheetNamedRangeCounter);
        ExcelReaderListenerTest.assertEquals((String)"_FilterDatabase", (String)this.worksheetNamedRange.getName());
        ExcelReaderListenerTest.assertTrue((boolean)this.worksheetNamedRange.isHidden());
        ExcelReaderListenerTest.assertEquals((String)"Tom Poes", (String)this.lastWorksheetWithNamedRange);
        ExcelReaderListenerTest.assertEquals((int)4, (int)this.tableCounter);
        ExcelReaderListenerTest.assertEquals((String)"window", (String)this.lastSheetWithTable);
        ExcelReaderListenerTest.assertEquals((int)7, (int)this.lastExpandedRowCount);
        ExcelReaderListenerTest.assertEquals((int)4, (int)this.lastExpandedColumnCount);
        ExcelReaderListenerTest.assertEquals((int)6, (int)this.columnCounter);
        ExcelReaderListenerTest.assertEquals((int)16, (int)this.lastColumnIndex);
    }

    private class Listener
    implements ExcelReaderListener {
        private Listener() {
        }

        @Override
        public void startDocument() {
            ExcelReaderListenerTest.this.docStart = true;
        }

        @Override
        public void processingInstruction(String target, String data) {
            TestCase.assertTrue((boolean)ExcelReaderListenerTest.this.docStart);
        }

        @Override
        public void startWorkbook(String systemID) {
            ExcelReaderListenerTest.this.sysId = systemID;
            TestCase.assertTrue((boolean)ExcelReaderListenerTest.this.sysId.endsWith("testsuitefiles/ReaderTest/reader.xml"));
            ++ExcelReaderListenerTest.this.wbCounter;
        }

        @Override
        public void setDocumentProperties(DocumentProperties docprops) {
            ExcelReaderListenerTest.this.props = docprops;
            ++ExcelReaderListenerTest.this.propsCounter;
        }

        @Override
        public void setExcelWorkbook(ExcelWorkbook xlwb) {
            TestCase.assertEquals((String)"Asterix", (String)ExcelReaderListenerTest.this.props.getAuthor());
            ExcelReaderListenerTest.this.excelWB = xlwb;
            ++ExcelReaderListenerTest.this.excelWBCounter;
        }

        @Override
        public void setNamedRange(NamedRange nr) {
            TestCase.assertEquals((int)360, (int)ExcelReaderListenerTest.this.excelWB.getWindowTopX());
            ExcelReaderListenerTest.this.workbookNamedRange = nr;
            ++ExcelReaderListenerTest.this.workbookNamedRangeCounter;
        }

        @Override
        public void startWorksheet(int sheetIndex, Worksheet sheet) {
            ExcelReaderListenerTest.this.lastWorksheetIndex = sheetIndex;
            ExcelReaderListenerTest.this.lastWorksheetName = sheet.getName();
            ++ExcelReaderListenerTest.this.worksheetCounter;
        }

        @Override
        public void setNamedRange(int sheetIndex, String sheetName, NamedRange nr) {
            ExcelReaderListenerTest.this.lastWorksheetWithNamedRange = sheetName;
            ExcelReaderListenerTest.this.worksheetNamedRange = nr;
            ++ExcelReaderListenerTest.this.worksheetNamedRangeCounter;
        }

        @Override
        public void startTable(int sheetIndex, String sheetName, Table table) {
            ExcelReaderListenerTest.this.lastSheetWithTable = sheetName;
            ExcelReaderListenerTest.this.lastExpandedRowCount = table.getExpandedRowCount();
            ExcelReaderListenerTest.this.lastExpandedColumnCount = table.getExpandedColumnCount();
            ++ExcelReaderListenerTest.this.tableCounter;
        }

        @Override
        public void setColumn(int sheetIndex, String sheetName, Column column) {
            ExcelReaderListenerTest.this.lastColumnIndex = column.getIndex();
            ++ExcelReaderListenerTest.this.columnCounter;
        }

        @Override
        public void setRow(int sheetIndex, String sheetName, Row row) {
        }

        @Override
        public void setCell(int sheetIndex, String sheetName, int rowIndex, Cell cell) {
        }

        @Override
        public void setWorksheetOptions(int sheetIndex, String sheetName, WorksheetOptions wso) {
        }

        @Override
        public void setAutoFilter(int sheetIndex, String sheetName, AutoFilter autoFilter) {
        }

        @Override
        public void endWorksheet(int sheetIndex, String sheetName) {
            TestCase.assertEquals((int)ExcelReaderListenerTest.this.lastWorksheetIndex, (int)sheetIndex);
            TestCase.assertEquals((String)ExcelReaderListenerTest.this.lastWorksheetName, (String)sheetName);
        }

        @Override
        public void endDocument(Map<String, String> prefixMap) {
            TestCase.assertEquals((int)9, (int)prefixMap.size());
        }
    }
}

