/*
 * Decompiled with CFR 0.152.
 */
package nl.fountain.xelem.lex;

import java.util.ArrayList;
import java.util.List;
import nl.fountain.xelem.Area;
import nl.fountain.xelem.lex.AnonymousBuilder;
import nl.fountain.xelem.lex.ExcelReaderListener;
import nl.fountain.xelem.lex.SSCellBuilder;
import nl.fountain.xelem.lex.SSRowBuilder;
import nl.fountain.xelem.lex.SSWorksheetBuilder;
import nl.fountain.xelem.lex.XLWorkbookBuilder;

class Director {
    private XLWorkbookBuilder xlworkbookbuilder;
    private SSWorksheetBuilder ssworksheetbuilder;
    private SSRowBuilder ssrowbuilder;
    private SSCellBuilder sscellbuilder;
    private List<AnonymousBuilder> anonymousBuilders;
    private Area buildArea;
    private List<ExcelReaderListener> listeners;
    private int currentSheetIndex;
    private String currentSheetName;
    private int currentRowIndex;

    Director() {
    }

    public void setBuildArea(Area area) {
        this.buildArea = area;
    }

    public Area getBuildArea() {
        if (this.buildArea == null) {
            this.buildArea = new Area(1, 1, 65536, 256);
        }
        return this.buildArea;
    }

    public boolean hasBuildArea() {
        return this.buildArea != null;
    }

    public List<ExcelReaderListener> getListeners() {
        if (this.listeners == null) {
            this.listeners = new ArrayList<ExcelReaderListener>();
        }
        return this.listeners;
    }

    public void addExcelReaderListener(ExcelReaderListener l) {
        if (!this.getListeners().contains(l)) {
            this.getListeners().add(l);
        }
    }

    public boolean removeExcelReaderListener(ExcelReaderListener l) {
        return this.getListeners().remove(l);
    }

    public void clearExcelReaderListeners() {
        this.getListeners().clear();
    }

    public XLWorkbookBuilder getXLWorkbookBuilder() {
        if (this.xlworkbookbuilder == null) {
            this.xlworkbookbuilder = new XLWorkbookBuilder(this);
        }
        return this.xlworkbookbuilder;
    }

    public SSWorksheetBuilder getSSWorksheetBuilder() {
        if (this.ssworksheetbuilder == null) {
            this.ssworksheetbuilder = new SSWorksheetBuilder(this);
        }
        return this.ssworksheetbuilder;
    }

    public SSRowBuilder getSSRowBuilder() {
        if (this.ssrowbuilder == null) {
            this.ssrowbuilder = new SSRowBuilder(this);
        }
        return this.ssrowbuilder;
    }

    public SSCellBuilder getSSCellBuilder() {
        if (this.sscellbuilder == null) {
            this.sscellbuilder = new SSCellBuilder(this);
        }
        return this.sscellbuilder;
    }

    public AnonymousBuilder getAnonymousBuilder() {
        AnonymousBuilder aBuilder = null;
        for (AnonymousBuilder builder : this.getBuilders()) {
            if (builder.isOccupied()) continue;
            aBuilder = builder;
            break;
        }
        if (aBuilder == null) {
            aBuilder = new AnonymousBuilder(this);
            this.getBuilders().add(aBuilder);
        }
        aBuilder.setOccupied(true);
        return aBuilder;
    }

    void setCurrentSheetIndex(int index) {
        this.currentSheetIndex = index;
    }

    int getCurrentSheetIndex() {
        return this.currentSheetIndex;
    }

    void setCurrentSheetName(String name) {
        this.currentSheetName = name;
    }

    String getCurrentSheetName() {
        return this.currentSheetName;
    }

    void setCurrentRowIndex(int index) {
        this.currentRowIndex = index;
    }

    int getCurrentRowIndex() {
        return this.currentRowIndex;
    }

    private List<AnonymousBuilder> getBuilders() {
        if (this.anonymousBuilders == null) {
            this.anonymousBuilders = new ArrayList<AnonymousBuilder>();
        }
        return this.anonymousBuilders;
    }
}

