/*
 * Decompiled with CFR 0.152.
 */
package nl.fountain.xelem.excel.ss;

import java.util.Iterator;
import java.util.NoSuchElementException;
import junit.textui.TestRunner;
import nl.fountain.xelem.GIO;
import nl.fountain.xelem.UnsupportedStyleException;
import nl.fountain.xelem.XFactory;
import nl.fountain.xelem.excel.DocumentProperties;
import nl.fountain.xelem.excel.DuplicateNameException;
import nl.fountain.xelem.excel.Workbook;
import nl.fountain.xelem.excel.Worksheet;
import nl.fountain.xelem.excel.XLElementTest;
import nl.fountain.xelem.excel.ss.SSWorksheet;
import nl.fountain.xelem.excel.ss.XLWorkbook;

public class XLWorkbookTest
extends XLElementTest {
    private Workbook wb;

    public static void main(String[] args) {
        TestRunner.run(XLWorkbookTest.class);
    }

    protected void setUp() throws Exception {
        String configFileName = "testsuitefiles/XFactoryTest/XFactoryTest.xml";
        XFactory.setConfigurationFileName(configFileName);
        this.wb = new XLWorkbook("bestand");
    }

    public void testName() {
        XLWorkbook wb = new XLWorkbook(null);
        XLWorkbookTest.assertEquals((String)"null.xls", (String)wb.getFileName());
        wb = new XLWorkbook();
        XLWorkbookTest.assertEquals((String)".xls", (String)wb.getFileName());
    }

    public void testDocumentProperties() {
        String xml = this.xmlToString(this.wb, new GIO());
        XLWorkbookTest.assertEquals((int)-1, (int)xml.indexOf("<o:DocumentProperties"));
        DocumentProperties dp = this.wb.getDocumentProperties();
        dp.setAuthor(this.getName());
        xml = this.xmlToString(this.wb, new GIO());
        XLWorkbookTest.assertTrue((xml.indexOf("<o:Author>testDocumentProperties</o:Author>") > 0 ? 1 : 0) != 0);
    }

    public void testAddSheet() {
        SSWorksheet sheet1 = new SSWorksheet("Sheet foo");
        try {
            this.wb.addSheet(sheet1);
            this.wb.addSheet(sheet1);
            XLWorkbookTest.fail((String)"Er kan geen tweede worksheet met eenzelfde naam worden toegevoegd.");
        }
        catch (DuplicateNameException e) {
            XLWorkbookTest.assertEquals((String)"Duplicate name in worksheets collection: 'Sheet foo'.", (String)e.getMessage());
        }
    }

    public void testAddSheet_np() throws DuplicateNameException {
        Worksheet ws1 = this.wb.addSheet();
        Worksheet ws2 = this.wb.addSheet();
        Worksheet ws3 = this.wb.addSheet();
        XLWorkbookTest.assertSame((Object)ws1, (Object)this.wb.getWorksheet("Sheet1"));
        XLWorkbookTest.assertSame((Object)ws2, (Object)this.wb.getWorksheet("Sheet2"));
        XLWorkbookTest.assertSame((Object)ws3, (Object)this.wb.getWorksheet("Sheet3"));
        this.wb.addSheet("Sheet4");
        this.wb.addSheet("foo bar");
        Worksheet ws6 = this.wb.addSheet();
        XLWorkbookTest.assertSame((Object)ws6, (Object)this.wb.getWorksheet("Sheet6"));
    }

    public void testGetSheet() throws DuplicateNameException {
        XLWorkbookTest.assertNull((Object)this.wb.getWorksheet("bla"));
        SSWorksheet sheet1 = new SSWorksheet("Sheet1");
        SSWorksheet sheet2 = new SSWorksheet("Sheet2");
        this.wb.addSheet(sheet1);
        this.wb.addSheet(sheet2);
        XLWorkbookTest.assertSame((Object)sheet1, (Object)this.wb.getWorksheet("Sheet1"));
        XLWorkbookTest.assertSame((Object)sheet2, (Object)this.wb.getWorksheet("Sheet2"));
    }

    public void testOrderOfSheets() throws DuplicateNameException {
        Worksheet z = this.wb.addSheet("Z");
        Worksheet a = this.wb.addSheet("A");
        Worksheet p = this.wb.addSheet("P");
        Iterator<Worksheet> iter = this.wb.getWorksheets().iterator();
        XLWorkbookTest.assertSame((Object)z, (Object)iter.next());
        XLWorkbookTest.assertSame((Object)a, (Object)iter.next());
        XLWorkbookTest.assertSame((Object)p, (Object)iter.next());
        try {
            iter.next();
            XLWorkbookTest.fail((String)"past limit.");
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
    }

    public void testRemoveSheet() throws DuplicateNameException {
        XLWorkbookTest.assertNull((Object)this.wb.removeSheet("bla bla"));
        Worksheet ws1 = this.wb.addSheet("bla bla");
        XLWorkbookTest.assertSame((Object)ws1, (Object)this.wb.removeSheet("bla bla"));
    }

    public void testGetSheetAtIndex() {
        XLWorkbookTest.assertNull((Object)this.wb.getWorksheetAt(20));
    }

    public void testFilename() {
        XLWorkbookTest.assertEquals((String)"bestand.xls", (String)this.wb.getFileName());
        this.wb.setFileName("bestand.xml");
        XLWorkbookTest.assertEquals((String)"bestand.xml", (String)this.wb.getFileName());
    }

    public void testPrintComments() {
        XLWorkbookTest.assertTrue((boolean)this.wb.isPrintingElementComments());
        XLWorkbookTest.assertTrue((boolean)this.wb.isPrintingDocComments());
        this.wb.setPrintElementComments(false);
        XLWorkbookTest.assertTrue((!this.wb.isPrintingElementComments() ? 1 : 0) != 0);
        this.wb.setPrintDocComments(false);
        XLWorkbookTest.assertTrue((!this.wb.isPrintingDocComments() ? 1 : 0) != 0);
    }

    public void testMergeStyles() throws UnsupportedStyleException {
        this.wb.mergeStyles("wbNieuw", "b_yellow", "bold");
        this.wb.mergeStyles("wbNieuwer", "wbNieuw", "decimal2");
        this.wb.addSheet().addCell().setStyleID("wbNieuwer");
        String xml = this.xmlToString(this.wb, new GIO());
        XLWorkbookTest.assertTrue((xml.indexOf("<Style ss:ID=\"wbNieuwer\">") > 0 ? 1 : 0) != 0);
        XLWorkbookTest.assertTrue((xml.indexOf("<Interior ss:Color=\"#FFFF00\" ss:Pattern=\"Solid\"/>") > 0 ? 1 : 0) != 0);
        XLWorkbookTest.assertTrue((xml.indexOf("x:Family=\"Swiss\"") > 0 ? 1 : 0) != 0);
        XLWorkbookTest.assertTrue((xml.indexOf("<NumberFormat ss:Format=\"0.00\"/>") > 0 ? 1 : 0) != 0);
    }
}

