/*
 * Decompiled with CFR 0.152.
 */
package nl.fountain.xelem.excel.ss;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import nl.fountain.xelem.Address;
import nl.fountain.xelem.CellPointer;
import nl.fountain.xelem.GIO;
import nl.fountain.xelem.excel.AbstractXLElement;
import nl.fountain.xelem.excel.AutoFilter;
import nl.fountain.xelem.excel.Cell;
import nl.fountain.xelem.excel.Column;
import nl.fountain.xelem.excel.NamedRange;
import nl.fountain.xelem.excel.Row;
import nl.fountain.xelem.excel.Table;
import nl.fountain.xelem.excel.Worksheet;
import nl.fountain.xelem.excel.WorksheetOptions;
import nl.fountain.xelem.excel.ss.SSCell;
import nl.fountain.xelem.excel.ss.SSNamedRange;
import nl.fountain.xelem.excel.ss.SSTable;
import nl.fountain.xelem.excel.x.XAutoFilter;
import nl.fountain.xelem.excel.x.XWorksheetOptions;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;

public class SSWorksheet
extends AbstractXLElement
implements Worksheet {
    private CellPointer cellPointer;
    private String name;
    private boolean protect;
    private boolean righttoleft;
    private Map<String, NamedRange> namedRanges;
    private Table table;
    private WorksheetOptions options;
    private AutoFilter autoFilter;

    public SSWorksheet(String name) {
        this.name = name;
        this.cellPointer = new CellPointer();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getReferenceName() {
        if (this.name.indexOf(" ") > -1) {
            return "'" + this.name + "'";
        }
        return this.name;
    }

    @Override
    public void setProtected(boolean p) {
        this.protect = p;
    }

    private void setProtected(String s) {
        this.protect = s.equals("1");
    }

    @Override
    public boolean isProtected() {
        return this.protect;
    }

    @Override
    public void setRightToLeft(boolean r) {
        this.righttoleft = r;
    }

    private void setRightToLeft(String s) {
        this.righttoleft = s.equals("1");
    }

    @Override
    public boolean isRightToLeft() {
        return this.righttoleft;
    }

    @Override
    public NamedRange addNamedRange(NamedRange nr) {
        if (this.namedRanges == null) {
            this.namedRanges = new HashMap<String, NamedRange>();
        }
        this.namedRanges.put(nr.getName(), nr);
        return nr;
    }

    @Override
    public NamedRange addNamedRange(String name, String refersTo) {
        return this.addNamedRange(new SSNamedRange(name, refersTo));
    }

    @Override
    public Map<String, NamedRange> getNamedRanges() {
        if (this.namedRanges == null) {
            return Collections.emptyMap();
        }
        return this.namedRanges;
    }

    @Override
    public void setWorksheetOptions(WorksheetOptions wso) {
        this.options = wso;
    }

    @Override
    public boolean hasWorksheetOptions() {
        return this.options != null;
    }

    @Override
    public WorksheetOptions getWorksheetOptions() {
        if (this.options == null) {
            this.options = new XWorksheetOptions();
        }
        return this.options;
    }

    @Override
    public void setTable(Table table) {
        this.table = table;
    }

    @Override
    public Table getTable() {
        if (this.table == null) {
            this.table = new SSTable();
        }
        return this.table;
    }

    @Override
    public boolean hasTable() {
        return this.table != null;
    }

    @Override
    public CellPointer getCellPointer() {
        return this.cellPointer;
    }

    @Override
    public Cell addCell() {
        return this.addCell(new SSCell());
    }

    @Override
    public Cell addCell(Cell cell) {
        int prevRow = this.cellPointer.getRowIndex();
        int prevColumn = this.cellPointer.getColumnIndex();
        this.cellPointer.move();
        this.getTable().getRowAt(prevRow).addCellAt(prevColumn, cell);
        return cell;
    }

    @Override
    public Cell addCell(Object data) {
        Cell cell = this.addCell();
        cell.setData(data);
        return cell;
    }

    @Override
    public Cell addCell(Object data, String styleID) {
        Cell cell = this.addCell(data);
        cell.setStyleID(styleID);
        return cell;
    }

    @Override
    public Cell addCell(double data) {
        Cell cell = this.addCell();
        cell.setData(data);
        return cell;
    }

    @Override
    public Cell addCell(double data, String styleID) {
        Cell cell = this.addCell(data);
        cell.setStyleID(styleID);
        return cell;
    }

    @Override
    public Cell addCell(int data) {
        Cell cell = this.addCell();
        cell.setData(data);
        return cell;
    }

    @Override
    public Cell addCell(int data, String styleID) {
        Cell cell = this.addCell(data);
        cell.setStyleID(styleID);
        return cell;
    }

    @Override
    public Cell addCellAt(Address address) {
        return this.addCellAt(address.getRowIndex(), address.getColumnIndex());
    }

    @Override
    public Cell addCellAt(int rowIndex, int columnIndex) {
        this.cellPointer.moveTo(rowIndex, columnIndex);
        return this.addCell();
    }

    @Override
    public Cell addCellAt(String a1_ref) {
        return this.addCellAt(Address.calculateRow(a1_ref), Address.calculateColumn(a1_ref));
    }

    @Override
    public Cell addCellAt(Address address, Cell cell) {
        return this.addCellAt(address.getRowIndex(), address.getColumnIndex(), cell);
    }

    @Override
    public Cell addCellAt(int rowIndex, int columnIndex, Cell cell) {
        this.cellPointer.moveTo(rowIndex, columnIndex);
        return this.addCell(cell);
    }

    @Override
    public Cell addCellAt(String a1_ref, Cell cell) {
        return this.addCellAt(Address.calculateRow(a1_ref), Address.calculateColumn(a1_ref), cell);
    }

    @Override
    public Cell getCellAt(Address address) {
        return this.getCellAt(address.getRowIndex(), address.getColumnIndex());
    }

    @Override
    public Cell getCellAt(int rowIndex, int columnIndex) {
        Row row = this.getTable().getRowAt(rowIndex);
        return row.getCellAt(columnIndex);
    }

    @Override
    public Cell getCellAt(String a1_ref) {
        return this.getCellAt(Address.calculateRow(a1_ref), Address.calculateColumn(a1_ref));
    }

    @Override
    public Cell removeCellAt(Address address) {
        return this.removeCellAt(address.getRowIndex(), address.getColumnIndex());
    }

    @Override
    public Cell removeCellAt(int rowIndex, int columnIndex) {
        Row row = this.getTable().getRowAt(rowIndex);
        if (row == null) {
            return null;
        }
        return row.removeCellAt(columnIndex);
    }

    @Override
    public Cell removeCellAt(String a1_ref) {
        return this.removeCellAt(Address.calculateRow(a1_ref), Address.calculateColumn(a1_ref));
    }

    @Override
    public boolean hasCellAt(Address address) {
        return this.hasCellAt(address.getRowIndex(), address.getColumnIndex());
    }

    @Override
    public boolean hasCellAt(int rowIndex, int columnIndex) {
        if (!this.hasTable()) {
            return false;
        }
        if (!this.getTable().hasRowAt(rowIndex)) {
            return false;
        }
        return this.getTable().getRowAt(rowIndex).getCellAt(columnIndex) != null;
    }

    @Override
    public boolean hasCellAt(String a1_ref) {
        return this.hasCellAt(Address.calculateRow(a1_ref), Address.calculateColumn(a1_ref));
    }

    @Override
    public Row addRow() {
        return this.getTable().addRow();
    }

    @Override
    public Row addRowAt(int rowIndex) {
        return this.getTable().addRowAt(rowIndex);
    }

    @Override
    public Row addRow(Row row) {
        return this.getTable().addRow(row);
    }

    @Override
    public Row addRowAt(int index, Row row) {
        return this.getTable().addRowAt(index, row);
    }

    @Override
    public Row removeRowAt(int rowIndex) {
        return this.getTable().removeRowAt(rowIndex);
    }

    @Override
    public Collection<Row> getRows() {
        return this.getTable().getRows();
    }

    @Override
    public Row getRowAt(int rowIndex) {
        return this.getTable().getRowAt(rowIndex);
    }

    @Override
    public boolean hasRowAt(int rowIndex) {
        if (!this.hasTable()) {
            return false;
        }
        return this.getTable().hasRowAt(rowIndex);
    }

    @Override
    public Column addColumn() {
        return this.getTable().addColumn();
    }

    @Override
    public Column addColumnAt(int index) {
        return this.getTable().addColumnAt(index);
    }

    @Override
    public Column addColumnAt(String label) {
        return this.getTable().addColumnAt(Address.calculateColumn(label));
    }

    @Override
    public Column addColumn(Column column) {
        return this.getTable().addColumn(column);
    }

    @Override
    public Column addColumnAt(int index, Column column) {
        return this.getTable().addColumnAt(index, column);
    }

    @Override
    public Column addColumnAt(String label, Column column) {
        return this.getTable().addColumnAt(Address.calculateColumn(label));
    }

    @Override
    public Column removeColumnAt(int columnIndex) {
        return this.getTable().removeColumnAt(columnIndex);
    }

    @Override
    public Column removeColumnAt(String label) {
        return this.getTable().removeColumnAt(Address.calculateColumn(label));
    }

    @Override
    public Collection<Column> getColumns() {
        return this.getTable().getColumns();
    }

    @Override
    public Column getColumnAt(int columnIndex) {
        return this.getTable().getColumnAt(columnIndex);
    }

    @Override
    public Column getColumnAt(String label) {
        return this.getTable().getColumnAt(Address.calculateColumn(label));
    }

    @Override
    public boolean hasColumnAt(int columnIndex) {
        if (!this.hasTable()) {
            return false;
        }
        return this.getTable().hasColumnAt(columnIndex);
    }

    @Override
    public boolean hasColumnAt(String label) {
        return this.getTable().hasColumnAt(Address.calculateColumn(label));
    }

    @Override
    public String getTagName() {
        return "Worksheet";
    }

    @Override
    public String getNameSpace() {
        return "urn:schemas-microsoft-com:office:spreadsheet";
    }

    @Override
    public String getPrefix() {
        return "ss";
    }

    @Override
    public void setAutoFilter(AutoFilter af) {
        this.autoFilter = af;
    }

    @Override
    public void setAutoFilter(String rcString) {
        this.autoFilter = new XAutoFilter();
        this.autoFilter.setRange(rcString);
    }

    @Override
    public boolean hasAutoFilter() {
        return this.autoFilter != null;
    }

    @Override
    public void removeAutoFilter() {
        this.autoFilter = null;
    }

    @Override
    public Element assemble(Element parent, GIO gio) {
        Document doc = parent.getOwnerDocument();
        Element wse = this.assemble(doc, gio);
        wse.setAttributeNodeNS(this.createAttributeNS(doc, "Name", this.getName()));
        if (this.protect) {
            wse.setAttributeNodeNS(this.createAttributeNS(doc, "Protected", "1"));
        }
        if (this.righttoleft) {
            wse.setAttributeNodeNS(this.createAttributeNS(doc, "RightToLeft", "1"));
        }
        parent.appendChild(wse);
        if (this.namedRanges != null) {
            Element names = doc.createElement("Names");
            wse.appendChild(names);
            for (NamedRange nr : this.namedRanges.values()) {
                nr.assemble(names, gio);
            }
        }
        if (this.hasTable()) {
            this.getTable().assemble(wse, gio);
        }
        if (this.hasWorksheetOptions()) {
            this.getWorksheetOptions().assemble(wse, gio);
        }
        if (this.hasAutoFilter()) {
            this.autoFilter.assemble(wse, gio);
        }
        return wse;
    }

    @Override
    public void setAttributes(Attributes attrs) {
        for (int i = 0; i < attrs.getLength(); ++i) {
            this.invokeMethod(attrs.getLocalName(i), attrs.getValue(i));
        }
    }

    private void invokeMethod(String name, Object value) {
        Class[] types = new Class[]{value.getClass()};
        Method method = null;
        try {
            method = this.getClass().getDeclaredMethod("set" + name, types);
            method.invoke((Object)this, value);
        }
        catch (NoSuchMethodException e) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

