/*
 * Decompiled with CFR 0.152.
 */
package nl.fountain.xelem.excel.ss;

import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Iterator;
import java.util.TreeMap;
import nl.fountain.xelem.GIO;
import nl.fountain.xelem.excel.AbstractXLElement;
import nl.fountain.xelem.excel.Cell;
import nl.fountain.xelem.excel.Row;
import nl.fountain.xelem.excel.ss.SSCell;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;

public class SSRow
extends AbstractXLElement
implements Row {
    TreeMap<Integer, Cell> cells = new TreeMap();
    private int idx;
    private String styleID;
    private double height = -1.0;
    private int span;
    private boolean hidden;

    @Override
    public void setStyleID(String id) {
        this.styleID = id;
    }

    @Override
    public String getStyleID() {
        return this.styleID;
    }

    @Override
    public void setHeight(double h) {
        this.height = h;
    }

    private void setHeight(String s) {
        this.height = Double.parseDouble(s);
    }

    @Override
    public double getHeight() {
        return this.height;
    }

    @Override
    public void setSpan(int s) {
        this.span = s;
    }

    private void setSpan(String s) {
        this.span = Integer.parseInt(s);
    }

    @Override
    public int getSpan() {
        return this.span;
    }

    @Override
    public void setHidden(boolean hide) {
        this.hidden = hide;
    }

    private void setHidden(String s) {
        this.hidden = s.equals("1");
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }

    @Override
    public Cell addCell() {
        return this.addCellAt(this.maxCellIndex() + 1, new SSCell());
    }

    @Override
    public Cell addCell(Object data) {
        SSCell cell = new SSCell();
        cell.setData(data);
        return this.addCellAt(this.maxCellIndex() + 1, cell);
    }

    @Override
    public Cell addCell(Object data, String styleID) {
        SSCell cell = new SSCell();
        cell.setData(data);
        cell.setStyleID(styleID);
        return this.addCellAt(this.maxCellIndex() + 1, cell);
    }

    @Override
    public Cell addCell(double data) {
        SSCell cell = new SSCell();
        cell.setData(data);
        return this.addCellAt(this.maxCellIndex() + 1, cell);
    }

    @Override
    public Cell addCell(double data, String styleID) {
        SSCell cell = new SSCell();
        cell.setData(data);
        cell.setStyleID(styleID);
        return this.addCellAt(this.maxCellIndex() + 1, cell);
    }

    @Override
    public Cell addCell(BigDecimal data) {
        SSCell cell = new SSCell();
        cell.setData(data);
        return this.addCellAt(this.maxCellIndex() + 1, cell);
    }

    @Override
    public Cell addCell(int data) {
        SSCell cell = new SSCell();
        cell.setData(data);
        return this.addCellAt(this.maxCellIndex() + 1, cell);
    }

    @Override
    public Cell addCell(int data, String styleID) {
        SSCell cell = new SSCell();
        cell.setData(data);
        cell.setStyleID(styleID);
        return this.addCellAt(this.maxCellIndex() + 1, cell);
    }

    @Override
    public Cell addCellAt(int index) {
        return this.addCellAt(index, new SSCell());
    }

    @Override
    public Cell addCell(Cell cell) {
        return this.addCellAt(this.maxCellIndex() + 1, cell);
    }

    @Override
    public Cell addCellAt(int index, Cell cell) {
        if (index < 1 || index > 256) {
            throw new IndexOutOfBoundsException("columnIndex = " + index);
        }
        this.cells.put(new Integer(index), cell);
        return cell;
    }

    @Override
    public Cell removeCellAt(int index) {
        return this.cells.remove(new Integer(index));
    }

    @Override
    public Collection<Cell> getCells() {
        return this.cells.values();
    }

    @Override
    public Cell getCellAt(int index) {
        if (!this.hasCellAt(index)) {
            return this.addCellAt(index);
        }
        return this.cells.get(new Integer(index));
    }

    @Override
    public boolean hasCellAt(int index) {
        return this.cells.get(new Integer(index)) != null;
    }

    @Override
    public int size() {
        return this.cells.size();
    }

    @Override
    public TreeMap<Integer, Cell> getCellMap() {
        return this.cells;
    }

    @Override
    public int maxCellIndex() {
        int lastKey = this.cells.size() == 0 ? 0 : this.cells.lastKey();
        return lastKey;
    }

    @Override
    public String getTagName() {
        return "Row";
    }

    @Override
    public String getNameSpace() {
        return "urn:schemas-microsoft-com:office:spreadsheet";
    }

    @Override
    public String getPrefix() {
        return "ss";
    }

    @Override
    public Iterator<Cell> cellIterator() {
        return new CellIterator();
    }

    @Override
    public Element assemble(Element parent, GIO gio) {
        Document doc = parent.getOwnerDocument();
        Element re = this.assemble(doc, gio);
        if (this.idx != 0) {
            re.setAttributeNodeNS(this.createAttributeNS(doc, "Index", this.idx));
        }
        if (this.getStyleID() != null) {
            re.setAttributeNodeNS(this.createAttributeNS(doc, "StyleID", this.getStyleID()));
            gio.addStyleID(this.getStyleID());
        }
        if (this.span > 0) {
            re.setAttributeNodeNS(this.createAttributeNS(doc, "Span", this.span));
        }
        this.setAdditionalAttributes(doc, re);
        parent.appendChild(re);
        Iterator<Cell> iter = this.cellIterator();
        while (iter.hasNext()) {
            Cell cell = iter.next();
            cell.assemble(re, gio);
        }
        return re;
    }

    private void setAdditionalAttributes(Document doc, Element rowElement) {
        if (this.height > 0.0) {
            rowElement.setAttributeNodeNS(this.createAttributeNS(doc, "Height", "" + this.height));
        }
        if (this.hidden) {
            rowElement.setAttributeNodeNS(this.createAttributeNS(doc, "Hidden", "1"));
        }
    }

    @Override
    public Element createElement(Document doc) {
        GIO gio = new GIO();
        Element rowElement = doc.createElementNS(this.getNameSpace(), this.getTagName());
        if (this.getStyleID() != null) {
            rowElement.setAttributeNodeNS(this.createAttributeNS(doc, "StyleID", this.getStyleID()));
        }
        this.setAdditionalAttributes(doc, rowElement);
        Iterator<Cell> iter = this.cellIterator();
        while (iter.hasNext()) {
            iter.next().assemble(rowElement, gio);
        }
        return rowElement;
    }

    @Override
    public void setAttributes(Attributes attrs) {
        for (int i = 0; i < attrs.getLength(); ++i) {
            this.invokeMethod(attrs.getLocalName(i), attrs.getValue(i));
        }
    }

    private void invokeMethod(String name, Object value) {
        Class[] types = new Class[]{value.getClass()};
        Method method = null;
        try {
            method = this.getClass().getDeclaredMethod("set" + name, types);
            method.invoke((Object)this, value);
        }
        catch (NoSuchMethodException e) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setIndex(int index) {
        this.idx = index;
    }

    @Override
    public int getIndex() {
        return this.idx;
    }

    private class CellIterator
    implements Iterator<Cell> {
        private Iterator<Integer> cit;
        private Integer current;
        private int prevIndex;

        protected CellIterator() {
            this.cit = SSRow.this.cells.keySet().iterator();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return this.cit.hasNext();
        }

        @Override
        public Cell next() {
            this.current = this.cit.next();
            int curIndex = this.current;
            SSCell c = (SSCell)SSRow.this.cells.get(this.current);
            if (this.prevIndex + 1 != curIndex) {
                c.setIndex(curIndex);
            } else {
                c.setIndex(0);
            }
            this.prevIndex = curIndex;
            return c;
        }
    }
}

