/*
 * Decompiled with CFR 0.152.
 */
package nl.fountain.xelem.excel.ss;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Locale;
import junit.textui.TestRunner;
import nl.fountain.xelem.GIO;
import nl.fountain.xelem.XLUtil;
import nl.fountain.xelem.excel.XLElementTest;
import nl.fountain.xelem.excel.ss.SSCell;

public class SSCellTest
extends XLElementTest {
    private SSCell cell;

    public static void main(String[] args) {
        TestRunner.run(SSCellTest.class);
    }

    protected void setUp() {
        this.cell = new SSCell();
    }

    public void testDatatype() {
        SSCellTest.assertEquals((String)"String", (String)this.cell.getXLDataType());
        SSCellTest.assertEquals((String)"", (String)this.cell.getData$());
    }

    public void testDataTypeNumber() {
        this.cell.setData(new Integer(9));
        SSCellTest.assertEquals((String)"Number", (String)this.cell.getXLDataType());
        SSCellTest.assertEquals((String)"9", (String)this.cell.getData$());
        this.cell.setData(new Double(1.23456));
        SSCellTest.assertEquals((String)"Number", (String)this.cell.getXLDataType());
        SSCellTest.assertEquals((String)"1.23456", (String)this.cell.getData$());
        this.cell.setData(new Long(123456789L));
        SSCellTest.assertEquals((String)"Number", (String)this.cell.getXLDataType());
        SSCellTest.assertEquals((String)"123456789", (String)this.cell.getData$());
        this.cell.setData(new Float(123.45679f));
        SSCellTest.assertEquals((String)"Number", (String)this.cell.getXLDataType());
        SSCellTest.assertEquals((String)"123.45679", (String)this.cell.getData$());
        Integer integer = new Integer(9);
        this.cell.setData((Object)integer);
        SSCellTest.assertEquals((String)"Number", (String)this.cell.getXLDataType());
        SSCellTest.assertEquals((String)"9", (String)this.cell.getData$());
        Double dubbel = new Double(1.23456);
        this.cell.setData((Object)dubbel);
        SSCellTest.assertEquals((String)"Number", (String)this.cell.getXLDataType());
        SSCellTest.assertEquals((String)"1.23456", (String)this.cell.getData$());
        Long lang = new Long(123456789L);
        this.cell.setData((Object)lang);
        SSCellTest.assertEquals((String)"Number", (String)this.cell.getXLDataType());
        SSCellTest.assertEquals((String)"123456789", (String)this.cell.getData$());
        Float drijf = new Float(123.45679f);
        this.cell.setData((Object)drijf);
        SSCellTest.assertEquals((String)"Number", (String)this.cell.getXLDataType());
        SSCellTest.assertEquals((String)"123.45679", (String)this.cell.getData$());
        this.cell.setData(8);
        SSCellTest.assertEquals((String)"Number", (String)this.cell.getXLDataType());
        SSCellTest.assertEquals((String)"8", (String)this.cell.getData$());
        this.cell.setData(5.0E-4);
        SSCellTest.assertEquals((String)"Number", (String)this.cell.getXLDataType());
        SSCellTest.assertEquals((String)"5.0E-4", (String)this.cell.getData$());
        this.cell.setData(Long.MAX_VALUE);
        SSCellTest.assertEquals((String)"Number", (String)this.cell.getXLDataType());
        SSCellTest.assertEquals((String)"9223372036854775807", (String)this.cell.getData$());
        BigDecimal n = null;
        this.cell.setData((Number)n);
        SSCellTest.assertEquals((String)"Error", (String)this.cell.getXLDataType());
        SSCellTest.assertEquals((String)"#N/A", (String)this.cell.getData$());
        SSCellTest.assertEquals((String)"=#N/A", (String)this.cell.getFormula());
        n = new BigDecimal(123456.789);
        this.cell.setData((Number)n);
        SSCellTest.assertEquals((String)"Number", (String)this.cell.getXLDataType());
        SSCellTest.assertEquals((String)"123456.789", (String)this.cell.getData$().substring(0, 10));
    }

    public void testDataTypeDate() {
        Date date = new Date(123456789L);
        SSCellTest.assertEquals((String)"1970-01-02T11:17:36.789", (String)XLUtil.format(date));
        this.cell.setData(date);
        SSCellTest.assertEquals((String)"DateTime", (String)this.cell.getXLDataType());
        SSCellTest.assertEquals((String)"1970-01-02T11:17:36.789", (String)this.cell.getData$());
        Date datum = new Date(123456789L);
        SSCellTest.assertEquals((String)"1970-01-02T11:17:36.789", (String)XLUtil.format(datum));
        this.cell.setData((Object)datum);
        SSCellTest.assertEquals((String)"DateTime", (String)this.cell.getXLDataType());
        SSCellTest.assertEquals((String)"1970-01-02T11:17:36.789", (String)this.cell.getData$());
        Date d = null;
        this.cell.setData(d);
        SSCellTest.assertEquals((String)"Error", (String)this.cell.getXLDataType());
        SSCellTest.assertEquals((String)"#N/A", (String)this.cell.getData$());
        SSCellTest.assertEquals((String)"=#N/A", (String)this.cell.getFormula());
    }

    public void testDataTypeBoolean() {
        this.cell.setData(new Boolean(true));
        SSCellTest.assertEquals((String)"Boolean", (String)this.cell.getXLDataType());
        SSCellTest.assertEquals((String)"1", (String)this.cell.getData$());
        this.cell.setData(new Boolean(false));
        SSCellTest.assertEquals((String)"Boolean", (String)this.cell.getXLDataType());
        SSCellTest.assertEquals((String)"0", (String)this.cell.getData$());
        this.cell.setData(true);
        SSCellTest.assertEquals((String)"Boolean", (String)this.cell.getXLDataType());
        SSCellTest.assertEquals((String)"1", (String)this.cell.getData$());
        this.cell.setData(false);
        SSCellTest.assertEquals((String)"Boolean", (String)this.cell.getXLDataType());
        SSCellTest.assertEquals((String)"0", (String)this.cell.getData$());
        Boolean boo = new Boolean(true);
        this.cell.setData((Object)boo);
        SSCellTest.assertEquals((String)"Boolean", (String)this.cell.getXLDataType());
        SSCellTest.assertEquals((String)"1", (String)this.cell.getData$());
        Boolean b = null;
        this.cell.setData(b);
        SSCellTest.assertEquals((String)"Error", (String)this.cell.getXLDataType());
        SSCellTest.assertEquals((String)"#N/A", (String)this.cell.getData$());
        SSCellTest.assertEquals((String)"=#N/A", (String)this.cell.getFormula());
    }

    public void testDataTypeString() {
        this.cell.setData("bla bla");
        SSCellTest.assertEquals((String)"String", (String)this.cell.getXLDataType());
        SSCellTest.assertEquals((String)"bla bla", (String)this.cell.getData$());
        this.cell.setData(new Locale("nl"));
        SSCellTest.assertEquals((String)"String", (String)this.cell.getXLDataType());
        SSCellTest.assertEquals((String)"nl", (String)this.cell.getData$());
        this.cell.setData("\"heden\"");
        SSCellTest.assertEquals((String)"String", (String)this.cell.getXLDataType());
        SSCellTest.assertEquals((String)"\"heden\"", (String)this.cell.getData$());
        this.cell.setData("'heden' & v < g & g > v");
        SSCellTest.assertEquals((String)"String", (String)this.cell.getXLDataType());
        SSCellTest.assertEquals((String)"'heden' & v < g & g > v", (String)this.cell.getData$());
        this.cell.setData('c');
        SSCellTest.assertEquals((String)"String", (String)this.cell.getXLDataType());
        SSCellTest.assertEquals((String)"c", (String)this.cell.getData$());
        this.cell.setData('&');
        SSCellTest.assertEquals((String)"String", (String)this.cell.getXLDataType());
        SSCellTest.assertEquals((String)"&", (String)this.cell.getData$());
        String s = null;
        this.cell.setData(s);
        SSCellTest.assertEquals((String)"Error", (String)this.cell.getXLDataType());
        SSCellTest.assertEquals((String)"#N/A", (String)this.cell.getData$());
        SSCellTest.assertEquals((String)"=#N/A", (String)this.cell.getFormula());
    }

    public void testDataTypeError() {
        this.cell.setError("#N/A");
        SSCellTest.assertEquals((String)"Error", (String)this.cell.getXLDataType());
        SSCellTest.assertEquals((String)"#N/A", (String)this.cell.getData$());
        SSCellTest.assertEquals((String)"=#N/A", (String)this.cell.getFormula());
    }

    public void testSetHRef() {
        this.cell.setHRef("http://www.microsoft.com/downloads/details.aspx?familyid=fe118952-3547-420a-a412-00a2662442d9&displaylang=en");
        SSCellTest.assertEquals((String)"http://www.microsoft.com/downloads/details.aspx?familyid=fe118952-3547-420a-a412-00a2662442d9&displaylang=en", (String)this.cell.getHRef());
    }

    public void testSetStyleID() {
        this.cell.setStyleID("foo");
        SSCellTest.assertEquals((String)"foo", (String)this.cell.getStyleID());
    }

    public void testInfinity() {
        this.cell.setData(Double.POSITIVE_INFINITY);
        SSCellTest.assertEquals((String)"Infinity", (String)this.cell.getData$());
        SSCellTest.assertEquals((String)"String", (String)this.cell.getXLDataType());
    }

    public void testAssembleStyle() {
        this.cell.setStyleID("foo");
        GIO gio = new GIO();
        String xml = this.xmlToString(this.cell, gio);
        SSCellTest.assertTrue((xml.indexOf("<ss:Cell ss:StyleID=\"foo\"/>") > 0 ? 1 : 0) != 0);
        SSCellTest.assertEquals((int)1, (int)gio.getStyleIDSet().size());
        SSCellTest.assertEquals((String)"foo", (String)gio.getStyleIDSet().iterator().next());
    }

    public void testAssembleData() {
        this.cell.setData(false);
        GIO gio = new GIO();
        String xml = this.xmlToString(this.cell, gio);
        SSCellTest.assertTrue((xml.indexOf("<Data ss:Type=\"Boolean\">0</Data>") > 0 ? 1 : 0) != 0);
        SSCellTest.assertEquals((int)0, (int)gio.getStyleIDSet().size());
    }

    public void testGetData() {
        SSCell cell = new SSCell();
        cell.setData(true);
        SSCellTest.assertEquals(Boolean.class, cell.getData().getClass());
        Boolean boo = (Boolean)cell.getData();
        SSCellTest.assertTrue((boolean)boo);
        cell.setData(new Boolean(false));
        SSCellTest.assertEquals(Boolean.class, cell.getData().getClass());
        boo = (Boolean)cell.getData();
        SSCellTest.assertTrue((boo == false ? 1 : 0) != 0);
        byte b = 5;
        cell.setData(b);
        SSCellTest.assertEquals(Double.class, cell.getData().getClass());
        Double doo = (Double)cell.getData();
        SSCellTest.assertEquals((int)5, (int)doo.intValue());
        char c = '\n';
        cell.setData(c);
        SSCellTest.assertEquals(String.class, cell.getData().getClass());
        SSCellTest.assertEquals((Object)"\n", (Object)cell.getData());
        cell.setData(new Date(123456789L));
        SSCellTest.assertEquals(Date.class, cell.getData().getClass());
        Date date = (Date)cell.getData();
        SSCellTest.assertEquals((long)123456000L, (long)date.getTime());
        BigDecimal big = new BigDecimal(Double.MAX_VALUE).add(new BigDecimal(Double.MAX_VALUE));
        cell.setData(big);
        SSCellTest.assertEquals((Object)"Infinity", (Object)cell.getData());
        doo = new Double(cell.getData().toString());
        SSCellTest.assertTrue((boolean)doo.isInfinite());
        SSCellTest.assertTrue((doo > Double.MAX_VALUE ? 1 : 0) != 0);
        cell.setData((double)Double.MAX_VALUE);
        SSCellTest.assertEquals(Double.class, cell.getData().getClass());
        doo = (Double)cell.getData();
        SSCellTest.assertEquals((double)Double.MAX_VALUE, (double)doo, (double)0.0);
        Object obj = null;
        cell.setData((Object)obj);
        SSCellTest.assertEquals((Object)"#N/A", (Object)cell.getData());
        SSCellTest.assertTrue((boolean)cell.hasError());
        cell.setData(cell);
        SSCellTest.assertEquals((Object)cell.toString(), (Object)cell.getData());
    }

    public void testIntValue() {
        SSCell cell = new SSCell();
        SSCellTest.assertEquals((int)0, (int)cell.intValue());
        cell.setData(5.499999);
        SSCellTest.assertEquals((int)5, (int)cell.intValue());
        Double doo = null;
        cell.setData(doo);
        SSCellTest.assertEquals((int)0, (int)cell.intValue());
        SSCellTest.assertTrue((boolean)cell.hasError());
        cell.setData("123.456");
        SSCellTest.assertEquals((int)123, (int)cell.intValue());
    }

    public void testDoubleValue() {
        SSCell cell = new SSCell();
        SSCellTest.assertEquals((double)0.0, (double)cell.doubleValue(), (double)0.0);
        cell.setData((double)Double.MIN_VALUE);
        SSCellTest.assertEquals((double)Double.MIN_VALUE, (double)cell.doubleValue(), (double)0.0);
        cell.setData(Double.NaN);
        SSCellTest.assertEquals((String)"NaN", (String)(cell.doubleValue() + ""));
        cell.setData(Double.NEGATIVE_INFINITY);
        SSCellTest.assertEquals((String)"-Infinity", (String)(cell.doubleValue() + ""));
    }

    public void testBooleanValue() {
        SSCell cell = new SSCell();
        SSCellTest.assertFalse((boolean)cell.booleanValue());
        cell.setData(true);
        SSCellTest.assertTrue((boolean)cell.booleanValue());
        cell.setData("1");
        SSCellTest.assertTrue((boolean)cell.booleanValue());
        cell.setData(1);
        SSCellTest.assertTrue((boolean)cell.booleanValue());
        cell.setData(0);
        SSCellTest.assertFalse((boolean)cell.booleanValue());
        cell.setData("True");
        SSCellTest.assertFalse((boolean)cell.booleanValue());
    }
}

