/*
 * Decompiled with CFR 0.152.
 */
package nl.fountain.xelem;

import java.io.File;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import nl.fountain.xelem.XelemException;
import nl.fountain.xelem.excel.Workbook;
import org.w3c.dom.Document;

public class XSerializer {
    private Transformer xformer;
    private String encoding;
    public static final String US_ASCII = "US-ASCII";

    public XSerializer() {
    }

    public XSerializer(String encoding) {
        this.encoding = encoding;
    }

    public String serializeToString(Workbook wb) throws XelemException {
        StringWriter out = new StringWriter();
        this.serialize(wb, (Writer)out);
        return out.toString();
    }

    public String serializeToString(Document doc) throws XelemException {
        StringWriter out = new StringWriter();
        this.serialize(doc, (Writer)out);
        return out.toString();
    }

    public void serialize(Workbook wb) throws XelemException {
        File out = new File(wb.getFileName());
        this.serialize(wb, out);
    }

    public void serialize(Workbook wb, File out) throws XelemException {
        StreamResult result = new StreamResult(out);
        this.transform(wb, (Result)result);
    }

    public void serialize(Document doc, File out) throws XelemException {
        StreamResult result = new StreamResult(out);
        this.transform(doc, (Result)result);
    }

    public void serialize(Workbook wb, OutputStream out) throws XelemException {
        StreamResult result = new StreamResult(out);
        this.transform(wb, (Result)result);
    }

    public void serialize(Document doc, OutputStream out) throws XelemException {
        StreamResult result = new StreamResult(out);
        this.transform(doc, (Result)result);
    }

    public void serialize(Workbook wb, Writer out) throws XelemException {
        StreamResult result = new StreamResult(out);
        this.transform(wb, (Result)result);
    }

    public void serialize(Document doc, Writer out) throws XelemException {
        StreamResult result = new StreamResult(out);
        this.transform(doc, (Result)result);
    }

    private void transform(Workbook wb, Result result) throws XelemException {
        try {
            Document doc = wb.createDocument();
            this.transform(doc, result);
        }
        catch (ParserConfigurationException e) {
            throw new XelemException(e.fillInStackTrace());
        }
    }

    private void transform(Document doc, Result result) throws XelemException {
        try {
            Transformer xformer = this.getTransformer();
            DOMSource source = new DOMSource(doc);
            xformer.transform(source, result);
        }
        catch (TransformerException e) {
            throw new XelemException(e.fillInStackTrace());
        }
    }

    private Transformer getTransformer() throws XelemException {
        if (this.xformer == null) {
            TransformerFactory tFactory = TransformerFactory.newInstance();
            try {
                this.xformer = tFactory.newTransformer();
            }
            catch (TransformerConfigurationException e) {
                throw new XelemException(e.fillInStackTrace());
            }
            this.xformer.setOutputProperty("method", "xml");
            this.xformer.setOutputProperty("indent", "yes");
            if (this.encoding != null) {
                this.xformer.setOutputProperty("encoding", this.encoding);
            }
        }
        return this.xformer;
    }
}

