/*
 * Decompiled with CFR 0.152.
 */
package nl.fountain.xelem;

import nl.fountain.xelem.Address;

public class CellPointer
extends Address {
    public static final int MOVE_RIGHT = 0;
    public static final int MOVE_LEFT = 1;
    public static final int MOVE_DOWN = 2;
    public static final int MOVE_UP = 3;
    private int hStep = 1;
    private int vStep = 1;
    private int hMove = 1;
    private int vMove;

    public CellPointer() {
        super(1, 1);
    }

    public Address getAddress() {
        return new Address(this.r, this.c);
    }

    public void setHorizontalStepDistance(int distance) {
        this.hStep = distance;
    }

    public int getHorizontalStepDistance() {
        return this.hStep;
    }

    public void setVerticalStepDistance(int distance) {
        this.vStep = distance;
    }

    public int getVerticalStepDistance() {
        return this.vStep;
    }

    public void setMovement(int moveConst) {
        switch (moveConst) {
            case 0: {
                this.hMove = 1;
                this.vMove = 0;
                break;
            }
            case 1: {
                this.hMove = -1;
                this.vMove = 0;
                break;
            }
            case 2: {
                this.hMove = 0;
                this.vMove = 1;
                break;
            }
            case 3: {
                this.hMove = 0;
                this.vMove = -1;
                break;
            }
            default: {
                throw new IllegalArgumentException(moveConst + ". Legal values are 0, 1, 2 and 3.");
            }
        }
    }

    public int getMovement() {
        if (this.hMove == 1) {
            return 0;
        }
        if (this.hMove == -1) {
            return 1;
        }
        if (this.vMove == 1) {
            return 2;
        }
        return 3;
    }

    public void move() {
        this.c += this.hStep * this.hMove;
        this.r += this.vStep * this.vMove;
    }

    public void move(int rows, int columns) {
        this.r += rows;
        this.c += columns;
    }

    public void moveTo(int row, int column) {
        this.r = row;
        this.c = column;
    }

    public void moveTo(String a1_ref) {
        this.r = CellPointer.calculateRow(a1_ref);
        this.c = CellPointer.calculateColumn(a1_ref);
    }

    public void moveTo(Address address) {
        this.r = address.r;
        this.c = address.c;
    }

    public void moveHome() {
        this.c = 1;
    }

    public void moveCRLF() {
        this.r += this.vStep;
        this.c = 1;
    }
}

