/*
 * Decompiled with CFR 0.152.
 */
package nl.fountain.xelem;

import java.util.ArrayList;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import nl.fountain.xelem.Address;
import nl.fountain.xelem.Area;
import nl.fountain.xelem.CellPointer;

public class AddressTest
extends TestCase {
    public static void main(String[] args) {
        TestRunner.run(AddressTest.class);
    }

    public void testCalculateRow() {
        AddressTest.assertEquals((int)0, (int)Address.calculateRow(""));
        AddressTest.assertEquals((int)1, (int)Address.calculateRow("1"));
        AddressTest.assertEquals((int)10, (int)Address.calculateRow("A10"));
        AddressTest.assertEquals((int)123, (int)Address.calculateRow("a1@2^3n:"));
        AddressTest.assertEquals((int)Integer.MAX_VALUE, (int)Address.calculateRow("2.147;483&647"));
        AddressTest.assertEquals((int)0, (int)Address.calculateRow("JAVA"));
    }

    public void testCalculateColumn1() {
        AddressTest.assertEquals((int)0, (int)Address.calculateColumn(""));
        AddressTest.assertEquals((int)1, (int)Address.calculateColumn("A"));
        AddressTest.assertEquals((int)26, (int)Address.calculateColumn("Z10"));
        AddressTest.assertEquals((int)26, (int)Address.calculateColumn("123z"));
        AddressTest.assertEquals((int)27, (int)Address.calculateColumn("AA520"));
        AddressTest.assertEquals((int)Integer.MAX_VALUE, (int)Address.calculateColumn("FXSHRXW"));
        AddressTest.assertEquals((int)177009, (int)Address.calculateColumn("JAVA"));
    }

    public void testCalculateColumn2() {
        for (int i = 0; i < 300; ++i) {
            String column = Address.calculateColumn(i);
            AddressTest.assertEquals((int)i, (int)Address.calculateColumn(column));
        }
        AddressTest.assertEquals((String)"", (String)Address.calculateColumn(-5));
        AddressTest.assertEquals((String)"", (String)Address.calculateColumn(0));
        AddressTest.assertEquals((String)"JAVA", (String)Address.calculateColumn(177009));
    }

    public void testStringConstructor() {
        AddressTest.assertTrue((boolean)new Address("BQ65").equals(new Address("65bq")));
        AddressTest.assertTrue((boolean)new Address("BQ65").equals(new Address("6Bq5")));
        Address adr = new Address("IV65536");
        AddressTest.assertEquals((int)65536, (int)adr.getRowIndex());
        AddressTest.assertEquals((int)256, (int)adr.getColumnIndex());
        AddressTest.assertEquals((String)"IV65536", (String)adr.getA1Reference());
        adr = new Address("xelem.2.0");
        AddressTest.assertEquals((int)20, (int)adr.getRowIndex());
        AddressTest.assertEquals((int)11063559, (int)adr.getColumnIndex());
        AddressTest.assertEquals((String)"XELEM20", (String)adr.getA1Reference());
    }

    public void testIsWithinSheet() {
        Address adr = new Address(1, 1);
        AddressTest.assertTrue((boolean)adr.isWithinSheet());
        adr = new Address(65536, 256);
        AddressTest.assertTrue((boolean)adr.isWithinSheet());
        adr = new Address(0, 1);
        AddressTest.assertTrue((!adr.isWithinSheet() ? 1 : 0) != 0);
        adr = new Address(1, 0);
        AddressTest.assertTrue((!adr.isWithinSheet() ? 1 : 0) != 0);
        adr = new Address(65537, 256);
        AddressTest.assertTrue((!adr.isWithinSheet() ? 1 : 0) != 0);
        adr = new Address(65536, 257);
        AddressTest.assertTrue((!adr.isWithinSheet() ? 1 : 0) != 0);
    }

    public void testGetAbsoluteAddress() {
        AddressTest.assertEquals((String)"R5C7", (String)new Address(5, 7).getAbsoluteAddress());
        AddressTest.assertEquals((String)"R99999C-7", (String)new Address(99999, -7).getAbsoluteAddress());
    }

    public void testGetAbsoluteRangeAddress() {
        Address adr = new Address(5, 3);
        AddressTest.assertEquals((String)"R5C3", (String)adr.getAbsoluteRange(new Address(5, 3)));
        AddressTest.assertEquals((String)"R5C3:R8C10", (String)adr.getAbsoluteRange(new Address(8, 10)));
        AddressTest.assertEquals((String)"R2C1:R5C3", (String)adr.getAbsoluteRange(new Address(2, 1)));
        AddressTest.assertEquals((String)"R5C3:R5C10", (String)adr.getAbsoluteRange(new Address(5, 10)));
        AddressTest.assertEquals((String)"R3C3:R5C10", (String)adr.getAbsoluteRange(new Address(3, 10)));
        CellPointer cp = new CellPointer();
        AddressTest.assertEquals((String)"R1C1:R5C3", (String)adr.getAbsoluteRange(cp));
    }

    public void testGetAbsoluteRangeintint() {
        Address adr = new Address(5, 3);
        AddressTest.assertEquals((String)"R5C3", (String)adr.getAbsoluteRange(5, 3));
        AddressTest.assertEquals((String)"R5C3:R8C10", (String)adr.getAbsoluteRange(8, 10));
        AddressTest.assertEquals((String)"R2C1:R5C3", (String)adr.getAbsoluteRange(2, 1));
        AddressTest.assertEquals((String)"R5C3:R5C10", (String)adr.getAbsoluteRange(5, 10));
        AddressTest.assertEquals((String)"R3C3:R5C10", (String)adr.getAbsoluteRange(3, 10));
    }

    public void testGetAbsoluteRangeCollection() {
        ArrayList<Address> list = new ArrayList<Address>();
        AddressTest.assertNull((Object)Address.getAbsoluteRange(list));
        Address adr1 = new Address(5, 7);
        list.add(adr1);
        AddressTest.assertEquals((String)"R5C7", (String)Address.getAbsoluteRange(list));
        list.add(adr1);
        AddressTest.assertEquals((String)"R5C7", (String)Address.getAbsoluteRange(list));
        Address adr2 = new Address(5, 6);
        list.add(adr2);
        AddressTest.assertEquals((String)"R5C6,R5C7", (String)Address.getAbsoluteRange(list));
        Address adr3 = new Address(1, 256);
        list.add(adr3);
        AddressTest.assertEquals((String)"R1C256,R5C6,R5C7", (String)Address.getAbsoluteRange(list));
        CellPointer cp = new CellPointer();
        cp.moveTo(2, 10);
        list.add(cp);
        try {
            Address.getAbsoluteRange(list);
            AddressTest.fail((String)"geen exceptie gegooid.");
        }
        catch (ClassCastException e) {
            // empty catch block
        }
        list.remove(cp);
        list.add(cp.getAddress());
        AddressTest.assertEquals((String)"R1C256,R2C10,R5C6,R5C7", (String)Address.getAbsoluteRange(list));
    }

    public void testGetRefToAddress() {
        Address adr = new Address(5, 7);
        Address adr2 = new Address(10, 10);
        AddressTest.assertEquals((String)"R[-5]C[-3]", (String)adr2.getRefTo(adr));
        AddressTest.assertEquals((String)"R[5]C[3]", (String)adr.getRefTo(adr2));
    }

    public void testGetRefTointint() {
        Address adr = new Address(5, 7);
        AddressTest.assertEquals((String)"RC", (String)adr.getRefTo(5, 7));
        AddressTest.assertEquals((String)"R[-2]C", (String)adr.getRefTo(3, 7));
        AddressTest.assertEquals((String)"RC[-3]", (String)adr.getRefTo(5, 4));
        AddressTest.assertEquals((String)"R[-1]C[3]", (String)adr.getRefTo(4, 10));
        AddressTest.assertEquals((String)"R[65531]C[249]", (String)adr.getRefTo(65536, 256));
    }

    public void testGetRefToAddressAddress() {
        Address adr = new Address(5, 7);
        Address adr1 = new Address(9, 4);
        Address adr2 = new Address(3, 8);
        AddressTest.assertEquals((String)"R[4]C[-3]:R[-2]C[1]", (String)adr.getRefTo(adr1, adr2));
    }

    public void testGetRefTointintintint() {
        Address adr = new Address(5, 7);
        AddressTest.assertEquals((String)"RC", (String)adr.getRefTo(5, 7, 5, 7));
        AddressTest.assertEquals((String)"R[4]C[1]", (String)adr.getRefTo(9, 8, 9, 8));
        AddressTest.assertEquals((String)"RC:R[4]C[1]", (String)adr.getRefTo(5, 7, 9, 8));
        AddressTest.assertEquals((String)"R[-2]C[-3]:R[4]C[1]", (String)adr.getRefTo(3, 4, 9, 8));
        AddressTest.assertEquals((String)"R[4]C[-3]:R[-2]C[1]", (String)adr.getRefTo(9, 4, 3, 8));
    }

    public void testGetRefToArea() {
        Address adr = new Address(5, 7);
        Area area = new Area(2, 3, 9, 8);
        AddressTest.assertEquals((String)"R[-3]C[-4]:R[4]C[1]", (String)adr.getRefTo(area));
        area = new Area(4, 6, 4, 6);
        AddressTest.assertEquals((String)"R[-1]C[-1]", (String)adr.getRefTo(area));
        area = new Area(5, 7, 5, 7);
        AddressTest.assertEquals((String)"RC", (String)adr.getRefTo(area));
    }

    public void testGetRefToCollection() {
        Address adr = new Address(5, 7);
        ArrayList<Address> list = new ArrayList<Address>();
        AddressTest.assertNull((Object)adr.getRefTo(list));
        list.add(adr);
        AddressTest.assertEquals((String)"RC", (String)adr.getRefTo(list));
        list.add(new Address(7, 10));
        AddressTest.assertEquals((String)"RC,R[2]C[3]", (String)adr.getRefTo(list));
        list.add(new Address(7, 10));
        AddressTest.assertEquals((String)"RC,R[2]C[3]", (String)adr.getRefTo(list));
        CellPointer cp = new CellPointer();
        list.add(cp);
        try {
            adr.getRefTo(list);
            AddressTest.fail((String)"geen exceptie gegooid.");
        }
        catch (ClassCastException e) {
            // empty catch block
        }
        list.remove(cp);
        list.add(cp.getAddress());
        AddressTest.assertEquals((String)"R[-4]C[-6],RC,R[2]C[3]", (String)adr.getRefTo(list));
    }

    public void testToString() {
        Address adr = new Address(5, 3);
        AddressTest.assertEquals((String)"nl.fountain.xelem.Address[row=5,column=3]", (String)adr.toString());
    }

    public void testEquals() {
        Address adr = new Address(5, 3);
        Address adr2 = new Address(5, 3);
        AddressTest.assertTrue((boolean)adr.equals(adr));
        AddressTest.assertTrue((boolean)adr.equals(adr2));
        AddressTest.assertTrue((boolean)adr2.equals(adr));
        AddressTest.assertTrue((!adr.equals(null) ? 1 : 0) != 0);
    }

    public void testCompareTo() {
        Address adr = new Address(5, 7);
        CellPointer cp = new CellPointer();
        try {
            adr.compareTo(cp);
            AddressTest.fail((String)"geen exceptie gegooid.");
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        AddressTest.assertEquals((int)0, (int)adr.compareTo(adr));
        AddressTest.assertEquals((int)0, (int)adr.compareTo(new Address(5, 7)));
        AddressTest.assertTrue((adr.compareTo(new Address(5, 8)) < 0 ? 1 : 0) != 0);
        AddressTest.assertTrue((adr.compareTo(new Address(5, 6)) > 0 ? 1 : 0) != 0);
        AddressTest.assertTrue((adr.compareTo(new Address(6, 6)) < 0 ? 1 : 0) != 0);
        AddressTest.assertTrue((adr.compareTo(new Address(4, 8)) > 0 ? 1 : 0) != 0);
    }
}

