/*
 * Decompiled with CFR 0.152.
 */
package nl.fountain.xelem;

import java.util.Collection;
import java.util.TreeSet;
import nl.fountain.xelem.Area;

public class Address
implements Comparable {
    protected int r;
    protected int c;
    private static int ABC_RADIX = 26;

    protected Address() {
    }

    public Address(int rowIndex, int columnIndex) {
        this.r = rowIndex;
        this.c = columnIndex;
    }

    public Address(String a1_ref) {
        this.r = Address.calculateRow(a1_ref);
        this.c = Address.calculateColumn(a1_ref);
    }

    public static int calculateColumn(String s) {
        String su = s.toUpperCase();
        int colnr = 0;
        int factor = 1;
        for (int i = su.length() - 1; i >= 0; --i) {
            char ch = su.charAt(i);
            if (!Character.isLetter(ch)) continue;
            colnr += (ch - 64) * factor;
            factor *= ABC_RADIX;
        }
        return colnr;
    }

    public static String calculateColumn(int columnNumber) {
        int q;
        int div = 1;
        int af = 0;
        StringBuffer sb = new StringBuffer();
        while ((q = (columnNumber - af) / div) > 0) {
            sb.insert(0, Address.getDigit(q));
            af += div;
            div *= ABC_RADIX;
        }
        return sb.toString();
    }

    private static char getDigit(int q) {
        int r = q % ABC_RADIX;
        if (r == 0) {
            r = ABC_RADIX;
        }
        return (char)(r + 64);
    }

    public static int calculateRow(String s) {
        int rownr = 0;
        int factor = 1;
        for (int i = s.length() - 1; i >= 0; --i) {
            char ch = s.charAt(i);
            if (!Character.isDigit(ch)) continue;
            rownr += (ch - 48) * factor;
            factor *= 10;
        }
        return rownr;
    }

    public int getRowIndex() {
        return this.r;
    }

    public int getColumnIndex() {
        return this.c;
    }

    public boolean isWithinSheet() {
        return this.c >= 1 && this.c <= 256 && this.r >= 1 && this.r <= 65536;
    }

    public String getA1Reference() {
        StringBuffer sb = new StringBuffer(Address.calculateColumn(this.c));
        sb.append(this.r);
        return sb.toString();
    }

    public String getAbsoluteAddress() {
        StringBuffer sb = new StringBuffer("R");
        sb.append(this.r);
        sb.append("C");
        sb.append(this.c);
        return sb.toString();
    }

    public String getAbsoluteRange(Address otherAddress) {
        return this.getAbsoluteRange(otherAddress.r, otherAddress.c);
    }

    public String getAbsoluteRange(int row, int column) {
        StringBuffer sb = new StringBuffer("R");
        int minR = this.r;
        int maxR = row;
        if (minR > maxR) {
            minR = row;
            maxR = this.r;
        }
        sb.append(minR);
        sb.append("C");
        int minC = this.c;
        int maxC = column;
        if (minC > maxC) {
            minC = column;
            maxC = this.c;
        }
        sb.append(minC);
        if (minR != maxR || minC != maxC) {
            sb.append(":R");
            sb.append(maxR);
            sb.append("C");
            sb.append(maxC);
        }
        return sb.toString();
    }

    public static String getAbsoluteRange(Collection<Address> addresses) {
        if (addresses.size() == 0) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        TreeSet<Address> adrs = new TreeSet<Address>(addresses);
        for (Address a : adrs) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(a.getAbsoluteAddress());
        }
        return sb.toString();
    }

    public String getRefTo(Address otherAddress) {
        return this.getRefTo(otherAddress.r, otherAddress.c);
    }

    public String getRefTo(int row, int column) {
        StringBuffer sb = new StringBuffer("R");
        int rO = row - this.r;
        if (rO != 0) {
            sb.append("[");
            sb.append(rO);
            sb.append("]");
        }
        sb.append("C");
        int cO = column - this.c;
        if (cO != 0) {
            sb.append("[");
            sb.append(cO);
            sb.append("]");
        }
        return sb.toString();
    }

    public String getRefTo(Address address1, Address address2) {
        return this.getRefTo(address1.r, address1.c, address2.r, address2.c);
    }

    public String getRefTo(int r1, int c1, int r2, int c2) {
        StringBuffer sb = new StringBuffer();
        String ref1 = this.getRefTo(r1, c1);
        sb.append(ref1);
        String ref2 = this.getRefTo(r2, c2);
        if (!ref1.equals(ref2)) {
            sb.append(":");
            sb.append(ref2);
        }
        return sb.toString();
    }

    public String getRefTo(Area area) {
        return this.getRefTo(area.r1, area.c1, area.r2, area.c2);
    }

    public String getRefTo(Collection<Address> addresses) {
        if (addresses.size() == 0) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        TreeSet<Address> adrs = new TreeSet<Address>(addresses);
        for (Address a : adrs) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(this.getRefTo(a));
        }
        return sb.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getClass().getName());
        sb.append("[row=");
        sb.append(this.r);
        sb.append(",column=");
        sb.append(this.c);
        sb.append("]");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        return this.toString().equals(obj.toString());
    }

    public int compareTo(Object o) {
        if (!o.getClass().equals(this.getClass())) {
            throw new ClassCastException();
        }
        Address a = (Address)o;
        if (this.r == a.r) {
            return this.c - a.c;
        }
        return this.r - a.r;
    }
}

