/*
 * Decompiled with CFR 0.152.
 */
package com.developer.spoti.vspoti;

import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Point;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.graphics.Xfermode;
import android.text.Spannable;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.widget.FrameLayout;
import com.developer.spoti.vspoti.VSpotMessageView;

public class VSpotView
extends FrameLayout {
    private static final float INDICATOR_HEIGHT = 30.0f;
    private float density;
    private View target;
    private RectF rect;
    private VSpotMessageView mMessageView;
    private boolean isTop;
    private Gravity mGravity;
    private DismissType dismissType;
    int marginGuide;
    private boolean mIsShowing;
    private VSpotListener mVSpotListener;
    int xMessageView = 0;
    int yMessageView = 0;
    final int ANIMATION_DURATION = 400;
    final Paint emptyPaint = new Paint();
    final Paint paintLine = new Paint();
    final Paint paintCircle = new Paint();
    final Paint paintCircleInner = new Paint();
    final Paint mPaint = new Paint();
    final Paint targetPaint = new Paint(1);
    final Xfermode XFERMODE_CLEAR = new PorterDuffXfermode(PorterDuff.Mode.CLEAR);

    private VSpotView(Context context, View view) {
        super(context);
        this.setWillNotDraw(false);
        this.target = view;
        this.density = context.getResources().getDisplayMetrics().density;
        int[] locationTarget = new int[2];
        this.target.getLocationOnScreen(locationTarget);
        this.rect = new RectF((float)locationTarget[0], (float)locationTarget[1], (float)(locationTarget[0] + this.target.getWidth()), (float)(locationTarget[1] + this.target.getHeight()));
        this.mMessageView = new VSpotMessageView(this.getContext());
        int padding = (int)(5.0f * this.density);
        this.mMessageView.setPadding(padding, padding, padding, padding);
        this.mMessageView.setColor(-1);
        this.addView((View)this.mMessageView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2));
        this.setMessageLocation(this.resolveMessageViewLocation());
        this.getViewTreeObserver().addOnGlobalLayoutListener(() -> {
            this.setMessageLocation(this.resolveMessageViewLocation());
            int[] locationTarget1 = new int[2];
            this.target.getLocationOnScreen(locationTarget1);
            this.rect = new RectF((float)locationTarget1[0], (float)locationTarget1[1], (float)(locationTarget1[0] + this.target.getWidth()), (float)(locationTarget1[1] + this.target.getHeight()));
        });
    }

    private int getNavigationBarSize() {
        Resources resources = this.getContext().getResources();
        int resourceId = resources.getIdentifier("navigation_bar_height", "dimen", "android");
        if (resourceId > 0) {
            return resources.getDimensionPixelSize(resourceId);
        }
        return 0;
    }

    private boolean isLandscape() {
        int display_mode = this.getResources().getConfiguration().orientation;
        return display_mode != 1;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.target != null) {
            Bitmap bitmap = Bitmap.createBitmap((int)this.getWidth(), (int)this.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas tempCanvas = new Canvas(bitmap);
            float lineWidth = 3.0f * this.density;
            float strokeCircleWidth = 3.0f * this.density;
            float circleSize = 6.0f * this.density;
            float circleInnerSize = 5.0f * this.density;
            this.mPaint.setColor(-587202560);
            this.mPaint.setStyle(Paint.Style.FILL);
            this.mPaint.setAntiAlias(true);
            tempCanvas.drawRect(canvas.getClipBounds(), this.mPaint);
            this.paintLine.setStyle(Paint.Style.FILL);
            this.paintLine.setColor(-1);
            this.paintLine.setStrokeWidth(lineWidth);
            this.paintLine.setAntiAlias(true);
            this.paintCircle.setStyle(Paint.Style.STROKE);
            this.paintCircle.setColor(-1);
            this.paintCircle.setStrokeCap(Paint.Cap.ROUND);
            this.paintCircle.setStrokeWidth(strokeCircleWidth);
            this.paintCircle.setAntiAlias(true);
            this.paintCircleInner.setStyle(Paint.Style.FILL);
            this.paintCircleInner.setColor(-3355444);
            this.paintCircleInner.setAntiAlias(true);
            this.marginGuide = (int)(this.isTop ? 15.0f * this.density : -15.0f * this.density);
            float startYLineAndCircle = (this.isTop ? this.rect.bottom : this.rect.top) + (float)this.marginGuide;
            float x = this.rect.left / 2.0f + this.rect.right / 2.0f;
            float stopY = (float)this.yMessageView + 30.0f * this.density;
            tempCanvas.drawLine(x, startYLineAndCircle, x, stopY, this.paintLine);
            tempCanvas.drawCircle(x, startYLineAndCircle, circleSize, this.paintCircle);
            tempCanvas.drawCircle(x, startYLineAndCircle, circleInnerSize, this.paintCircleInner);
            this.targetPaint.setXfermode(this.XFERMODE_CLEAR);
            this.targetPaint.setAntiAlias(true);
            tempCanvas.drawRoundRect(this.rect, 15.0f, 15.0f, this.targetPaint);
            canvas.drawBitmap(bitmap, 0.0f, 0.0f, this.emptyPaint);
        }
    }

    public boolean isShowing() {
        return this.mIsShowing;
    }

    public void dismiss() {
        AlphaAnimation startAnimation = new AlphaAnimation(1.0f, 0.0f);
        startAnimation.setDuration(400L);
        startAnimation.setFillAfter(true);
        this.startAnimation((Animation)startAnimation);
        ((ViewGroup)((Activity)this.getContext()).getWindow().getDecorView()).removeView((View)this);
        this.mIsShowing = false;
        if (this.mVSpotListener != null) {
            this.mVSpotListener.onDismiss(this.target);
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        float x = event.getX();
        float y = event.getY();
        if (event.getAction() == 0) {
            switch (this.dismissType) {
                case outside: {
                    if (this.isViewContains((View)this.mMessageView, x, y)) break;
                    this.dismiss();
                    break;
                }
                case anywhere: {
                    this.dismiss();
                    break;
                }
                case targetView: {
                    if (!this.rect.contains(x, y)) break;
                    this.target.performClick();
                    this.dismiss();
                }
            }
            return true;
        }
        return false;
    }

    private boolean isViewContains(View view, float rx, float ry) {
        int[] location = new int[2];
        view.getLocationOnScreen(location);
        int x = location[0];
        int y = location[1];
        int w = view.getWidth();
        int h = view.getHeight();
        return !(rx < (float)x || rx > (float)(x + w) || ry < (float)y || ry > (float)(y + h));
    }

    void setMessageLocation(Point p) {
        this.mMessageView.setX(p.x);
        this.mMessageView.setY(p.y);
        this.requestLayout();
    }

    private Point resolveMessageViewLocation() {
        this.xMessageView = this.mGravity == Gravity.center ? (int)(this.rect.left - (float)(this.mMessageView.getWidth() / 2) + (float)(this.target.getWidth() / 2)) : (int)this.rect.right - this.mMessageView.getWidth();
        if (this.isLandscape()) {
            this.xMessageView -= this.getNavigationBarSize();
        }
        if (this.xMessageView + this.mMessageView.getWidth() > this.getWidth()) {
            this.xMessageView = this.getWidth() - this.mMessageView.getWidth();
        }
        if (this.xMessageView < 0) {
            this.xMessageView = 0;
        }
        if (this.rect.top + 30.0f * this.density > (float)(this.getHeight() / 2)) {
            this.isTop = false;
            this.yMessageView = (int)(this.rect.top - (float)this.mMessageView.getHeight() - 30.0f * this.density);
        } else {
            this.isTop = true;
            this.yMessageView = (int)(this.rect.top + (float)this.target.getHeight() + 30.0f * this.density);
        }
        if (this.yMessageView < 0) {
            this.yMessageView = 0;
        }
        return new Point(this.xMessageView, this.yMessageView);
    }

    public void show() {
        this.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
        this.setClickable(false);
        ((ViewGroup)((Activity)this.getContext()).getWindow().getDecorView()).addView((View)this);
        AlphaAnimation startAnimation = new AlphaAnimation(0.0f, 1.0f);
        startAnimation.setDuration(400L);
        startAnimation.setFillAfter(true);
        this.startAnimation((Animation)startAnimation);
        this.mIsShowing = true;
    }

    public void setTitle(String str) {
        this.mMessageView.setTitle(str);
    }

    public void setContentText(String str) {
        this.mMessageView.setContentText(str);
    }

    public void setContentSpan(Spannable span) {
        this.mMessageView.setContentSpan(span);
    }

    public void setTitleTypeFace(Typeface typeFace) {
        this.mMessageView.setTitleTypeFace(typeFace);
    }

    public void setContentTypeFace(Typeface typeFace) {
        this.mMessageView.setContentTypeFace(typeFace);
    }

    public void setTitleTextSize(int size) {
        this.mMessageView.setTitleTextSize(size);
    }

    public void setContentTextSize(int size) {
        this.mMessageView.setContentTextSize(size);
    }

    public static class Builder {
        private View targetView;
        private String title;
        private String contentText;
        private Gravity gravity;
        private DismissType dismissType;
        private Context context;
        private int titleTextSize;
        private int contentTextSize;
        private Spannable contentSpan;
        private Typeface titleTypeFace;
        private Typeface contentTypeFace;
        private VSpotListener VSpotListener;

        public Builder(Context context) {
            this.context = context;
        }

        public Builder setTargetView(View view) {
            this.targetView = view;
            return this;
        }

        public Builder setGravity(Gravity gravity) {
            this.gravity = gravity;
            return this;
        }

        public Builder setTitle(String title) {
            this.title = title;
            return this;
        }

        public Builder setContentText(String contentText) {
            this.contentText = contentText;
            return this;
        }

        public Builder setContentSpan(Spannable span) {
            this.contentSpan = span;
            return this;
        }

        public Builder setContentTypeFace(Typeface typeFace) {
            this.contentTypeFace = typeFace;
            return this;
        }

        public Builder setVSpotListener(VSpotListener VSpotListener2) {
            this.VSpotListener = VSpotListener2;
            return this;
        }

        public Builder setTitleTypeFace(Typeface typeFace) {
            this.titleTypeFace = typeFace;
            return this;
        }

        public Builder setContentTextSize(int size) {
            this.contentTextSize = size;
            return this;
        }

        public Builder setTitleTextSize(int size) {
            this.titleTextSize = size;
            return this;
        }

        public Builder setDismissType(DismissType dismissType) {
            this.dismissType = dismissType;
            return this;
        }

        public VSpotView build() {
            VSpotView VSpotView2 = new VSpotView(this.context, this.targetView);
            VSpotView2.mGravity = this.gravity != null ? this.gravity : Gravity.auto;
            VSpotView2.dismissType = this.dismissType != null ? this.dismissType : DismissType.targetView;
            VSpotView2.setTitle(this.title);
            if (this.contentText != null) {
                VSpotView2.setContentText(this.contentText);
            }
            if (this.titleTextSize != 0) {
                VSpotView2.setTitleTextSize(this.titleTextSize);
            }
            if (this.contentTextSize != 0) {
                VSpotView2.setContentTextSize(this.contentTextSize);
            }
            if (this.contentSpan != null) {
                VSpotView2.setContentSpan(this.contentSpan);
            }
            if (this.titleTypeFace != null) {
                VSpotView2.setTitleTypeFace(this.titleTypeFace);
            }
            if (this.contentTypeFace != null) {
                VSpotView2.setContentTypeFace(this.contentTypeFace);
            }
            if (this.VSpotListener != null) {
                VSpotView2.mVSpotListener = this.VSpotListener;
            }
            return VSpotView2;
        }
    }

    public static enum DismissType {
        outside,
        anywhere,
        targetView;

    }

    public static enum Gravity {
        auto,
        center;

    }

    public static interface VSpotListener {
        public void onDismiss(View var1);
    }
}

