/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;

public class Trie {
    private static final int MAX_RETURNS = 100;
    private final TrieNode root = new TrieNode('\u0000');

    public void addKey(String key) {
        TrieNode trieNode = this.root;
        for (int i = 0; i < key.length(); ++i) {
            char index = key.charAt(i);
            TrieNode lastNode = trieNode;
            trieNode = null;
            for (TrieNode node : lastNode.children) {
                if (node.character != index) continue;
                trieNode = node;
                break;
            }
            if (trieNode != null) continue;
            trieNode = new TrieNode(index);
            lastNode.children.add(trieNode);
            if (i != key.length() - 1) continue;
            trieNode.endOfWord = true;
        }
    }

    public void removeKey(String key) {
        if (key == null || key.isEmpty()) {
            return;
        }
        Queue<TrieNode> found = Collections.asLifoQueue(new LinkedList());
        TrieNode lastNode = this.root;
        for (int i = 0; i < key.length(); ++i) {
            char currChar = key.charAt(i);
            TrieNode charNode = null;
            for (TrieNode loopNode : lastNode.children) {
                if (loopNode.character != currChar) continue;
                charNode = loopNode;
                break;
            }
            if (charNode == null) break;
            found.add(charNode);
            lastNode = charNode;
        }
        if (found.isEmpty() || ((TrieNode)found.peek()).character != key.charAt(key.length() - 1)) {
            return;
        }
        TrieNode lastCharNode = (TrieNode)found.poll();
        lastCharNode.endOfWord = false;
        if (lastCharNode.children.isEmpty()) {
            char lastChar = lastCharNode.character;
            while (!found.isEmpty()) {
                lastCharNode = (TrieNode)found.poll();
                Iterator<TrieNode> nodeIterator = lastCharNode.children.iterator();
                while (nodeIterator.hasNext()) {
                    if (nodeIterator.next().character != lastChar) continue;
                    nodeIterator.remove();
                    break;
                }
                if (lastCharNode.endOfWord || !lastCharNode.children.isEmpty()) break;
                lastChar = lastCharNode.character;
            }
        }
    }

    public List<String> getStringsFromKey(String key) {
        if (key.length() == 0) {
            return Trie.getChildrenStrings(this.root, new ArrayList<String>());
        }
        ArrayList<String> strings = new ArrayList<String>();
        HashMap<TrieNode, String> nodes = new HashMap<TrieNode, String>();
        nodes.put(this.root, "");
        for (int i = 0; i < key.length(); ++i) {
            HashMap<TrieNode, String> newNodes = new HashMap<TrieNode, String>();
            char index = Character.toLowerCase(key.charAt(i));
            for (Map.Entry entry : nodes.entrySet()) {
                for (TrieNode node : ((TrieNode)entry.getKey()).children) {
                    if (Character.toLowerCase(node.character) != index) continue;
                    String realKey = (String)entry.getValue() + node.character;
                    newNodes.put(node, realKey);
                    if (i != key.length() - 1) continue;
                    for (String string : Trie.getChildrenStrings(node, new ArrayList<String>())) {
                        strings.add(realKey + string);
                    }
                }
            }
            nodes = newNodes;
        }
        return strings;
    }

    private static List<String> getChildrenStrings(TrieNode find, List<String> found) {
        ArrayList<String> childrenStrings = new ArrayList<String>();
        for (TrieNode trieNode : find.children) {
            if (found.size() + 1 > 100) {
                return found;
            }
            if (trieNode.endOfWord) {
                found.add(String.valueOf(trieNode.character));
            }
            if (trieNode.children.isEmpty()) continue;
            childrenStrings.clear();
            for (String string : Trie.getChildrenStrings(trieNode, childrenStrings)) {
                if (found.size() + 1 > 100) {
                    return found;
                }
                found.add(trieNode.character + string);
            }
        }
        return found;
    }

    public static class TrieNode {
        List<TrieNode> children = new ArrayList<TrieNode>();
        char character;
        boolean endOfWord = false;

        TrieNode(char character) {
            this.character = character;
        }
    }
}

