/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.util;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.regen.PlotBlockData;
import com.palmergames.compress.archivers.tar.TarArchiveEntry;
import com.palmergames.compress.archivers.tar.TarArchiveOutputStream;
import com.palmergames.compress.compressors.gzip.GzipCompressorOutputStream;
import com.palmergames.compress.utils.IOUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Properties;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public final class FileMgmt {
    private static final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private static final Lock readLock = readWriteLock.readLock();
    private static final Lock writeLock = readWriteLock.writeLock();

    public static boolean checkOrCreateFolder(String folderPath) {
        File file = new File(folderPath);
        if (file.exists() || file.isDirectory()) {
            return true;
        }
        return FileMgmt.newDir(file);
    }

    public static boolean checkOrCreateFolders(String ... folders) {
        for (String folder : folders) {
            if (FileMgmt.checkOrCreateFolder(folder)) continue;
            return false;
        }
        return true;
    }

    public static boolean checkOrCreateFile(String filePath) {
        File file = new File(filePath);
        if (!FileMgmt.checkOrCreateFolder(file.getParentFile().getPath())) {
            return false;
        }
        if (file.exists()) {
            return true;
        }
        return FileMgmt.newFile(file);
    }

    private static boolean newDir(File dir) {
        try {
            writeLock.lock();
            boolean bl = dir.mkdirs();
            return bl;
        }
        finally {
            writeLock.unlock();
        }
    }

    private static boolean newFile(File file) {
        try {
            writeLock.lock();
            boolean bl = file.createNewFile();
            return bl;
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            writeLock.unlock();
        }
    }

    public static boolean checkOrCreateFiles(String ... files) {
        for (String file : files) {
            if (FileMgmt.checkOrCreateFile(file)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyDirectory(File sourceLocation, File targetLocation) throws IOException {
        block9: {
            try {
                writeLock.lock();
                if (sourceLocation.isDirectory()) {
                    String[] children;
                    if (!targetLocation.exists()) {
                        targetLocation.mkdir();
                    }
                    for (String aChildren : children = sourceLocation.list()) {
                        FileMgmt.copyDirectory(new File(sourceLocation, aChildren), new File(targetLocation, aChildren));
                    }
                    break block9;
                }
                FileOutputStream out = new FileOutputStream(targetLocation);
                try {
                    int len;
                    FileInputStream in = new FileInputStream(sourceLocation);
                    byte[] buf = new byte[1024];
                    while ((len = ((InputStream)in).read(buf)) > 0) {
                        ((OutputStream)out).write(buf, 0, len);
                    }
                    ((InputStream)in).close();
                    ((OutputStream)out).close();
                }
                catch (IOException ex) {
                    Towny.getPlugin().getLogger().warning("Error: Could not access: " + sourceLocation);
                }
                ((OutputStream)out).close();
            }
            finally {
                writeLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File unpackResourceFile(String filePath, String resource, String defaultRes) {
        try {
            writeLock.lock();
            File file = new File(filePath);
            if (file.exists()) {
                File file2 = file;
                return file2;
            }
            FileMgmt.checkOrCreateFile(filePath);
            try {
                String resString = FileMgmt.convertStreamToString("/" + resource);
                FileMgmt.stringToFile(resString, filePath);
            }
            catch (IOException e) {
                try {
                    String resString = FileMgmt.convertStreamToString("/" + defaultRes);
                    FileMgmt.stringToFile(resString, filePath);
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
            File file3 = file;
            return file3;
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String convertStreamToString(String name) throws IOException {
        try {
            readLock.lock();
            if (name != null) {
                StringWriter writer = new StringWriter();
                InputStream is = FileMgmt.class.getResourceAsStream(name);
                char[] buffer = new char[1024];
                try {
                    int n;
                    BufferedReader reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
                    while ((n = reader.read(buffer)) != -1) {
                        ((Writer)writer).write(buffer, 0, n);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                finally {
                    try {
                        is.close();
                    }
                    catch (NullPointerException e) {
                        throw new IOException();
                    }
                }
                String string = ((Object)writer).toString();
                return string;
            }
            String string = "";
            return string;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String convertFileToString(File file) {
        try {
            readLock.lock();
            if (file != null && file.exists() && file.canRead() && !file.isDirectory()) {
                StringWriter writer = new StringWriter();
                char[] buffer = new char[1024];
                try (FileInputStream is = new FileInputStream(file);){
                    int n;
                    BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)is, StandardCharsets.UTF_8));
                    while ((n = reader.read(buffer)) != -1) {
                        ((Writer)writer).write(buffer, 0, n);
                    }
                    ((Reader)reader).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                String string = ((Object)writer).toString();
                return string;
            }
            String string = "";
            return string;
        }
        finally {
            readLock.unlock();
        }
    }

    public static void stringToFile(String source, String FileName) {
        if (source != null) {
            FileMgmt.stringToFile(source, new File(FileName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stringToFile(String source, File file) {
        try {
            writeLock.lock();
            try (OutputStreamWriter osw = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);
                 BufferedWriter bufferedWriter = new BufferedWriter(osw);){
                bufferedWriter.write(source);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * Exception decompiling
     */
    public static boolean listToFile(Collection<String> source, String targetLocation) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void moveFile(File sourceFile, String targetLocation) {
        try {
            writeLock.lock();
            if (sourceFile.isFile()) {
                File f = new File(sourceFile.getParent() + File.separator + targetLocation + File.separator + sourceFile.getName());
                if (f.exists() && f.isFile()) {
                    f.delete();
                }
                sourceFile.renameTo(new File(sourceFile.getParent() + File.separator + targetLocation, sourceFile.getName()));
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void moveTownBlockFile(File sourceFile, String targetLocation, String townDir) {
        try {
            writeLock.lock();
            if (sourceFile.isFile()) {
                if (!townDir.isEmpty()) {
                    FileMgmt.checkOrCreateFolder(sourceFile.getParent() + File.separator + "deleted" + File.separator + townDir);
                } else {
                    FileMgmt.checkOrCreateFolder(sourceFile.getParent() + File.separator + "deleted");
                }
                File f = new File(sourceFile.getParent() + File.separator + targetLocation + File.separator + townDir + File.separator + sourceFile.getName());
                if (f.exists() && f.isFile()) {
                    f.delete();
                }
                sourceFile.renameTo(new File(sourceFile.getParent() + File.separator + targetLocation + File.separator + townDir, sourceFile.getName()));
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    public static String getFileTimeStamp() {
        long t = System.currentTimeMillis();
        return new SimpleDateFormat("yyyy-MM-dd HH-mm").format(t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void tar(File destination, File ... sources) throws IOException {
        try {
            readLock.lock();
            try (TarArchiveOutputStream archive = new TarArchiveOutputStream(new GzipCompressorOutputStream(new FileOutputStream(destination)));){
                for (File source : sources) {
                    Files.walk(source.toPath(), new FileVisitOption[0]).forEach(path -> {
                        File file = path.toFile();
                        if (!file.isDirectory()) {
                            TarArchiveEntry entry_1 = new TarArchiveEntry(file, file.toString());
                            try (FileInputStream fis = new FileInputStream(file);){
                                archive.putArchiveEntry(entry_1);
                                IOUtils.copy(fis, (OutputStream)archive);
                                archive.closeArchiveEntry();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                    });
                }
            }
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zipFile(File file, String path) {
        try (ZipOutputStream zos = new ZipOutputStream((OutputStream)new FileOutputStream(path), StandardCharsets.UTF_8);){
            writeLock.lock();
            byte[] buffer = new byte[2056];
            zos.putNextEntry(new ZipEntry(file.getName()));
            try (FileInputStream in = new FileInputStream(file);){
                int len;
                while ((len = in.read(buffer)) > 0) {
                    zos.write(buffer, 0, len);
                }
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zipDirectories(File destination, File ... sourceFolders) throws IOException {
        try {
            readLock.lock();
            ZipOutputStream output = new ZipOutputStream((OutputStream)new FileOutputStream(destination), StandardCharsets.UTF_8);
            for (File sourceFolder : sourceFolders) {
                FileMgmt.recursiveZipDirectory(sourceFolder, output);
            }
            output.close();
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void recursiveZipDirectory(File sourceFolder, ZipOutputStream zipStream) throws IOException {
        try {
            readLock.lock();
            String[] dirList = sourceFolder.list();
            byte[] readBuffer = new byte[2156];
            for (String aDirList : dirList) {
                int bytesIn;
                File f = new File(sourceFolder, aDirList);
                if (f.isDirectory()) {
                    FileMgmt.recursiveZipDirectory(f, zipStream);
                    continue;
                }
                if (!f.isFile() || !f.canRead()) continue;
                FileInputStream input = new FileInputStream(f);
                ZipEntry anEntry = new ZipEntry(f.getPath());
                zipStream.putNextEntry(anEntry);
                while ((bytesIn = input.read(readBuffer)) != -1) {
                    zipStream.write(readBuffer, 0, bytesIn);
                }
                input.close();
            }
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteFile(File file) {
        try {
            writeLock.lock();
            if (file.isDirectory()) {
                File[] children = file.listFiles();
                if (children != null) {
                    for (File child : children) {
                        FileMgmt.deleteFile(child);
                    }
                }
                if (!((children = file.listFiles()) != null && children.length != 0 || file.delete())) {
                    Towny.getPlugin().getLogger().warning("Error: Could not delete folder: " + file.getPath());
                }
            } else if (file.isFile() && !file.delete()) {
                Towny.getPlugin().getLogger().warning("Error: Could not delete file: " + file.getPath());
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteOldBackups(File backupsDir, long deleteAfter) {
        try {
            File[] children;
            writeLock.lock();
            TreeSet<Long> deleted = new TreeSet<Long>();
            if (backupsDir.isDirectory() && (children = backupsDir.listFiles()) != null) {
                for (File child : children) {
                    try {
                        long age;
                        String[] tokens;
                        String lastToken;
                        long timeMade;
                        String filename = child.getName();
                        if (child.isFile() && filename.contains(".")) {
                            filename = filename.split("\\.")[0];
                        }
                        if ((timeMade = Long.parseLong(lastToken = (tokens = filename.split(" "))[tokens.length - 1])) < 0L || (age = System.currentTimeMillis() - timeMade) < deleteAfter) continue;
                        FileMgmt.deleteFile(child);
                        deleted.add(age);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            if (deleted.size() > 0) {
                Towny.getPlugin().getLogger().info(String.format("Deleting %d Old Backups (%s).", deleted.size(), deleted.size() > 1 ? String.format("%d-%d days old", TimeUnit.MILLISECONDS.toDays((Long)deleted.first()), TimeUnit.MILLISECONDS.toDays((Long)deleted.last())) : String.format("%d days old", TimeUnit.MILLISECONDS.toDays((Long)deleted.first()))));
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashMap<String, String> loadFileIntoHashMap(File file) {
        try {
            readLock.lock();
            HashMap<String, String> keys = new HashMap<String, String>();
            try (FileInputStream fis = new FileInputStream(file);
                 InputStreamReader isr = new InputStreamReader((InputStream)fis, StandardCharsets.UTF_8);){
                Properties properties = new Properties();
                properties.load(isr);
                for (String key : properties.stringPropertyNames()) {
                    String value = properties.getProperty(key);
                    keys.put(key, String.valueOf(value));
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            HashMap<String, String> hashMap = keys;
            return hashMap;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void savePlotData(PlotBlockData data, File file, String path) {
        FileMgmt.checkOrCreateFolder(file.getPath());
        try (ZipOutputStream output = new ZipOutputStream((OutputStream)new FileOutputStream(path), StandardCharsets.UTF_8);){
            writeLock.lock();
            output.putNextEntry(new ZipEntry(data.getX() + "_" + data.getZ() + "_" + data.getSize() + ".data"));
            try (DataOutputStream fout = new DataOutputStream(output);){
                fout.write("VER".getBytes(StandardCharsets.UTF_8));
                fout.write(data.getVersion());
                fout.writeInt(data.getHeight());
                for (String block : new ArrayList<String>(data.getBlockList())) {
                    fout.writeUTF(block);
                }
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        finally {
            writeLock.unlock();
        }
    }

    @Deprecated
    public static String fileSeparator() {
        return System.getProperty("file.separator");
    }
}

