/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.war.eventwar;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.object.Coord;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.bukkit.towny.tasks.TownyTimerTask;
import com.palmergames.bukkit.towny.war.eventwar.War;
import com.palmergames.bukkit.towny.war.eventwar.WarZoneData;
import com.palmergames.bukkit.util.BukkitTools;
import java.util.Hashtable;
import org.bukkit.entity.Player;

public class WarTimerTask
extends TownyTimerTask {
    private War warEvent;

    public WarTimerTask(Towny plugin, War warEvent) {
        super(plugin);
        this.warEvent = warEvent;
    }

    @Override
    public void run() {
        if (!this.warEvent.isWarTime()) {
            this.warEvent.end();
            TownyAPI.getInstance().clearWarEvent();
            this.plugin.resetCache();
            TownyMessaging.sendDebugMsg("War ended.");
            return;
        }
        int numPlayers = 0;
        Hashtable<TownBlock, WarZoneData> plotList = new Hashtable<TownBlock, WarZoneData>();
        for (Player player : BukkitTools.getOnlinePlayers()) {
            if (player == null || player.isFlying()) continue;
            ++numPlayers;
            TownyMessaging.sendDebugMsg("[War] " + player.getName() + ": ");
            try {
                boolean edgesOnly;
                Resident resident = TownyUniverse.getInstance().getResident(player.getUniqueId());
                if (resident == null || !resident.hasTown()) continue;
                if (!War.isWarringTown(resident.getTown()) || !resident.hasNation()) continue;
                Nation nation = resident.getTown().getNation();
                TownyMessaging.sendDebugMsg("[War]   hasNation");
                if (nation.isNeutral()) {
                    if (!this.warEvent.isWarringNation(nation)) continue;
                    this.warEvent.nationLeave(nation);
                    continue;
                }
                TownyMessaging.sendDebugMsg("[War]   notPeaceful");
                if (!this.warEvent.isWarringNation(nation)) continue;
                TownyMessaging.sendDebugMsg("[War]   warringNation");
                WorldCoord worldCoord = this.plugin.getCache(player).getLastTownBlock();
                if (!War.isWarZone(worldCoord)) continue;
                TownyMessaging.sendDebugMsg("[War]   warZone");
                if (player.getLocation().getBlockY() < TownySettings.getMinWarHeight()) continue;
                TownyMessaging.sendDebugMsg("[War]   aboveMinHeight");
                TownBlock townBlock = worldCoord.getTownBlock();
                boolean healablePlots = TownySettings.getPlotsHealableInWar();
                if (healablePlots && (nation == townBlock.getTown().getNation() || townBlock.getTown().getNation().hasAlly(nation))) {
                    if (plotList.containsKey(townBlock)) {
                        ((WarZoneData)plotList.get(townBlock)).addDefender(player);
                    } else {
                        WarZoneData wzd = new WarZoneData();
                        wzd.addDefender(player);
                        plotList.put(townBlock, wzd);
                    }
                    TownyMessaging.sendDebugMsg("[War]   healed");
                    continue;
                }
                if (!resident.getTown().getNation().hasEnemy(townBlock.getTown().getNation())) continue;
                TownyMessaging.sendDebugMsg("[War]   notAlly");
                if (resident.isJailed() || (edgesOnly = TownySettings.getOnlyAttackEdgesInWar()) && !WarTimerTask.isOnEdgeOfTown(townBlock, worldCoord, this.warEvent)) continue;
                if (edgesOnly) {
                    TownyMessaging.sendDebugMsg("[War]   onEdge");
                }
                if (plotList.containsKey(townBlock)) {
                    ((WarZoneData)plotList.get(townBlock)).addAttacker(player);
                } else {
                    WarZoneData wzd = new WarZoneData();
                    wzd.addAttacker(player);
                    plotList.put(townBlock, wzd);
                }
                TownyMessaging.sendDebugMsg("[War]   damaged");
            }
            catch (NotRegisteredException resident) {}
        }
        for (TownBlock townBlock : plotList.keySet()) {
            try {
                this.warEvent.updateWarZone(townBlock, (WarZoneData)plotList.get(townBlock));
            }
            catch (NotRegisteredException e) {
                TownyMessaging.sendDebugMsg("[War]   WarZone Update Failed");
            }
        }
        TownyMessaging.sendDebugMsg("[War] # Players: " + numPlayers);
    }

    public static boolean isOnEdgeOfTown(TownBlock townBlock, WorldCoord worldCoord, War warEvent) {
        int[][] offset = new int[][]{{-1, 0}, {1, 0}, {0, -1}, {0, 1}};
        for (int i = 0; i < 4; ++i) {
            try {
                boolean sameTown;
                TownBlock edgeTownBlock = worldCoord.getTownyWorld().getTownBlock(new Coord(worldCoord.getX() + offset[i][0], worldCoord.getZ() + offset[i][1]));
                boolean bl = sameTown = edgeTownBlock.getTown() == townBlock.getTown();
                if (sameTown) {
                    if (!sameTown) continue;
                    if (War.isWarZone(edgeTownBlock.getWorldCoord())) continue;
                }
                return true;
            }
            catch (NotRegisteredException e) {
                return true;
            }
        }
        return false;
    }
}

