/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.utils;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyEconomyHandler;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.confirmations.Confirmation;
import com.palmergames.bukkit.towny.event.town.TownReclaimedEvent;
import com.palmergames.bukkit.towny.event.town.TownRuinedEvent;
import com.palmergames.bukkit.towny.exceptions.AlreadyRegisteredException;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.PlotGroup;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.Translatable;
import com.palmergames.bukkit.towny.utils.ResidentUtil;
import com.palmergames.util.TimeTools;
import java.util.ArrayList;
import java.util.ListIterator;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class TownRuinUtil {
    private TownRuinUtil() {
    }

    public static boolean isPlayersTownRuined(Player player) {
        try {
            Resident resident = TownyUniverse.getInstance().getResident(player.getUniqueId());
            if (resident != null && resident.hasTown() && resident.getTown().isRuined()) {
                return true;
            }
        }
        catch (NotRegisteredException notRegisteredException) {
            // empty catch block
        }
        return false;
    }

    public static void putTownIntoRuinedState(Town town, Towny plugin) {
        if (town.isRuined()) {
            return;
        }
        if (town.hasNation()) {
            town.removeNation();
        }
        Resident resident = ResidentUtil.createAndGetNPCResident();
        try {
            resident.setTown(town);
        }
        catch (AlreadyRegisteredException alreadyRegisteredException) {
            // empty catch block
        }
        resident.save();
        TownRuinUtil.setMayor(town, resident);
        town.setHasUpkeep(false);
        TownRuinedEvent event = new TownRuinedEvent(town);
        Bukkit.getPluginManager().callEvent((Event)event);
        town.setRuined(true);
        town.setRuinedTime(System.currentTimeMillis());
        town.setPublic(TownySettings.areRuinsMadePublic());
        town.setOpen(false);
        town.getPermissions().setAll(true);
        for (TownBlock townBlock : town.getTownBlocks()) {
            if (townBlock.hasResident()) {
                townBlock.setResident(null);
            }
            townBlock.setType(0);
            townBlock.setPlotPrice(-1.0);
            townBlock.removePlotObjectGroup();
            townBlock.getPermissionOverrides().clear();
            townBlock.getTrustedResidents().clear();
            townBlock.save();
        }
        if (town.getPlotGroups() != null) {
            for (PlotGroup group : town.getPlotGroups()) {
                TownyUniverse.getInstance().getDataSource().removePlotGroup(group);
            }
        }
        if (TownySettings.getMaxResidentsPerTown() > 0) {
            ResidentUtil.reduceResidentCountToFitTownMaxPop(town);
        }
        town.save();
        plugin.resetCache();
        TownyMessaging.sendGlobalMessage(Translatable.of("msg_ruin_town", town.getName()));
    }

    public static void processRuinedTownReclaimRequest(Player player, Towny plugin) {
        try {
            Resident resident = TownyUniverse.getInstance().getResident(player.getUniqueId());
            if (resident == null || !resident.hasTown()) {
                throw new TownyException(Translatable.of("msg_err_dont_belong_town"));
            }
            Town town = resident.getTown();
            if (!town.isRuined()) {
                throw new TownyException(Translatable.of("msg_err_cannot_reclaim_town_unless_ruined"));
            }
            double townReclaimCost = TownySettings.getEcoPriceReclaimTown();
            if (TownyEconomyHandler.isActive() && !resident.getAccount().canPayFromHoldings(townReclaimCost)) {
                throw new TownyException(Translatable.of("msg_insuf_funds"));
            }
            if (TownySettings.getTownRuinsMinDurationHours() - TownRuinUtil.getTimeSinceRuining(town) > 0) {
                throw new TownyException(Translatable.of("msg_err_cannot_reclaim_town_yet", TownySettings.getTownRuinsMinDurationHours() - TownRuinUtil.getTimeSinceRuining(town)));
            }
            if (TownyEconomyHandler.isActive() && townReclaimCost > 0.0) {
                Confirmation.runOnAccept(() -> {
                    if (!resident.getAccount().canPayFromHoldings(townReclaimCost)) {
                        TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_insuf_funds"));
                        return;
                    }
                    resident.getAccount().withdraw(townReclaimCost, "Cost of town reclaim.");
                    TownRuinUtil.reclaimTown(resident, town);
                }).setTitle(Translatable.of("msg_confirm_purchase", TownyEconomyHandler.getFormattedBalance(townReclaimCost))).sendTo((CommandSender)player);
            } else {
                TownRuinUtil.reclaimTown(resident, town);
            }
        }
        catch (TownyException e) {
            TownyMessaging.sendErrorMsg((Object)player, e.getMessage((CommandSender)player));
        }
    }

    public static void reclaimTown(Resident resident, Town town) {
        town.setRuined(false);
        town.setRuinedTime(0L);
        if (!town.getMayor().equals(resident)) {
            TownRuinUtil.setMayor(town, resident);
        }
        town.getPermissions().loadDefault(town);
        for (TownBlock townBlock : town.getTownBlocks()) {
            townBlock.getPermissions().loadDefault(town);
            townBlock.setChanged(false);
            townBlock.save();
        }
        town.save();
        Towny.getPlugin().resetCache();
        TownReclaimedEvent event = new TownReclaimedEvent(town, resident);
        Bukkit.getPluginManager().callEvent((Event)event);
        TownyMessaging.sendGlobalMessage(Translatable.of("msg_town_reclaimed", resident.getName(), town.getName()));
    }

    private static void setMayor(Town town, Resident newMayor) {
        Resident oldMayor = town.getMayor();
        town.setMayor(newMayor);
        if (oldMayor.isNPC()) {
            oldMayor.removeTown();
            TownyUniverse.getInstance().getDataSource().removeResident(oldMayor);
            town.setHasUpkeep(true);
        }
        TownyMessaging.sendPrefixedTownMessage(town, Translatable.of("msg_new_mayor", newMayor.getName()));
    }

    public static void evaluateRuinedTownRemovals() {
        TownyUniverse townyUniverse = TownyUniverse.getInstance();
        ArrayList<Town> towns = new ArrayList<Town>(townyUniverse.getDataSource().getTowns());
        ListIterator townItr = towns.listIterator();
        while (townItr.hasNext()) {
            Town town = (Town)townItr.next();
            if (!townyUniverse.getDataSource().hasTown(town.getName()) || !town.isRuined() || town.getRuinedTime() == 0L || TownRuinUtil.getTimeSinceRuining(town) <= TownySettings.getTownRuinsMaxDurationHours()) continue;
            townyUniverse.getDataSource().removeTown(town, false);
        }
    }

    public static int getTimeSinceRuining(Town town) {
        return TimeTools.getHours(System.currentTimeMillis() - town.getRuinedTime());
    }
}

