/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.tasks;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.TownyEconomyHandler;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Translatable;
import com.palmergames.bukkit.towny.object.Translation;
import com.palmergames.bukkit.towny.tasks.CooldownTimerTask;
import com.palmergames.bukkit.towny.tasks.TownyTimerTask;
import com.palmergames.paperlib.PaperLib;
import java.util.ArrayDeque;
import java.util.Queue;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerTeleportEvent;

public class TeleportWarmupTimerTask
extends TownyTimerTask {
    private static Queue<Resident> teleportQueue;

    public TeleportWarmupTimerTask(Towny plugin) {
        super(plugin);
        teleportQueue = new ArrayDeque<Resident>();
    }

    @Override
    public void run() {
        Resident resident;
        long currentTime = System.currentTimeMillis();
        while ((resident = teleportQueue.peek()) != null && currentTime > resident.getTeleportRequestTime() + (long)(TownySettings.getTeleportWarmupTime() * 1000)) {
            resident.clearTeleportRequest();
            Player p = TownyAPI.getInstance().getPlayer(resident);
            if (p != null) {
                PaperLib.teleportAsync((Entity)p, resident.getTeleportDestination(), PlayerTeleportEvent.TeleportCause.COMMAND);
                if (TownySettings.getSpawnCooldownTime() > 0) {
                    CooldownTimerTask.addCooldownTimer(resident.getName(), CooldownTimerTask.CooldownType.TELEPORT);
                }
            }
            teleportQueue.poll();
        }
    }

    public static void requestTeleport(Resident resident, Location spawnLoc) {
        resident.setTeleportRequestTime();
        resident.setTeleportDestination(spawnLoc);
        try {
            if (teleportQueue.contains(resident)) {
                teleportQueue.remove(resident);
            }
            teleportQueue.add(resident);
        }
        catch (NullPointerException e) {
            Towny.getPlugin().getLogger().severe("Error: Null returned from teleport queue.");
            e.printStackTrace();
        }
    }

    public static void abortTeleportRequest(Resident resident) {
        if (resident != null && teleportQueue.contains(resident)) {
            resident.clearTeleportRequest();
            teleportQueue.remove(resident);
            if (resident.getTeleportCost() != 0.0 && TownyEconomyHandler.isActive()) {
                try {
                    resident.getAccount().deposit(resident.getTeleportCost(), Translation.of("msg_cost_spawn_refund"));
                    resident.setTeleportCost(0.0);
                    TownyMessaging.sendResidentMessage(resident, Translatable.of("msg_cost_spawn_refund"));
                }
                catch (TownyException townyException) {
                    // empty catch block
                }
            }
        }
    }
}

