/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.tasks;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.regen.PlotBlockData;
import com.palmergames.bukkit.towny.regen.TownyRegenAPI;
import com.palmergames.bukkit.towny.tasks.TownyTimerTask;
import java.util.ArrayList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RepeatingTimerTask
extends TownyTimerTask {
    private static final Logger LOGGER = LogManager.getLogger(Towny.class);
    private Long timerCounter = 0L;

    public RepeatingTimerTask(Towny plugin) {
        super(plugin);
    }

    @Override
    public void run() {
        if (TownyRegenAPI.hasPlotChunks()) {
            this.timerCounter = this.timerCounter + 1L;
            if (Math.max(1L, TownySettings.getPlotManagementSpeed()) <= this.timerCounter) {
                for (PlotBlockData plotChunk : new ArrayList<PlotBlockData>(TownyRegenAPI.getPlotChunks().values())) {
                    if (plotChunk == null || plotChunk.restoreNextBlock()) continue;
                    TownyMessaging.sendDebugMsg("Revert on unclaim complete for " + plotChunk.getWorldName() + " " + plotChunk.getX() + "," + plotChunk.getZ());
                    TownyRegenAPI.deletePlotChunk(plotChunk);
                    TownyRegenAPI.deletePlotChunkSnapshot(plotChunk);
                }
                this.timerCounter = 0L;
            }
        }
        if (TownyRegenAPI.hasWorldCoords()) {
            try {
                PlotBlockData plotChunk;
                TownBlock townBlock = TownyRegenAPI.getWorldCoord().getTownBlock();
                plotChunk = new PlotBlockData(townBlock);
                plotChunk.initialize();
                if (!plotChunk.getBlockList().isEmpty() && plotChunk.getBlockList() != null) {
                    TownyRegenAPI.addPlotChunkSnapshot(plotChunk);
                }
                townBlock.setLocked(false);
                townBlock.save();
                this.plugin.updateCache(townBlock.getWorldCoord());
                if (!TownyRegenAPI.hasWorldCoords()) {
                    LOGGER.info("Plot snapshots completed.");
                }
            }
            catch (NotRegisteredException notRegisteredException) {
                // empty catch block
            }
        }
        if (TownyRegenAPI.hasDeleteTownBlockIdQueue()) {
            TownyRegenAPI.doDeleteTownBlockIds(TownyRegenAPI.getDeleteTownBlockIdQueue());
        }
    }
}

