/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.permissions;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.TownyPermission;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.permissions.PermissionNodes;
import com.palmergames.bukkit.util.BukkitTools;
import org.anjocaido.groupmanager.GroupManager;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;
import org.bukkit.permissions.PermissionAttachmentInfo;

public abstract class TownyPermissionSource {
    protected TownySettings settings;
    protected Towny plugin;
    protected GroupManager groupManager = null;

    public abstract String getPrefixSuffix(Resident var1, String var2);

    public abstract int getGroupPermissionIntNode(String var1, String var2);

    public abstract int getPlayerPermissionIntNode(String var1, String var2);

    public abstract String getPlayerGroup(Player var1);

    public abstract String getPlayerPermissionStringNode(String var1, String var2);

    protected int getEffectivePermIntNode(String playerName, String node) {
        Player player = BukkitTools.getPlayer(playerName);
        int biggest = -1;
        for (PermissionAttachmentInfo test : player.getEffectivePermissions()) {
            if (!test.getPermission().startsWith(node + ".")) continue;
            String[] split = test.getPermission().split("\\.");
            try {
                int i = Integer.parseInt(split[split.length - 1]);
                biggest = Math.max(biggest, i);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return biggest;
    }

    public boolean hasWildOverride(TownyWorld world, Player player, Material material, TownyPermission.ActionType action) {
        String blockPerm = PermissionNodes.TOWNY_WILD_ALL.getNode(action.toString().toLowerCase() + "." + material);
        return this.has(player, blockPerm) || this.unclaimedZoneAction(world, material, action);
    }

    public boolean unclaimedZoneAction(TownyWorld world, Material material, TownyPermission.ActionType action) {
        switch (action) {
            case BUILD: {
                return world.getUnclaimedZoneBuild() != false || world.isUnclaimedZoneIgnoreMaterial(material);
            }
            case DESTROY: {
                return world.getUnclaimedZoneDestroy() != false || world.isUnclaimedZoneIgnoreMaterial(material);
            }
            case SWITCH: {
                return world.getUnclaimedZoneSwitch() != false || world.isUnclaimedZoneIgnoreMaterial(material);
            }
            case ITEM_USE: {
                return world.getUnclaimedZoneItemUse() != false || world.isUnclaimedZoneIgnoreMaterial(material);
            }
        }
        return false;
    }

    public boolean hasOwnTownOverride(Player player, Material material, TownyPermission.ActionType action) {
        String blockPerm = PermissionNodes.TOWNY_CLAIMED_ALL.getNode("owntown." + action.toString().toLowerCase() + "." + material);
        return this.has(player, blockPerm) || this.hasAllTownOverride(player, material, action);
    }

    public boolean hasTownOwnedOverride(Player player, Material material, TownyPermission.ActionType action) {
        String blockPerm = PermissionNodes.TOWNY_CLAIMED_ALL.getNode("townowned." + action.toString().toLowerCase() + "." + material);
        return this.has(player, blockPerm) || this.hasOwnTownOverride(player, material, action) || this.hasAllTownOverride(player, material, action);
    }

    public boolean hasAllTownOverride(Player player, Material material, TownyPermission.ActionType action) {
        String blockPerm = PermissionNodes.TOWNY_CLAIMED_ALL.getNode("alltown." + action.toString().toLowerCase() + "." + material);
        return this.has(player, blockPerm);
    }

    public boolean isTownyAdmin(Player player) {
        return this.isTownyAdmin((Permissible)player);
    }

    public boolean isTownyAdmin(Permissible permissible) {
        return permissible == null || permissible.isOp() || this.strictHas(permissible, PermissionNodes.TOWNY_ADMIN.getNode());
    }

    public boolean testPermission(Player player, String perm) {
        return this.testPermission((Permissible)player, perm);
    }

    public boolean testPermission(Permissible permissible, String perm) {
        return this.isTownyAdmin(permissible) || this.strictHas(permissible, perm);
    }

    public boolean has(Player player, String node) {
        return player.isOp() || this.strictHas((Permissible)player, node);
    }

    private boolean strictHas(Permissible permissible, String node) {
        if (permissible.isPermissionSet(node)) {
            return permissible.hasPermission(node);
        }
        String[] parts = node.split("\\.");
        StringBuilder builder = new StringBuilder(node.length());
        for (String part : parts) {
            builder.append('*');
            if (permissible.hasPermission("-" + builder.toString())) {
                return false;
            }
            if (permissible.hasPermission(builder.toString())) {
                return true;
            }
            builder.deleteCharAt(builder.length() - 1);
            builder.append(part).append('.');
        }
        return false;
    }
}

