/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.object.statusscreens;

import com.palmergames.adventure.text.Component;
import com.palmergames.adventure.text.TextComponent;
import com.palmergames.adventure.text.event.ClickEvent;
import com.palmergames.adventure.text.event.HoverEvent;
import com.palmergames.adventure.text.format.NamedTextColor;
import com.palmergames.bukkit.util.Colors;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class StatusScreen {
    Map<String, TextComponent> components = new LinkedHashMap<String, TextComponent>();
    static final int MAX_WIDTH = 65;
    final TextComponent space = (TextComponent)Component.text(" ").color(NamedTextColor.WHITE);

    public void addComponentOf(String name, String text) {
        this.components.put(name, Component.text(text));
    }

    public void addComponentOf(String name, TextComponent component) {
        this.components.put(name, component);
    }

    public void addComponentOf(String name, String text, ClickEvent click) {
        this.components.put(name, (TextComponent)Component.text(text).clickEvent(click));
    }

    public void addComponentOf(String name, String text, HoverEvent hover) {
        this.components.put(name, (TextComponent)Component.text(text).hoverEvent(hover));
    }

    public void addComponentOf(String name, String text, HoverEvent hover, ClickEvent click) {
        this.components.put(name, (TextComponent)((TextComponent)Component.text(text).hoverEvent(hover)).clickEvent(click));
    }

    public void removeStatusComponent(String name) {
        this.components.remove(name);
    }

    public Collection<TextComponent> getComponents() {
        return Collections.unmodifiableCollection(this.components.values());
    }

    public boolean hasComponent(String name) {
        return this.components.containsKey(name);
    }

    public TextComponent getComponentOrNull(String name) {
        return this.components.get(name);
    }

    public boolean replaceComponent(String name, TextComponent component) {
        return this.components.replace(name, component) != null;
    }

    public List<TextComponent> getFormattedStatusScreen() {
        ArrayList<TextComponent> lines = new ArrayList<TextComponent>();
        TextComponent currentLine = Component.empty();
        ArrayList<TextComponent> components = new ArrayList<TextComponent>(this.components.values());
        String string = "";
        for (int i = 0; i < components.size(); ++i) {
            TextComponent nextComp = (TextComponent)components.get(i);
            if (currentLine.content().isEmpty() && currentLine.children().isEmpty()) {
                currentLine = nextComp;
                string = currentLine.content();
                continue;
            }
            if (nextComp.equals(Component.newline())) {
                lines.add(currentLine);
                currentLine = Component.empty();
                string = "";
                continue;
            }
            if (!nextComp.children().isEmpty()) {
                lines.add(currentLine);
                currentLine = Component.empty();
                string = "";
                for (Component child : nextComp.children()) {
                    lines.add((TextComponent)Component.empty().append(child));
                }
                continue;
            }
            if (Colors.strip(string).length() + nextComp.content().length() + 1 > 65) {
                lines.add(currentLine);
                currentLine = nextComp;
                string = currentLine.content();
                continue;
            }
            currentLine = (TextComponent)((TextComponent)currentLine.append(this.space)).append(nextComp);
            string = string + " " + nextComp.content();
        }
        if (!currentLine.content().isEmpty()) {
            lines.add(currentLine);
        } else if (!currentLine.children().isEmpty()) {
            for (Component child : currentLine.children()) {
                lines.add((TextComponent)Component.empty().append(child));
            }
        }
        return lines;
    }
}

