/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.object.economy.adapter;

import com.palmergames.bukkit.towny.object.economy.adapter.EconomyAdapter;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.World;

public class VaultEconomyAdapter
implements EconomyAdapter {
    private final Economy economy;

    public VaultEconomyAdapter(Economy economy) {
        this.economy = economy;
    }

    @Override
    public boolean add(String accountName, double amount, World world) {
        return this.economy.depositPlayer((String)accountName, (double)amount).type == EconomyResponse.ResponseType.SUCCESS;
    }

    @Override
    public boolean subtract(String accountName, double amount, World world) {
        return this.economy.withdrawPlayer((String)accountName, (double)amount).type == EconomyResponse.ResponseType.SUCCESS;
    }

    @Override
    public boolean hasAccount(String accountName) {
        return this.economy.hasAccount(accountName);
    }

    @Override
    public double getBalance(String accountName, World world) {
        return this.economy.getBalance(accountName);
    }

    @Override
    public void newAccount(String accountName) {
        this.economy.createPlayerAccount(accountName);
    }

    @Override
    public void deleteAccount(String accountName) {
        if (!this.economy.hasAccount(accountName)) {
            return;
        }
        this.economy.withdrawPlayer(accountName, this.economy.getBalance(accountName));
    }

    @Override
    public boolean setBalance(String accountName, double amount, World world) {
        double currentBalance = this.getBalance(accountName, world);
        double diff = Math.abs(amount - currentBalance);
        if (amount > currentBalance) {
            return this.add(accountName, diff, world);
        }
        if (amount < currentBalance) {
            return this.subtract(accountName, diff, world);
        }
        return true;
    }

    @Override
    public String getFormattedBalance(double balance) {
        return this.economy.format(balance);
    }
}

