/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.object;

import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.object.Coord;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownyWorld;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.jetbrains.annotations.Nullable;

public class WorldCoord
extends Coord {
    private final String worldName;

    public WorldCoord(String worldName, int x, int z) {
        super(x, z);
        this.worldName = worldName;
    }

    public WorldCoord(String worldName, Coord coord) {
        super(coord);
        this.worldName = worldName;
    }

    public WorldCoord(WorldCoord worldCoord) {
        super(worldCoord);
        this.worldName = worldCoord.getWorldName();
    }

    public String getWorldName() {
        return this.worldName;
    }

    public Coord getCoord() {
        return new Coord(this.getX(), this.getZ());
    }

    public static WorldCoord parseWorldCoord(Entity entity) {
        return WorldCoord.parseWorldCoord(entity.getLocation());
    }

    public static WorldCoord parseWorldCoord(String worldName, int blockX, int blockZ) {
        return new WorldCoord(worldName, WorldCoord.toCell(blockX), WorldCoord.toCell(blockZ));
    }

    public static WorldCoord parseWorldCoord(Location loc) {
        return WorldCoord.parseWorldCoord(loc.getWorld().getName(), loc.getBlockX(), loc.getBlockZ());
    }

    public static WorldCoord parseWorldCoord(Block block) {
        return WorldCoord.parseWorldCoord(block.getWorld().getName(), block.getX(), block.getZ());
    }

    @Override
    public WorldCoord add(int xOffset, int zOffset) {
        return new WorldCoord(this.getWorldName(), this.getX() + xOffset, this.getZ() + zOffset);
    }

    @Override
    public int hashCode() {
        int hash = 17;
        hash = hash * 27 + (this.worldName == null ? 0 : this.worldName.hashCode());
        hash = hash * 27 + this.getX();
        hash = hash * 27 + this.getZ();
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Coord)) {
            return false;
        }
        if (!(obj instanceof WorldCoord)) {
            Coord that = (Coord)obj;
            return this.getX() == that.getZ() && this.getZ() == that.getZ();
        }
        WorldCoord that = (WorldCoord)obj;
        return this.getX() == that.getX() && this.getZ() == that.getZ() && Objects.equals(this.worldName, that.worldName);
    }

    @Override
    public String toString() {
        return this.worldName + "," + super.toString();
    }

    public World getBukkitWorld() {
        return Bukkit.getWorld((String)this.worldName);
    }

    public TownyWorld getTownyWorld() throws NotRegisteredException {
        return TownyUniverse.getInstance().getDataSource().getWorld(this.worldName);
    }

    @Nullable
    public TownyWorld getTownyWorldOrNull() {
        return TownyAPI.getInstance().getTownyWorld(this.worldName);
    }

    public TownBlock getTownBlock() throws NotRegisteredException {
        if (!this.hasTownBlock()) {
            throw new NotRegisteredException();
        }
        return TownyUniverse.getInstance().getTownBlock(this);
    }

    @Nullable
    public TownBlock getTownBlockOrNull() {
        return TownyUniverse.getInstance().getTownBlockOrNull(this);
    }

    public boolean hasTownBlock() {
        return TownyUniverse.getInstance().hasTownBlock(this);
    }

    public boolean isWilderness() {
        return !this.hasTownBlock();
    }

    @Nullable
    public Town getTownOrNull() {
        if (this.hasTownBlock()) {
            return this.getTownBlockOrNull().getTownOrNull();
        }
        return null;
    }

    public static boolean cellChanged(Location from, Location to) {
        return WorldCoord.toCell(from.getBlockX()) != WorldCoord.toCell(to.getBlockX()) || WorldCoord.toCell(from.getBlockZ()) != WorldCoord.toCell(to.getBlockZ()) || !Objects.equals(from.getWorld(), to.getWorld());
    }
}

