/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.object;

import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Coord;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownyObject;
import com.palmergames.bukkit.towny.object.TownyPermission;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.bukkit.towny.object.metadata.CustomDataField;
import com.palmergames.util.MathUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TownyWorld
extends TownyObject {
    private HashMap<String, Town> towns = new HashMap();
    private boolean isUsingPlotManagementDelete = TownySettings.isUsingPlotManagementDelete();
    private List<String> plotManagementDeleteIds = null;
    private boolean isUsingPlotManagementMayorDelete = TownySettings.isUsingPlotManagementMayorDelete();
    private List<String> plotManagementMayorDelete = null;
    private boolean isUsingPlotManagementRevert = TownySettings.isUsingPlotManagementRevert();
    private List<String> plotManagementIgnoreIds = null;
    private boolean isUsingPlotManagementWildEntityRevert = TownySettings.isUsingPlotManagementWildEntityRegen();
    private long plotManagementWildRevertDelay = TownySettings.getPlotManagementWildRegenDelay();
    private List<String> entityExplosionProtection = null;
    private List<String> plotManagementWildRevertBlockWhitelist = null;
    private boolean isUsingPlotManagementWildBlockRevert = TownySettings.isUsingPlotManagementWildBlockRegen();
    private List<String> blockExplosionProtection = null;
    private List<String> unclaimedZoneIgnoreBlockMaterials = null;
    private Boolean unclaimedZoneBuild = null;
    private Boolean unclaimedZoneDestroy = null;
    private Boolean unclaimedZoneSwitch = null;
    private Boolean unclaimedZoneItemUse = null;
    private String unclaimedZoneName = null;
    private List<Coord> warZones = new ArrayList<Coord>();
    private boolean isUsingTowny = TownySettings.isUsingTowny();
    private boolean isClaimable = true;
    private boolean isWarAllowed = TownySettings.isWarAllowed();
    private boolean isPVP = TownySettings.isPvP();
    private boolean isForcePVP = TownySettings.isForcingPvP();
    private boolean isFriendlyFire = TownySettings.isFriendlyFireEnabled();
    private boolean isFire = TownySettings.isFire();
    private boolean isForceFire = TownySettings.isForcingFire();
    private boolean hasWorldMobs = TownySettings.isWorldMonstersOn();
    private boolean hasWildernessMonsters = TownySettings.isWildernessMonstersOn();
    private boolean isForceTownMobs = TownySettings.isForcingMonsters();
    private boolean isExplosion = TownySettings.isExplosions();
    private boolean isForceExpl = TownySettings.isForcingExplosions();
    private boolean isEndermanProtect = TownySettings.getEndermanProtect();
    private boolean isDisablePlayerTrample = TownySettings.isPlayerTramplingCropsDisabled();
    private boolean isDisableCreatureTrample = TownySettings.isCreatureTramplingCropsDisabled();
    public Map<Location, Material> bedMap = new HashMap<Location, Material>();
    public List<String> tridentStrikeMap = new ArrayList<String>();

    public TownyWorld(String name) {
        super(name);
    }

    public HashMap<String, Town> getTowns() {
        return this.towns;
    }

    public boolean hasTowns() {
        return !this.towns.isEmpty();
    }

    public boolean hasTown(String name) {
        return this.towns.containsKey(name);
    }

    public boolean hasTown(Town town) {
        return this.hasTown(town.getName());
    }

    public void addTown(Town town) {
        if (!this.hasTown(town)) {
            this.towns.put(town.getName(), town);
        }
    }

    public TownBlock getTownBlock(Coord coord) throws NotRegisteredException {
        if (!this.hasTownBlock(coord)) {
            throw new NotRegisteredException();
        }
        return TownyUniverse.getInstance().getTownBlock(new WorldCoord(this.getName(), coord));
    }

    public boolean hasTownBlock(Coord key) {
        return TownyUniverse.getInstance().hasTownBlock(new WorldCoord(this.getName(), key));
    }

    public TownBlock getTownBlock(int x, int z) throws NotRegisteredException {
        return this.getTownBlock(new Coord(x, z));
    }

    public List<TownBlock> getTownBlocks(Town town) {
        ArrayList<TownBlock> out = new ArrayList<TownBlock>();
        for (TownBlock townBlock : town.getTownBlocks()) {
            if (townBlock.getWorld() != this) continue;
            out.add(townBlock);
        }
        return out;
    }

    public Collection<TownBlock> getTownBlocks() {
        ArrayList<TownBlock> townBlocks = new ArrayList<TownBlock>();
        for (TownBlock townBlock : TownyUniverse.getInstance().getTownBlocks().values()) {
            if (townBlock.getWorld() != this) continue;
            townBlocks.add(townBlock);
        }
        return townBlocks;
    }

    public void removeTown(Town town) throws NotRegisteredException {
        if (!this.hasTown(town)) {
            throw new NotRegisteredException();
        }
        this.towns.remove(town.getName());
    }

    @Override
    public List<String> getTreeString(int depth) {
        ArrayList<String> out = new ArrayList<String>();
        out.add(this.getTreeDepth(depth) + "World (" + this.getName() + ")");
        out.add(this.getTreeDepth(depth + 1) + "TownBlocks (" + this.getTownBlocks().size() + "): ");
        return out;
    }

    public void setWarAllowed(boolean isWarAllowed) {
        this.isWarAllowed = isWarAllowed;
    }

    public boolean isWarAllowed() {
        return this.isWarAllowed;
    }

    public void setPVP(boolean isPVP) {
        this.isPVP = isPVP;
    }

    public boolean isPVP() {
        return this.isPVP;
    }

    public void setForcePVP(boolean isPVP) {
        this.isForcePVP = isPVP;
    }

    public boolean isForcePVP() {
        return this.isForcePVP;
    }

    public void setExpl(boolean isExpl) {
        this.isExplosion = isExpl;
    }

    public boolean isExpl() {
        return this.isExplosion;
    }

    public void setForceExpl(boolean isExpl) {
        this.isForceExpl = isExpl;
    }

    public boolean isForceExpl() {
        return this.isForceExpl;
    }

    public void setFire(boolean isFire) {
        this.isFire = isFire;
    }

    public boolean isFire() {
        return this.isFire;
    }

    public void setForceFire(boolean isFire) {
        this.isForceFire = isFire;
    }

    public boolean isForceFire() {
        return this.isForceFire;
    }

    public void setDisablePlayerTrample(boolean isDisablePlayerTrample) {
        this.isDisablePlayerTrample = isDisablePlayerTrample;
    }

    public boolean isDisablePlayerTrample() {
        return this.isDisablePlayerTrample;
    }

    public void setDisableCreatureTrample(boolean isDisableCreatureTrample) {
        this.isDisableCreatureTrample = isDisableCreatureTrample;
    }

    public boolean isDisableCreatureTrample() {
        return this.isDisableCreatureTrample;
    }

    public void setWorldMobs(boolean hasMobs) {
        this.hasWorldMobs = hasMobs;
    }

    public boolean hasWorldMobs() {
        return this.hasWorldMobs;
    }

    public void setWildernessMobs(boolean hasMonsters) {
        this.hasWildernessMonsters = hasMonsters;
    }

    public boolean hasWildernessMobs() {
        return this.hasWildernessMonsters;
    }

    public void setForceTownMobs(boolean setMobs) {
        this.isForceTownMobs = setMobs;
    }

    public boolean isForceTownMobs() {
        return this.isForceTownMobs;
    }

    public void setEndermanProtect(boolean setEnder) {
        this.isEndermanProtect = setEnder;
    }

    public boolean isEndermanProtect() {
        return this.isEndermanProtect;
    }

    public void setClaimable(boolean isClaimable) {
        this.isClaimable = isClaimable;
    }

    public boolean isClaimable() {
        if (!this.isUsingTowny()) {
            return false;
        }
        return this.isClaimable;
    }

    public void setUsingDefault() {
        this.setUnclaimedZoneBuild(null);
        this.setUnclaimedZoneDestroy(null);
        this.setUnclaimedZoneSwitch(null);
        this.setUnclaimedZoneItemUse(null);
        this.setUnclaimedZoneIgnore(null);
        this.setUnclaimedZoneName(null);
    }

    public void setUsingPlotManagementDelete(boolean using) {
        this.isUsingPlotManagementDelete = using;
    }

    public boolean isUsingPlotManagementDelete() {
        return this.isUsingPlotManagementDelete;
    }

    public void setUsingPlotManagementMayorDelete(boolean using) {
        this.isUsingPlotManagementMayorDelete = using;
    }

    public boolean isUsingPlotManagementMayorDelete() {
        return this.isUsingPlotManagementMayorDelete;
    }

    public void setUsingPlotManagementRevert(boolean using) {
        this.isUsingPlotManagementRevert = using;
    }

    public boolean isUsingPlotManagementRevert() {
        return this.isUsingPlotManagementRevert;
    }

    public List<String> getPlotManagementDeleteIds() {
        if (this.plotManagementDeleteIds == null) {
            return TownySettings.getPlotManagementDeleteIds();
        }
        return this.plotManagementDeleteIds;
    }

    public boolean isPlotManagementDeleteIds(String id) {
        return this.getPlotManagementDeleteIds().contains(id);
    }

    public void setPlotManagementDeleteIds(List<String> plotManagementDeleteIds) {
        this.plotManagementDeleteIds = plotManagementDeleteIds;
    }

    public List<String> getPlotManagementMayorDelete() {
        if (this.plotManagementMayorDelete == null) {
            return TownySettings.getPlotManagementMayorDelete();
        }
        return this.plotManagementMayorDelete;
    }

    public boolean isPlotManagementMayorDelete(String material) {
        return this.getPlotManagementMayorDelete().contains(material.toUpperCase());
    }

    public void setPlotManagementMayorDelete(List<String> plotManagementMayorDelete) {
        this.plotManagementMayorDelete = plotManagementMayorDelete;
    }

    public List<String> getPlotManagementIgnoreIds() {
        if (this.plotManagementIgnoreIds == null) {
            return TownySettings.getPlotManagementIgnoreIds();
        }
        return this.plotManagementIgnoreIds;
    }

    public boolean isPlotManagementIgnoreIds(Material mat) {
        return this.getPlotManagementIgnoreIds().contains(mat.toString());
    }

    public void setPlotManagementIgnoreIds(List<String> plotManagementIgnoreIds) {
        this.plotManagementIgnoreIds = plotManagementIgnoreIds;
    }

    public boolean isUsingPlotManagementWildEntityRevert() {
        return this.isUsingPlotManagementWildEntityRevert;
    }

    public boolean isUsingPlotManagementWildBlockRevert() {
        return this.isUsingPlotManagementWildBlockRevert;
    }

    public void setUsingPlotManagementWildEntityRevert(boolean isUsingPlotManagementWildEntityRevert) {
        this.isUsingPlotManagementWildEntityRevert = isUsingPlotManagementWildEntityRevert;
    }

    public void setUsingPlotManagementWildBlockRevert(boolean isUsingPlotManagementWildBlockRevert) {
        this.isUsingPlotManagementWildBlockRevert = isUsingPlotManagementWildBlockRevert;
    }

    public long getPlotManagementWildRevertDelay() {
        return this.plotManagementWildRevertDelay;
    }

    public void setPlotManagementWildRevertDelay(long plotManagementWildRevertDelay) {
        this.plotManagementWildRevertDelay = plotManagementWildRevertDelay;
    }

    public void setPlotManagementWildRevertEntities(List<String> entities) {
        this.entityExplosionProtection = new ArrayList<String>();
        for (String mob : entities) {
            if (mob.equals("")) continue;
            this.entityExplosionProtection.add(mob.toLowerCase());
        }
    }

    public List<String> getPlotManagementWildRevertEntities() {
        if (this.entityExplosionProtection == null) {
            this.setPlotManagementWildRevertEntities(TownySettings.getWildExplosionProtectionEntities());
        }
        return this.entityExplosionProtection;
    }

    public boolean isProtectingExplosionEntity(Entity entity) {
        if (this.entityExplosionProtection == null) {
            this.setPlotManagementWildRevertEntities(TownySettings.getWildExplosionProtectionEntities());
        }
        return this.entityExplosionProtection.contains(entity.getType().getEntityClass().getSimpleName().toLowerCase());
    }

    public void setPlotManagementWildRevertBlockWhitelist(List<String> mats) {
        this.plotManagementWildRevertBlockWhitelist = new ArrayList<String>();
        for (String mat : mats) {
            if (mat.equals("")) continue;
            this.plotManagementWildRevertBlockWhitelist.add(mat);
        }
    }

    public List<String> getPlotManagementWildRevertBlockWhitelist() {
        if (this.plotManagementWildRevertBlockWhitelist == null) {
            this.setPlotManagementWildRevertBlockWhitelist(TownySettings.getWildExplosionRevertBlockWhitelist());
        }
        return this.plotManagementWildRevertBlockWhitelist;
    }

    public boolean isPlotManagementWildRevertWhitelistedBlock(Material mat) {
        if (this.plotManagementWildRevertBlockWhitelist == null) {
            this.setPlotManagementWildRevertBlockWhitelist(TownySettings.getWildExplosionRevertBlockWhitelist());
        }
        return this.plotManagementWildRevertBlockWhitelist.isEmpty() || this.plotManagementWildRevertBlockWhitelist.contains(mat.name());
    }

    public boolean isBlockAllowedToRevert(Material mat) {
        if (this.getPlotManagementWildRevertBlockWhitelist().isEmpty()) {
            return !this.isPlotManagementIgnoreIds(mat);
        }
        return this.isPlotManagementWildRevertWhitelistedBlock(mat);
    }

    public void setPlotManagementWildRevertMaterials(List<String> mats) {
        this.blockExplosionProtection = new ArrayList<String>();
        for (String mat : mats) {
            if (mat.equals("")) continue;
            this.blockExplosionProtection.add(mat);
        }
    }

    public List<String> getPlotManagementWildRevertBlocks() {
        if (this.blockExplosionProtection == null) {
            this.setPlotManagementWildRevertMaterials(TownySettings.getWildExplosionProtectionBlocks());
        }
        return this.blockExplosionProtection;
    }

    public boolean isProtectingExplosionBlock(Material material) {
        if (this.blockExplosionProtection == null) {
            this.setPlotManagementWildRevertMaterials(TownySettings.getWildExplosionProtectionBlocks());
        }
        return this.blockExplosionProtection.contains(material.toString());
    }

    public void setUnclaimedZoneIgnore(List<String> unclaimedZoneIgnoreIds) {
        this.unclaimedZoneIgnoreBlockMaterials = unclaimedZoneIgnoreIds;
    }

    public List<String> getUnclaimedZoneIgnoreMaterials() {
        if (this.unclaimedZoneIgnoreBlockMaterials == null) {
            return TownySettings.getUnclaimedZoneIgnoreMaterials();
        }
        return this.unclaimedZoneIgnoreBlockMaterials;
    }

    public boolean isUnclaimedZoneIgnoreMaterial(Material mat) {
        return this.getUnclaimedZoneIgnoreMaterials().contains(mat.name());
    }

    public boolean getUnclaimedZonePerm(TownyPermission.ActionType type) {
        switch (type) {
            case BUILD: {
                return this.getUnclaimedZoneBuild();
            }
            case DESTROY: {
                return this.getUnclaimedZoneDestroy();
            }
            case SWITCH: {
                return this.getUnclaimedZoneSwitch();
            }
            case ITEM_USE: {
                return this.getUnclaimedZoneItemUse();
            }
        }
        throw new UnsupportedOperationException();
    }

    public Boolean getUnclaimedZoneBuild() {
        if (this.unclaimedZoneBuild == null) {
            return TownySettings.getUnclaimedZoneBuildRights();
        }
        return this.unclaimedZoneBuild;
    }

    public void setUnclaimedZoneBuild(Boolean unclaimedZoneBuild) {
        this.unclaimedZoneBuild = unclaimedZoneBuild;
    }

    public Boolean getUnclaimedZoneDestroy() {
        if (this.unclaimedZoneDestroy == null) {
            return TownySettings.getUnclaimedZoneDestroyRights();
        }
        return this.unclaimedZoneDestroy;
    }

    public void setUnclaimedZoneDestroy(Boolean unclaimedZoneDestroy) {
        this.unclaimedZoneDestroy = unclaimedZoneDestroy;
    }

    public Boolean getUnclaimedZoneSwitch() {
        if (this.unclaimedZoneSwitch == null) {
            return TownySettings.getUnclaimedZoneSwitchRights();
        }
        return this.unclaimedZoneSwitch;
    }

    public void setUnclaimedZoneSwitch(Boolean unclaimedZoneSwitch) {
        this.unclaimedZoneSwitch = unclaimedZoneSwitch;
    }

    public String getUnclaimedZoneName() {
        if (this.unclaimedZoneName == null) {
            return TownySettings.getUnclaimedZoneName();
        }
        return this.unclaimedZoneName;
    }

    public void setUnclaimedZoneName(String unclaimedZoneName) {
        this.unclaimedZoneName = unclaimedZoneName;
    }

    public void setUsingTowny(boolean isUsingTowny) {
        this.isUsingTowny = isUsingTowny;
    }

    public boolean isUsingTowny() {
        return this.isUsingTowny;
    }

    public void setUnclaimedZoneItemUse(Boolean unclaimedZoneItemUse) {
        this.unclaimedZoneItemUse = unclaimedZoneItemUse;
    }

    public Boolean getUnclaimedZoneItemUse() {
        if (this.unclaimedZoneItemUse == null) {
            return TownySettings.getUnclaimedZoneItemUseRights();
        }
        return this.unclaimedZoneItemUse;
    }

    public int getMinDistanceFromOtherTowns(Coord key) {
        return this.getMinDistanceFromOtherTowns(key, null);
    }

    public int getMinDistanceFromOtherTowns(Coord key, Town homeTown) {
        double minSqr = -1.0;
        int keyX = key.getX();
        int keyZ = key.getZ();
        for (Town town : this.getTowns().values()) {
            try {
                Coord townCoord = town.getHomeBlock().getCoord();
                if (homeTown != null && (homeTown.getUUID().equals(town.getUUID()) || TownySettings.isMinDistanceIgnoringTownsInSameNation() && homeTown.hasNation() && town.hasNation() && town.getNation().equals(homeTown.getNation()) || TownySettings.isMinDistanceIgnoringTownsInAlliedNation() && homeTown.isAlliedWith(town)) || !town.getHomeblockWorld().equals(this)) continue;
                double distSqr = MathUtil.distanceSquared((double)townCoord.getX() - (double)keyX, (double)townCoord.getZ() - (double)keyZ);
                if (minSqr != -1.0 && !(distSqr < minSqr)) continue;
                minSqr = distSqr;
            }
            catch (TownyException townyException) {}
        }
        return minSqr == -1.0 ? Integer.MAX_VALUE : (int)Math.ceil(Math.sqrt(minSqr));
    }

    public int getMinDistanceFromOtherTownsPlots(Coord key) {
        return this.getMinDistanceFromOtherTownsPlots(key, null);
    }

    public int getMinDistanceFromOtherTownsPlots(Coord key, Town homeTown) {
        int keyX = key.getX();
        int keyZ = key.getZ();
        double minSqr = -1.0;
        for (Town town : this.getTowns().values()) {
            try {
                if (homeTown != null && (homeTown.getUUID().equals(town.getUUID()) || TownySettings.isMinDistanceIgnoringTownsInSameNation() && homeTown.hasNation() && town.hasNation() && town.getNation().equals(homeTown.getNation()) || TownySettings.isMinDistanceIgnoringTownsInAlliedNation() && homeTown.isAlliedWith(town))) continue;
                for (TownBlock b : town.getTownBlocks()) {
                    if (!b.getWorld().equals(this)) continue;
                    int tbX = b.getX();
                    int tbZ = b.getZ();
                    if (keyX == tbX && keyZ == tbZ) continue;
                    double distSqr = MathUtil.distanceSquared((double)tbX - (double)keyX, (double)tbZ - (double)keyZ);
                    if (minSqr != -1.0 && !(distSqr < minSqr)) continue;
                    minSqr = distSqr;
                }
            }
            catch (TownyException townyException) {
            }
        }
        return minSqr == -1.0 ? Integer.MAX_VALUE : (int)Math.ceil(Math.sqrt(minSqr));
    }

    public int getMinDistanceFromOtherPlotsOwnedByTown(Coord key, Town town) {
        int keyX = key.getX();
        int keyZ = key.getZ();
        double minSqr = -1.0;
        for (TownBlock b : town.getTownBlocks()) {
            if (!b.getWorld().equals(this)) continue;
            int tbX = b.getX();
            int tbZ = b.getZ();
            if (keyX == tbX && keyZ == tbZ) continue;
            double distSqr = MathUtil.distanceSquared((double)tbX - (double)keyX, (double)tbZ - (double)keyZ);
            if (minSqr != -1.0 && !(distSqr < minSqr)) continue;
            minSqr = distSqr;
        }
        return minSqr == -1.0 ? Integer.MAX_VALUE : (int)Math.ceil(Math.sqrt(minSqr));
    }

    public Town getClosestTownWithNationFromCoord(Coord key, Town nearestTown) {
        int keyX = key.getX();
        int keyZ = key.getZ();
        double minSqr = -1.0;
        for (Town town : this.getTowns().values()) {
            if (!town.hasNation()) continue;
            for (TownBlock b : town.getTownBlocks()) {
                if (!b.getWorld().equals(this)) continue;
                int tbX = b.getX();
                int tbZ = b.getZ();
                double distSqr = MathUtil.distanceSquared((double)tbX - (double)keyX, (double)tbZ - (double)keyZ);
                if (minSqr != -1.0 && !(distSqr < minSqr)) continue;
                minSqr = distSqr;
                nearestTown = town;
            }
        }
        return nearestTown;
    }

    @Nullable
    public TownBlock getClosestTownblockWithNationFromCoord(Coord key) {
        int keyX = key.getX();
        int keyZ = key.getZ();
        double minSqr = -1.0;
        TownBlock tb = null;
        for (Town town : this.getTowns().values()) {
            if (!town.hasNation()) continue;
            for (TownBlock b : town.getTownBlocks()) {
                if (!b.getWorld().equals(this)) continue;
                int tbX = b.getX();
                int tbZ = b.getZ();
                double distSqr = MathUtil.distanceSquared((double)tbX - (double)keyX, (double)tbZ - (double)keyZ);
                if (minSqr != -1.0 && !(distSqr < minSqr)) continue;
                minSqr = distSqr;
                tb = b;
            }
        }
        return tb;
    }

    public void addWarZone(Coord coord) {
        if (!this.isWarZone(coord)) {
            this.warZones.add(coord);
        }
    }

    public void removeWarZone(Coord coord) {
        this.warZones.remove(coord);
    }

    public boolean isWarZone(Coord coord) {
        return this.warZones.contains(coord);
    }

    @Override
    public void addMetaData(@NotNull CustomDataField<?> md) {
        this.addMetaData(md, true);
    }

    @Override
    public void removeMetaData(@NotNull CustomDataField<?> md) {
        this.removeMetaData(md, true);
    }

    public boolean hasBedExplosionAtBlock(Location location) {
        return this.bedMap.containsKey(location);
    }

    @Nullable
    public Material getBedExplosionMaterial(Location location) {
        if (this.hasBedExplosionAtBlock(location)) {
            return this.bedMap.get(location);
        }
        return null;
    }

    public void addBedExplosionAtBlock(Location location, Material material) {
        this.bedMap.put(location, material);
    }

    public void removeBedExplosionAtBlock(Location location) {
        if (this.hasBedExplosionAtBlock(location)) {
            this.bedMap.remove(location);
        }
    }

    public boolean hasTridentStrike(int entityID) {
        return this.tridentStrikeMap.contains(String.valueOf(entityID));
    }

    public void addTridentStrike(int entityID) {
        this.tridentStrikeMap.add(String.valueOf(entityID));
    }

    public void removeTridentStrike(int entityID) {
        if (this.hasTridentStrike(entityID)) {
            this.tridentStrikeMap.remove(String.valueOf(entityID));
        }
    }

    public void setFriendlyFire(boolean parseBoolean) {
        this.isFriendlyFire = parseBoolean;
    }

    public boolean isFriendlyFireEnabled() {
        return this.isFriendlyFire;
    }

    @Override
    public void save() {
        TownyUniverse.getInstance().getDataSource().saveWorld(this);
    }
}

