/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.listeners;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.event.executors.TownyActionEventExecutor;
import com.palmergames.bukkit.towny.utils.EntityTypeUtil;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Minecart;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.vehicle.VehicleBlockCollisionEvent;
import org.bukkit.event.vehicle.VehicleDamageEvent;
import org.bukkit.event.vehicle.VehicleEnterEvent;
import org.bukkit.inventory.ItemStack;

public class TownyVehicleListener
implements Listener {
    private final Towny plugin;

    public TownyVehicleListener(Towny instance) {
        this.plugin = instance;
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onVehicleDamage(VehicleDamageEvent event) {
        if (this.plugin.isError()) {
            event.setCancelled(true);
            return;
        }
        if (!TownyAPI.getInstance().isTownyWorld(event.getVehicle().getWorld())) {
            return;
        }
        if (event.getAttacker() == null) {
            event.setCancelled(!TownyActionEventExecutor.canExplosionDamageEntities(event.getVehicle().getLocation(), (Entity)event.getVehicle(), EntityDamageEvent.DamageCause.ENTITY_EXPLOSION));
            return;
        }
        if (event.getAttacker() instanceof Player) {
            Player player = (Player)event.getAttacker();
            Material vehicle = null;
            switch (event.getVehicle().getType()) {
                case MINECART: 
                case MINECART_FURNACE: 
                case MINECART_HOPPER: 
                case MINECART_CHEST: 
                case MINECART_MOB_SPAWNER: 
                case MINECART_COMMAND: 
                case MINECART_TNT: 
                case BOAT: {
                    vehicle = EntityTypeUtil.parseEntityToMaterial(event.getVehicle().getType());
                    break;
                }
            }
            if (vehicle != null) {
                event.setCancelled(!TownyActionEventExecutor.canDestroy(player, event.getVehicle().getLocation(), vehicle));
            }
        } else if (EntityTypeUtil.isExplosive(event.getAttacker().getType()) && !TownyActionEventExecutor.canExplosionDamageEntities(event.getVehicle().getLocation(), (Entity)event.getVehicle(), EntityDamageEvent.DamageCause.ENTITY_EXPLOSION)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onVehicleCollide(VehicleBlockCollisionEvent event) {
        if (this.plugin.isError() || !TownyAPI.getInstance().isTownyWorld(event.getVehicle().getWorld())) {
            return;
        }
        if (event.getBlock().getType() == Material.CACTUS && event.getVehicle() instanceof Minecart) {
            event.getVehicle().remove();
            Bukkit.getWorld((String)event.getBlock().getWorld().getName()).dropItemNaturally(event.getVehicle().getLocation(), new ItemStack(EntityTypeUtil.parseEntityToMaterial(event.getVehicle().getType())));
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onVehicleEnter(VehicleEnterEvent event) {
        if (this.plugin.isError()) {
            event.setCancelled(true);
            return;
        }
        if (!TownyAPI.getInstance().isTownyWorld(event.getVehicle().getWorld())) {
            return;
        }
        if (event.getEntered() instanceof Player) {
            Player player = (Player)event.getEntered();
            Material vehicle = null;
            switch (event.getVehicle().getType()) {
                case MINECART: 
                case BOAT: {
                    vehicle = EntityTypeUtil.parseEntityToMaterial(event.getVehicle().getType());
                    break;
                }
                case HORSE: 
                case STRIDER: 
                case PIG: 
                case DONKEY: 
                case MULE: {
                    vehicle = Material.SADDLE;
                    break;
                }
            }
            if (vehicle != null && TownySettings.isSwitchMaterial(vehicle.name())) {
                event.setCancelled(!TownyActionEventExecutor.canSwitch(player, event.getVehicle().getLocation(), vehicle));
            }
        }
    }
}

