/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.listeners;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.event.executors.TownyActionEventExecutor;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.bukkit.towny.regen.TownyRegenAPI;
import com.palmergames.bukkit.towny.regen.block.BlockLocation;
import com.palmergames.bukkit.towny.utils.BorderUtil;
import com.palmergames.bukkit.util.BlockUtil;
import com.palmergames.bukkit.util.ItemLists;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.block.data.type.Chest;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockBurnEvent;
import org.bukkit.event.block.BlockCanBuildEvent;
import org.bukkit.event.block.BlockDispenseEvent;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.block.BlockFertilizeEvent;
import org.bukkit.event.block.BlockFromToEvent;
import org.bukkit.event.block.BlockIgniteEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.EntityBlockFormEvent;

public class TownyBlockListener
implements Listener {
    private final Towny plugin;

    public TownyBlockListener(Towny instance) {
        this.plugin = instance;
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onBlockBreak(BlockBreakEvent event) {
        if (this.plugin.isError()) {
            event.setCancelled(true);
            return;
        }
        Block block = event.getBlock();
        if (!TownyAPI.getInstance().isTownyWorld(block.getWorld())) {
            return;
        }
        event.setCancelled(!TownyActionEventExecutor.canDestroy(event.getPlayer(), block.getLocation(), block.getType()));
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onBlockPlace(BlockPlaceEvent event) {
        if (this.plugin.isError()) {
            event.setCancelled(true);
            return;
        }
        Block block = event.getBlock();
        if (!TownyAPI.getInstance().isTownyWorld(block.getWorld())) {
            return;
        }
        if (block.getType() == Material.FIRE && block.getRelative(BlockFace.DOWN).getType() == Material.OBSIDIAN) {
            return;
        }
        if (!TownyActionEventExecutor.canBuild(event.getPlayer(), block.getLocation(), block.getType())) {
            event.setBuild(false);
            event.setCancelled(true);
        }
        if (!event.isCancelled() && block.getType() == Material.CHEST && !TownyUniverse.getInstance().getPermissionSource().isTownyAdmin(event.getPlayer())) {
            this.testDoubleChest(event.getPlayer(), event.getBlock());
        }
    }

    @EventHandler
    public void onBlockCanBuild(BlockCanBuildEvent event) {
        if (event.getMaterial().name().equals("POWDER_SNOW")) {
            Block block = event.getBlock();
            if (!TownyAPI.getInstance().isTownyWorld(block.getWorld())) {
                return;
            }
            if (!TownyActionEventExecutor.canBuild(event.getPlayer(), event.getBlock().getLocation(), event.getBlock().getType())) {
                event.setBuildable(false);
            }
        }
    }

    private void testDoubleChest(Player player, Block block) {
        ArrayList<Block> blocksToUpdate = new ArrayList<Block>();
        ArrayList<WorldCoord> safeWorldCoords = new ArrayList<WorldCoord>();
        for (BlockFace face : BlockUtil.CARDINAL_BLOCKFACES) {
            WorldCoord wc;
            Block testBlock = block.getRelative(face);
            if (BlockUtil.sameWorldCoord(block, testBlock) || testBlock.getType() != Material.CHEST || safeWorldCoords.contains(wc = WorldCoord.parseWorldCoord(testBlock))) continue;
            Chest data = (Chest)block.getBlockData();
            Chest testData = (Chest)testBlock.getBlockData();
            if (!data.getFacing().equals((Object)testData.getFacing()) || (data.getFacing().equals((Object)BlockFace.SOUTH) || data.getFacing().equals((Object)BlockFace.NORTH)) && block.getZ() != testBlock.getZ() || (data.getFacing().equals((Object)BlockFace.EAST) || data.getFacing().equals((Object)BlockFace.WEST)) && block.getX() != testBlock.getX()) continue;
            if (BlockUtil.sameOwnerOrHasMayorOverride(block, testBlock, player)) {
                safeWorldCoords.add(wc);
                continue;
            }
            blocksToUpdate.add(testBlock);
            data.setType(Chest.Type.SINGLE);
            block.setBlockData((BlockData)data);
            testData.setType(Chest.Type.SINGLE);
            testBlock.setBlockData((BlockData)testData);
        }
        if (!blocksToUpdate.isEmpty()) {
            for (Block b : blocksToUpdate) {
                player.sendBlockChange(b.getLocation(), b.getBlockData());
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onBlockBurn(BlockBurnEvent event) {
        if (this.plugin.isError()) {
            event.setCancelled(true);
            return;
        }
        if (!TownyAPI.getInstance().isTownyWorld(event.getBlock().getWorld())) {
            return;
        }
        event.setCancelled(!TownyActionEventExecutor.canBurn(event.getBlock()));
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onBlockIgnite(BlockIgniteEvent event) {
        if (this.plugin.isError()) {
            event.setCancelled(true);
            return;
        }
        if (!TownyAPI.getInstance().isTownyWorld(event.getBlock().getWorld())) {
            return;
        }
        event.setCancelled(!TownyActionEventExecutor.canBurn(event.getBlock()));
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onBlockPistonRetract(BlockPistonRetractEvent event) {
        List blocks;
        if (this.plugin.isError()) {
            event.setCancelled(true);
            return;
        }
        if (!TownyAPI.getInstance().isTownyWorld(event.getBlock().getWorld())) {
            return;
        }
        if (!this.canBlockMove(event.getBlock(), event.isSticky() ? event.getBlock().getRelative(event.getDirection().getOppositeFace()) : event.getBlock().getRelative(event.getDirection()), false)) {
            event.setCancelled(true);
        }
        if (!(blocks = event.getBlocks()).isEmpty()) {
            for (Block block : blocks) {
                if (this.canBlockMove(block, block.getRelative(event.getDirection()), false)) continue;
                event.setCancelled(true);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onBlockPistonExtend(BlockPistonExtendEvent event) {
        List blocks;
        boolean allowWild;
        if (this.plugin.isError()) {
            event.setCancelled(true);
            return;
        }
        if (!TownyAPI.getInstance().isTownyWorld(event.getBlock().getWorld())) {
            return;
        }
        TownyWorld world = TownyAPI.getInstance().getTownyWorld(event.getBlock().getWorld().getName());
        boolean bl = allowWild = world != null && world.getUnclaimedZoneBuild() != false;
        if (!this.canBlockMove(event.getBlock(), event.getBlock().getRelative(event.getDirection()), allowWild)) {
            event.setCancelled(true);
        }
        if (!(blocks = event.getBlocks()).isEmpty()) {
            for (Block block : blocks) {
                if (this.canBlockMove(block, block.getRelative(event.getDirection()), allowWild)) continue;
                event.setCancelled(true);
            }
        }
    }

    private boolean canBlockMove(Block block, Block blockTo, boolean allowWild) {
        WorldCoord to;
        WorldCoord from = WorldCoord.parseWorldCoord(block);
        if (from.equals(to = WorldCoord.parseWorldCoord(blockTo)) || allowWild && to.isWilderness() || to.isWilderness() && from.isWilderness()) {
            return true;
        }
        try {
            TownBlock currentTownBlock = from.getTownBlock();
            TownBlock destinationTownBlock = to.getTownBlock();
            if (currentTownBlock.hasResident() && destinationTownBlock.hasResident() && currentTownBlock.getResidentOrNull() == destinationTownBlock.getResidentOrNull()) {
                return true;
            }
            return currentTownBlock.getTown() == destinationTownBlock.getTown() && !currentTownBlock.hasResident() && !destinationTownBlock.hasResident();
        }
        catch (NotRegisteredException e) {
            return false;
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onCreateExplosion(BlockExplodeEvent event) {
        if (this.plugin.isError()) {
            event.setCancelled(true);
            return;
        }
        if (!TownyAPI.getInstance().isTownyWorld(event.getBlock().getWorld())) {
            return;
        }
        TownyWorld townyWorld = TownyAPI.getInstance().getTownyWorld(event.getBlock().getWorld().getName());
        Material material = event.getBlock().getType();
        if (material == Material.AIR && townyWorld.hasBedExplosionAtBlock(event.getBlock().getLocation())) {
            material = townyWorld.getBedExplosionMaterial(event.getBlock().getLocation());
        }
        List<Block> blocks = TownyActionEventExecutor.filterExplodableBlocks(event.blockList(), material, null, (Event)event);
        event.blockList().clear();
        event.blockList().addAll(blocks);
        if (event.blockList().isEmpty()) {
            return;
        }
        if (townyWorld.isUsingPlotManagementWildBlockRevert() && townyWorld.isProtectingExplosionBlock(material)) {
            int count = 0;
            for (Block block : event.blockList()) {
                if (!TownyAPI.getInstance().isWilderness(block) || !townyWorld.isBlockAllowedToRevert(block.getType()) || TownyRegenAPI.hasProtectionRegenTask(new BlockLocation(block.getLocation()))) continue;
                TownyRegenAPI.beginProtectionRegenTask(block, ++count, townyWorld, (Event)event);
            }
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onFrostWalkerFreezeWater(EntityBlockFormEvent event) {
        if (this.plugin.isError()) {
            event.setCancelled(true);
            return;
        }
        if (!TownyAPI.getInstance().isTownyWorld(event.getBlock().getWorld()) || !TownySettings.doesFrostWalkerRequireBuildPerms()) {
            return;
        }
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            event.setCancelled(!TownyActionEventExecutor.canBuild(player, event.getBlock().getLocation(), event.getBlock().getType()));
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onBlockFromToEvent(BlockFromToEvent event) {
        if (this.plugin.isError()) {
            event.setCancelled(true);
            return;
        }
        if (!TownyAPI.getInstance().isTownyWorld(event.getBlock().getWorld())) {
            return;
        }
        if (!TownySettings.getPreventFluidGriefingEnabled() || event.getBlock().getType() == Material.DRAGON_EGG) {
            return;
        }
        if (!this.canBlockMove(event.getBlock(), event.getToBlock(), true)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onBlockDispense(BlockDispenseEvent event) {
        if (this.plugin.isError()) {
            event.setCancelled(true);
            return;
        }
        if (!TownyAPI.getInstance().isTownyWorld(event.getBlock().getWorld())) {
            return;
        }
        if (event.getBlock().getType() != Material.DISPENSER) {
            return;
        }
        Material mat = event.getItem().getType();
        if (ItemLists.BUCKETS.contains(mat.name()) && !TownySettings.getPreventFluidGriefingEnabled()) {
            return;
        }
        if (!ItemLists.BUCKETS.contains(mat.name()) && mat != Material.BONE_MEAL && mat != Material.HONEYCOMB) {
            return;
        }
        if (!this.canBlockMove(event.getBlock(), event.getBlock().getRelative(((Directional)event.getBlock().getBlockData()).getFacing()), true)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onBlockFertilize(BlockFertilizeEvent event) {
        if (this.plugin.isError()) {
            event.setCancelled(true);
            return;
        }
        if (!TownyAPI.getInstance().isTownyWorld(event.getBlock().getWorld())) {
            return;
        }
        List<BlockState> allowed = BorderUtil.allowedBlocks(event.getBlocks(), event.getBlock());
        event.getBlocks().clear();
        event.getBlocks().addAll(allowed);
    }
}

