/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.event.damage;

import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.event.damage.TownyDamageEvent;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.bukkit.event.entity.EntityDamageEvent;
import org.jetbrains.annotations.Nullable;

public class TownyPlayerDamagePlayerEvent
extends TownyDamageEvent {
    private static final HandlerList handlers = new HandlerList();
    private final Player player;

    public TownyPlayerDamagePlayerEvent(Location location, Entity harmedEntity, EntityDamageEvent.DamageCause cause, TownBlock townblock, boolean cancelled, Player attackingPlayer) {
        super(location, harmedEntity, cause, townblock, cancelled);
        this.player = attackingPlayer;
    }

    public static HandlerList getHandlerList() {
        return handlers;
    }

    public HandlerList getHandlers() {
        return handlers;
    }

    public Player getAttackingPlayer() {
        return this.player;
    }

    public Player getVictimPlayer() {
        return (Player)this.entity;
    }

    @Nullable
    public Resident getAttackingResident() {
        return TownyUniverse.getInstance().getResident(this.player.getUniqueId());
    }

    @Nullable
    public Resident getVictimResident() {
        return TownyUniverse.getInstance().getResident(this.getVictimPlayer().getUniqueId());
    }

    @Nullable
    public Town getAttackerTown() {
        return this.getAttackingResident().getTownOrNull();
    }

    @Nullable
    public Town getVictimTown() {
        return this.getVictimResident().getTownOrNull();
    }
}

