/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.db;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.TownyEconomyHandler;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.db.TownyDataSource;
import com.palmergames.bukkit.towny.db.TownyFlatFileSource;
import com.palmergames.bukkit.towny.event.DeleteNationEvent;
import com.palmergames.bukkit.towny.event.DeletePlayerEvent;
import com.palmergames.bukkit.towny.event.DeleteTownEvent;
import com.palmergames.bukkit.towny.event.NationRemoveTownEvent;
import com.palmergames.bukkit.towny.event.PreDeleteNationEvent;
import com.palmergames.bukkit.towny.event.PreDeleteTownEvent;
import com.palmergames.bukkit.towny.event.RenameNationEvent;
import com.palmergames.bukkit.towny.event.RenameResidentEvent;
import com.palmergames.bukkit.towny.event.RenameTownEvent;
import com.palmergames.bukkit.towny.event.town.TownPreUnclaimEvent;
import com.palmergames.bukkit.towny.event.town.TownUnclaimEvent;
import com.palmergames.bukkit.towny.exceptions.AlreadyRegisteredException;
import com.palmergames.bukkit.towny.exceptions.InvalidNameException;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.PlotGroup;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownBlockType;
import com.palmergames.bukkit.towny.object.TownyObject;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.object.Translatable;
import com.palmergames.bukkit.towny.object.Translation;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.bukkit.towny.object.jail.Jail;
import com.palmergames.bukkit.towny.object.jail.UnJailReason;
import com.palmergames.bukkit.towny.object.metadata.DataFieldIO;
import com.palmergames.bukkit.towny.regen.PlotBlockData;
import com.palmergames.bukkit.towny.regen.TownyRegenAPI;
import com.palmergames.bukkit.towny.tasks.DeleteFileTask;
import com.palmergames.bukkit.towny.utils.JailUtil;
import com.palmergames.bukkit.towny.utils.TownRuinUtil;
import com.palmergames.bukkit.towny.war.eventwar.WarSpoils;
import com.palmergames.bukkit.util.BukkitTools;
import com.palmergames.bukkit.util.NameValidation;
import com.palmergames.util.FileMgmt;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.stream.Collectors;
import java.util.zip.ZipFile;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import org.jetbrains.annotations.Nullable;

public abstract class TownyDatabaseHandler
extends TownyDataSource {
    final String rootFolderPath;
    final String dataFolderPath;
    final String settingsFolderPath;
    final String logFolderPath;
    final String backupFolderPath;
    Logger logger = LogManager.getLogger(TownyDatabaseHandler.class);
    protected final Queue<Runnable> queryQueue = new ConcurrentLinkedQueue<Runnable>();
    private final BukkitTask task;

    protected TownyDatabaseHandler(Towny plugin, TownyUniverse universe) {
        super(plugin, universe);
        this.rootFolderPath = universe.getRootFolder();
        this.dataFolderPath = this.rootFolderPath + File.separator + "data";
        this.settingsFolderPath = this.rootFolderPath + File.separator + "settings";
        this.logFolderPath = this.rootFolderPath + File.separator + "logs";
        this.backupFolderPath = this.rootFolderPath + File.separator + "backup";
        if (!FileMgmt.checkOrCreateFolders(this.rootFolderPath, this.rootFolderPath + File.separator + "logs", this.dataFolderPath, this.dataFolderPath + File.separator + "plot-block-data") || !FileMgmt.checkOrCreateFiles(this.dataFolderPath + File.separator + "regen.txt", this.dataFolderPath + File.separator + "snapshot_queue.txt")) {
            TownyMessaging.sendErrorMsg("Could not create flatfile default files and folders.");
        }
        this.task = BukkitTools.getScheduler().runTaskTimerAsynchronously((Plugin)plugin, () -> {
            while (!this.queryQueue.isEmpty()) {
                Runnable operation = this.queryQueue.poll();
                operation.run();
            }
        }, 5L, 5L);
    }

    @Override
    public void finishTasks() {
        this.task.cancel();
        while (!this.queryQueue.isEmpty()) {
            Runnable operation = this.queryQueue.poll();
            operation.run();
        }
    }

    @Override
    public boolean backup() throws IOException {
        if (!TownySettings.getSaveDatabase().equalsIgnoreCase("flatfile")) {
            this.plugin.getLogger().info("***** Warning *****");
            this.plugin.getLogger().info("***** Only Snapshots & Regen files in towny\\data\\ will be backed up!");
            this.plugin.getLogger().info("***** This does not include your residents/towns/nations.");
            this.plugin.getLogger().info("***** Make sure you have scheduled a backup in MySQL too!!!");
        }
        String backupType = TownySettings.getFlatFileBackupType();
        long t = System.currentTimeMillis();
        String newBackupFolder = this.backupFolderPath + File.separator + new SimpleDateFormat("yyyy-MM-dd HH-mm").format(t) + " - " + t;
        FileMgmt.checkOrCreateFolders(this.rootFolderPath, this.rootFolderPath + File.separator + "backup");
        switch (backupType.toLowerCase()) {
            case "folder": {
                FileMgmt.checkOrCreateFolder(newBackupFolder);
                FileMgmt.copyDirectory(new File(this.dataFolderPath), new File(newBackupFolder));
                FileMgmt.copyDirectory(new File(this.logFolderPath), new File(newBackupFolder));
                FileMgmt.copyDirectory(new File(this.settingsFolderPath), new File(newBackupFolder));
                return true;
            }
            case "zip": {
                FileMgmt.zipDirectories(new File(newBackupFolder + ".zip"), new File(this.dataFolderPath), new File(this.logFolderPath), new File(this.settingsFolderPath));
                return true;
            }
            case "tar.gz": 
            case "tar": {
                FileMgmt.tar(new File(newBackupFolder.concat(".tar.gz")), new File(this.dataFolderPath), new File(this.logFolderPath), new File(this.settingsFolderPath));
                return true;
            }
        }
        return false;
    }

    @Override
    public void newResident(String name) throws AlreadyRegisteredException, NotRegisteredException {
        this.newResident(name, null);
    }

    @Override
    public void newResident(String name, UUID uuid) throws AlreadyRegisteredException, NotRegisteredException {
        String filteredName;
        try {
            filteredName = NameValidation.checkAndFilterPlayerName(name);
        }
        catch (InvalidNameException e) {
            throw new NotRegisteredException(e.getMessage());
        }
        if (this.universe.hasResident(name)) {
            throw new AlreadyRegisteredException("A resident with the name " + filteredName + " is already in use.");
        }
        Resident resident = new Resident(filteredName);
        if (uuid != null) {
            resident.setUUID(uuid);
        }
        this.universe.registerResident(resident);
    }

    @Override
    @Deprecated
    public void newTown(String name) throws AlreadyRegisteredException, NotRegisteredException {
        try {
            this.universe.newTown(name);
        }
        catch (InvalidNameException e) {
            throw new NotRegisteredException(e.getMessage());
        }
    }

    @Override
    public void newNation(String name) throws AlreadyRegisteredException, NotRegisteredException {
        this.newNation(name, null);
    }

    @Override
    public void newNation(String name, @Nullable UUID uuid) throws AlreadyRegisteredException, NotRegisteredException {
        String filteredName;
        try {
            filteredName = NameValidation.checkAndFilterName(name);
        }
        catch (InvalidNameException e) {
            throw new NotRegisteredException(e.getMessage());
        }
        if (this.universe.hasNation(filteredName)) {
            throw new AlreadyRegisteredException("The nation " + filteredName + " is already in use.");
        }
        Nation nation = new Nation(filteredName);
        if (uuid != null) {
            nation.setUUID(uuid);
        }
        this.universe.registerNation(nation);
    }

    @Override
    public void newWorld(String name) throws AlreadyRegisteredException {
        if (this.universe.getWorldMap().containsKey(name.toLowerCase())) {
            throw new AlreadyRegisteredException("The world " + name + " is already in use.");
        }
        this.universe.getWorldMap().put(name.toLowerCase(), new TownyWorld(name));
    }

    @Override
    @Deprecated
    public boolean hasResident(String name) {
        return this.universe.hasResident(name);
    }

    @Override
    @Deprecated
    public boolean hasTown(String name) {
        return this.universe.hasTown(name);
    }

    @Override
    @Deprecated
    public boolean hasNation(String name) {
        return this.universe.hasNation(name);
    }

    @Override
    @Deprecated
    public Set<String> getResidentKeys() {
        return this.universe.getResidents().stream().map(TownyObject::getName).collect(Collectors.toSet());
    }

    @Override
    @Deprecated
    public Set<String> getTownsKeys() {
        return this.universe.getTownsMap().keySet();
    }

    @Override
    @Deprecated
    public Set<String> getNationsKeys() {
        return this.universe.getNations().stream().map(TownyObject::getName).collect(Collectors.toSet());
    }

    @Override
    public List<Resident> getResidents(Player player, String[] names) {
        ArrayList<Resident> invited = new ArrayList<Resident>();
        for (String name : names) {
            Resident target = this.universe.getResident(name);
            if (target == null) {
                TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_not_registered_1", name));
                continue;
            }
            invited.add(target);
        }
        return invited;
    }

    @Override
    public List<Resident> getResidents(String[] names) {
        ArrayList<Resident> matches = new ArrayList<Resident>();
        for (String name : names) {
            Resident matchRes = this.universe.getResident(name);
            if (matchRes == null) continue;
            matches.add(matchRes);
        }
        return matches;
    }

    @Override
    public List<Resident> getResidents(UUID[] uuids) {
        return Arrays.stream(uuids).filter(Objects::nonNull).map(this.universe::getResident).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    @Deprecated
    public List<Resident> getResidents() {
        return new ArrayList<Resident>(this.universe.getResidents());
    }

    @Override
    @Deprecated
    public Resident getResident(String name) throws NotRegisteredException {
        Resident res = this.universe.getResident(name);
        if (res == null) {
            throw new NotRegisteredException(String.format("The resident '%s' is not registered.", name));
        }
        return res;
    }

    @Override
    public List<Resident> getResidentsWithoutTown() {
        ArrayList<Resident> residentFilter = new ArrayList<Resident>();
        for (Resident resident : this.universe.getResidents()) {
            if (resident.hasTown()) continue;
            residentFilter.add(resident);
        }
        return residentFilter;
    }

    @Override
    public List<Town> getTowns(String[] names) {
        ArrayList<Town> matches = new ArrayList<Town>();
        for (String name : names) {
            Town t = this.universe.getTown(name);
            if (t == null) continue;
            matches.add(t);
        }
        return matches;
    }

    @Override
    @Deprecated
    public List<Town> getTowns() {
        return new ArrayList<Town>(this.universe.getTowns());
    }

    @Override
    @Deprecated
    public Town getTown(String name) throws NotRegisteredException {
        Town town = this.universe.getTown(name);
        if (town == null) {
            throw new NotRegisteredException(String.format("The town with name '%s' is not registered!", name));
        }
        return town;
    }

    @Override
    @Deprecated
    public Town getTown(UUID uuid) throws NotRegisteredException {
        Town town = this.universe.getTown(uuid);
        if (town == null) {
            throw new NotRegisteredException(String.format("The town with uuid '%s' is not registered.", uuid));
        }
        return town;
    }

    @Override
    public List<Town> getTownsWithoutNation() {
        ArrayList<Town> townFilter = new ArrayList<Town>();
        for (Town town : this.getTowns()) {
            if (town.hasNation()) continue;
            townFilter.add(town);
        }
        return townFilter;
    }

    @Override
    public List<Nation> getNations(String[] names) {
        ArrayList<Nation> matches = new ArrayList<Nation>();
        for (String name : names) {
            Nation nation = this.universe.getNation(name);
            if (nation == null) continue;
            matches.add(nation);
        }
        return matches;
    }

    @Override
    @Deprecated
    public List<Nation> getNations() {
        return new ArrayList<Nation>(this.universe.getNations());
    }

    @Override
    @Deprecated
    public Nation getNation(String name) throws NotRegisteredException {
        Nation nation = this.universe.getNation(name);
        if (nation == null) {
            throw new NotRegisteredException(String.format("The nation '%s' is not registered.", name));
        }
        return nation;
    }

    @Override
    @Deprecated
    public Nation getNation(UUID uuid) throws NotRegisteredException {
        Nation nation = this.universe.getNation(uuid);
        if (nation == null) {
            throw new NotRegisteredException(String.format("The nation with uuid '%s' is not registered.", uuid.toString()));
        }
        return nation;
    }

    @Override
    public TownyWorld getWorld(String name) throws NotRegisteredException {
        TownyWorld world = this.universe.getWorldMap().get(name.toLowerCase());
        if (world == null) {
            throw new NotRegisteredException("World not registered!");
        }
        return world;
    }

    @Override
    public List<TownyWorld> getWorlds() {
        return new ArrayList<TownyWorld>(this.universe.getWorldMap().values());
    }

    @Override
    public Collection<TownBlock> getAllTownBlocks() {
        return TownyUniverse.getInstance().getTownBlocks().values();
    }

    public PlotGroup getPlotObjectGroup(UUID groupID) {
        return this.universe.getGroup(groupID);
    }

    @Override
    public List<PlotGroup> getAllPlotGroups() {
        return new ArrayList<PlotGroup>(this.universe.getGroups());
    }

    @Override
    public List<Jail> getAllJails() {
        return new ArrayList<Jail>(this.universe.getJailUUIDMap().values());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void removeResident(Resident resident) {
        void var3_8;
        for (Town town : TownyUniverse.getInstance().getTowns()) {
            if (!town.hasOutlaw(resident)) continue;
            town.removeOutlaw(resident);
            this.saveTown(town);
        }
        ArrayList<Resident> toSave = new ArrayList<Resident>();
        for (Resident toCheck : this.universe.getResidents()) {
            TownyMessaging.sendDebugMsg("Checking friends of: " + toCheck.getName());
            if (!toCheck.hasFriend(resident)) continue;
            TownyMessaging.sendDebugMsg("       - Removing Friend: " + resident.getName());
            toCheck.removeFriend(resident);
            toSave.add(toCheck);
        }
        for (Resident toCheck : toSave) {
            this.saveResident(toCheck);
        }
        Object var3_6 = null;
        if (resident.hasTown()) {
            try {
                Town town = resident.getTown();
            }
            catch (NotRegisteredException e1) {
                e1.printStackTrace();
            }
        }
        if (var3_8 != null) {
            resident.removeTown();
            if (var3_8.getNumResidents() == 0) {
                TownyUniverse.getInstance().getDataSource().removeTown((Town)var3_8);
            }
        }
        if (resident.hasUUID()) {
            UUID uuid = resident.getUUID();
            long registered = resident.getRegistered();
            this.universe.registerHibernatedResident(uuid, registered);
            this.saveHibernatedResident(uuid);
        }
        this.deleteResident(resident);
        try {
            this.universe.unregisterResident(resident);
        }
        catch (NotRegisteredException e) {
            e.printStackTrace();
        }
        if (TownySettings.isDeleteEcoAccount() && TownyEconomyHandler.isActive()) {
            resident.getAccount().removeAccount();
        }
        this.plugin.deleteCache(resident.getName());
        BukkitTools.getPluginManager().callEvent((Event)new DeletePlayerEvent(resident));
    }

    @Override
    public void removeTownBlock(TownBlock townBlock) {
        PlotBlockData plotData;
        Town town = townBlock.getTownOrNull();
        if (town == null) {
            this.logger.error(String.format("The TownBlock at (%s, %d, %d) is not registered to a town.", townBlock.getWorld().getName(), townBlock.getX(), townBlock.getZ()));
        }
        TownPreUnclaimEvent event = new TownPreUnclaimEvent(town, townBlock);
        BukkitTools.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            this.logger.warn(event.getCancelMessage());
            return;
        }
        if (townBlock.isJail() && townBlock.getJail() != null) {
            this.removeJail(townBlock.getJail());
        }
        TownyUniverse.getInstance().removeTownBlock(townBlock);
        this.deleteTownBlock(townBlock);
        if (townBlock.getWorld().isUsingPlotManagementDelete()) {
            TownyRegenAPI.addDeleteTownBlockIdQueue(townBlock.getWorldCoord());
        }
        if (townBlock.getWorld().isUsingPlotManagementRevert() && (plotData = TownyRegenAPI.getPlotChunkSnapshot(townBlock)) != null && !plotData.getBlockList().isEmpty()) {
            TownyRegenAPI.addPlotChunk(plotData, true);
        }
        BukkitTools.getPluginManager().callEvent((Event)new TownUnclaimEvent(town, townBlock.getWorldCoord()));
    }

    @Override
    public void removeTownBlocks(Town town) {
        for (TownBlock townBlock : new ArrayList<TownBlock>(town.getTownBlocks())) {
            this.removeTownBlock(townBlock);
        }
    }

    @Override
    public void removeTown(Town town) {
        this.removeTown(town, TownySettings.getTownRuinsEnabled() && !town.isRuined());
    }

    @Override
    public void removeTown(Town town, boolean delayFullRemoval) {
        if (delayFullRemoval) {
            TownRuinUtil.putTownIntoRuinedState(town, this.plugin);
            return;
        }
        PreDeleteTownEvent preEvent = new PreDeleteTownEvent(town);
        BukkitTools.getPluginManager().callEvent((Event)preEvent);
        if (preEvent.isCancelled()) {
            return;
        }
        Resident mayor = town.getMayor();
        TownyWorld townyWorld = town.getHomeblockWorld();
        if (town.hasSpawn()) {
            try {
                TownyUniverse.getInstance().removeSpawnPoint(town.getSpawn());
            }
            catch (TownyException townyException) {
                // empty catch block
            }
        }
        this.removeTownBlocks(town);
        ArrayList toSave = new ArrayList(town.getResidents());
        if (town.hasNation()) {
            town.removeNation();
        }
        for (Resident resident2 : toSave) {
            resident2.clearModes();
            resident2.removeTown();
        }
        new ArrayList<Resident>(TownyUniverse.getInstance().getJailedResidentMap()).stream().filter(resident -> resident.hasJailTown(town.getName())).forEach(resident -> JailUtil.unJailResident(resident, UnJailReason.JAIL_DELETED));
        if (TownyEconomyHandler.isActive()) {
            try {
                town.getAccount().payTo(town.getAccount().getHoldingBalance(), new WarSpoils(), "Remove Town");
                town.getAccount().removeAccount();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (townyWorld != null) {
            try {
                townyWorld.removeTown(town);
            }
            catch (NotRegisteredException notRegisteredException) {
                // empty catch block
            }
            this.saveWorld(townyWorld);
        }
        try {
            this.universe.unregisterTown(town);
        }
        catch (NotRegisteredException e) {
            TownyMessaging.sendErrorMsg(e.getMessage());
        }
        this.plugin.resetCache();
        this.deleteTown(town);
        BukkitTools.getPluginManager().callEvent((Event)new DeleteTownEvent(town, mayor.getUUID()));
        TownyMessaging.sendGlobalMessage(Translatable.of("msg_del_town2", town.getName()));
    }

    @Override
    public void removeNation(Nation nation) {
        PreDeleteNationEvent preEvent = new PreDeleteNationEvent(nation);
        BukkitTools.getPluginManager().callEvent((Event)preEvent);
        if (preEvent.isCancelled()) {
            return;
        }
        Resident king = null;
        if (nation.hasKing()) {
            king = nation.getKing();
        }
        if (nation.hasSpawn()) {
            try {
                TownyUniverse.getInstance().removeSpawnPoint(nation.getSpawn());
            }
            catch (TownyException townyException) {
                // empty catch block
            }
        }
        ArrayList<Nation> toSaveNation = new ArrayList<Nation>();
        for (Nation toCheck : new ArrayList<Nation>(this.universe.getNations())) {
            if (!toCheck.hasAlly(nation) && !toCheck.hasEnemy(nation)) continue;
            try {
                if (toCheck.hasAlly(nation)) {
                    toCheck.removeAlly(nation);
                } else {
                    toCheck.removeEnemy(nation);
                }
                toSaveNation.add(toCheck);
            }
            catch (NotRegisteredException e) {
                e.printStackTrace();
            }
        }
        for (Nation toCheck : toSaveNation) {
            this.saveNation(toCheck);
        }
        if (TownyEconomyHandler.isActive()) {
            try {
                nation.getAccount().payTo(nation.getAccount().getHoldingBalance(), new WarSpoils(), "Remove Nation");
                nation.getAccount().removeAccount();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.deleteNation(nation);
        ArrayList<Town> toSave = new ArrayList<Town>(nation.getTowns());
        nation.clear();
        try {
            this.universe.unregisterNation(nation);
        }
        catch (NotRegisteredException e) {
            e.printStackTrace();
        }
        for (Town town : toSave) {
            for (Resident res : town.getResidents()) {
                if (res.hasTitle() || res.hasSurname()) {
                    res.setTitle("");
                    res.setSurname("");
                }
                res.updatePermsForNationRemoval();
                res.save();
            }
            try {
                town.setNation(null);
            }
            catch (AlreadyRegisteredException alreadyRegisteredException) {
                // empty catch block
            }
            town.save();
            BukkitTools.getPluginManager().callEvent((Event)new NationRemoveTownEvent(town, nation));
        }
        this.plugin.resetCache();
        UUID kingUUID = null;
        if (king != null) {
            kingUUID = king.getUUID();
        }
        BukkitTools.getPluginManager().callEvent((Event)new DeleteNationEvent(nation, kingUUID));
    }

    @Override
    public void removeWorld(TownyWorld world) throws UnsupportedOperationException {
        this.deleteWorld(world);
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeJail(Jail jail) {
        new ArrayList<Resident>(TownyUniverse.getInstance().getJailedResidentMap()).stream().filter(resident -> resident.getJail().getUUID().equals(jail.getUUID())).forEach(resident -> JailUtil.unJailResident(resident, UnJailReason.JAIL_DELETED));
        if (jail.hasCells()) {
            jail.removeAllCells();
        }
        if (jail.getTown() != null) {
            jail.getTown().removeJail(jail);
        }
        TownyUniverse.getInstance().unregisterJail(jail);
        this.deleteJail(jail);
    }

    @Override
    public void removePlotGroup(PlotGroup group) {
        TownyUniverse.getInstance().unregisterGroup(group);
        this.deletePlotGroup(group);
    }

    @Override
    public void removeHibernatedResident(UUID uuid) {
        this.universe.unregisterHibernatedResident(uuid);
        this.deleteHibernatedResident(uuid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renameTown(Town town, String newName) throws AlreadyRegisteredException, NotRegisteredException {
        String oldName;
        this.lock.lock();
        try {
            TownyWorld world;
            String filteredName;
            try {
                filteredName = NameValidation.checkAndFilterName(newName);
            }
            catch (InvalidNameException e) {
                throw new NotRegisteredException(e.getMessage());
            }
            if (TownyUniverse.getInstance().hasTown(filteredName)) {
                throw new AlreadyRegisteredException("The town " + filteredName + " is already in use.");
            }
            ArrayList toSave = new ArrayList(town.getResidents());
            boolean isCapital = false;
            Nation nation = null;
            double townBalance = 0.0;
            oldName = town.getName();
            if (TownyEconomyHandler.isActive()) {
                try {
                    townBalance = town.getAccount().getHoldingBalance();
                    if (TownySettings.isEcoClosedEconomyEnabled()) {
                        town.getAccount().deposit(townBalance, "Town Rename");
                    }
                    town.getAccount().removeAccount();
                }
                catch (Exception ignored) {
                    TownyMessaging.sendErrorMsg("The bank balance for the town " + oldName + ", could not be received from the economy plugin and will not be able to be converted.");
                }
            }
            UUID oldUUID = town.getUUID();
            long oldregistration = town.getRegistered();
            if (town.hasNation()) {
                nation = town.getNation();
                isCapital = town.isCapital();
            }
            if ((world = town.getHomeblockWorld()).hasTown(town)) {
                world.removeTown(town);
            }
            this.deleteTown(town);
            this.universe.unregisterTown(town);
            town.setName(filteredName);
            this.universe.registerTown(town);
            world.addTown(town);
            if (isCapital) {
                nation.setCapital(town);
            }
            town.setUUID(oldUUID);
            town.setRegistered(oldregistration);
            if (TownyEconomyHandler.isActive()) {
                town.getAccount().setName(TownySettings.getTownAccountPrefix() + town.getName());
                town.getAccount().setBalance(townBalance, "Rename Town - Transfer to new account");
            }
            for (Resident resident : toSave) {
                this.saveResident(resident);
            }
            for (TownBlock townBlock : town.getTownBlocks()) {
                this.saveTownBlock(townBlock);
            }
            if (town.hasPlotGroups()) {
                for (PlotGroup pg : town.getPlotGroups()) {
                    pg.setTown(town);
                    this.savePlotGroup(pg);
                }
            }
            this.saveTown(town);
            this.saveWorld(town.getHomeblockWorld());
            if (nation != null) {
                this.saveNation(nation);
            }
        }
        finally {
            this.lock.unlock();
        }
        BukkitTools.getPluginManager().callEvent((Event)new RenameTownEvent(oldName, town));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renameNation(Nation nation, String newName) throws AlreadyRegisteredException, NotRegisteredException {
        String oldName;
        this.lock.lock();
        try {
            String filteredName;
            try {
                filteredName = NameValidation.checkAndFilterName(newName);
            }
            catch (InvalidNameException e) {
                throw new NotRegisteredException(e.getMessage());
            }
            if (this.universe.hasNation(filteredName)) {
                throw new AlreadyRegisteredException("The nation " + filteredName + " is already in use.");
            }
            ArrayList<Town> toSave = new ArrayList<Town>(nation.getTowns());
            double nationBalance = 0.0;
            if (TownyEconomyHandler.isActive()) {
                try {
                    nationBalance = nation.getAccount().getHoldingBalance();
                    if (TownySettings.isEcoClosedEconomyEnabled()) {
                        nation.getAccount().withdraw(nationBalance, "Nation Rename");
                    }
                    nation.getAccount().removeAccount();
                }
                catch (Exception ignored) {
                    TownyMessaging.sendErrorMsg("The bank balance for the nation " + nation.getName() + ", could not be received from the economy plugin and will not be able to be converted.");
                }
            }
            this.deleteNation(nation);
            oldName = nation.getName();
            this.universe.unregisterNation(nation);
            nation.setName(filteredName);
            this.universe.registerNation(nation);
            if (TownyEconomyHandler.isActive()) {
                nation.getAccount().setName(TownySettings.getNationAccountPrefix() + nation.getName());
                nation.getAccount().setBalance(nationBalance, "Rename Nation - Transfer to new account");
            }
            for (Town town : toSave) {
                this.saveTown(town);
            }
            this.saveNation(nation);
            Nation oldNation = new Nation(oldName);
            ArrayList<Nation> toSaveNation = new ArrayList<Nation>(this.universe.getNations());
            for (Nation toCheck : toSaveNation) {
                if (toCheck.hasAlly(oldNation) || toCheck.hasEnemy(oldNation)) {
                    try {
                        if (toCheck.hasAlly(oldNation)) {
                            toCheck.removeAlly(oldNation);
                            toCheck.addAlly(nation);
                            continue;
                        }
                        toCheck.removeEnemy(oldNation);
                        toCheck.addEnemy(nation);
                    }
                    catch (NotRegisteredException e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                toSave.remove(toCheck);
            }
            for (Nation toCheck : toSaveNation) {
                this.saveNation(toCheck);
            }
        }
        finally {
            this.lock.unlock();
        }
        BukkitTools.getPluginManager().callEvent((Event)new RenameNationEvent(oldName, nation));
    }

    @Override
    public void renameGroup(PlotGroup group, String newName) throws AlreadyRegisteredException {
        group.setName(newName);
        this.savePlotGroup(group);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renamePlayer(Resident resident, String newName) throws AlreadyRegisteredException, NotRegisteredException {
        this.lock.lock();
        String oldName = resident.getName();
        try {
            double balance = 0.0;
            if (TownyEconomyHandler.isActive() && TownyEconomyHandler.getVersion().startsWith("iConomy 5")) {
                balance = resident.getAccount().getHoldingBalance();
                resident.getAccount().removeAccount();
            }
            if (TownyEconomyHandler.isActive()) {
                resident.getAccount().setName(newName);
            }
            this.universe.unregisterResident(resident);
            resident.setName(newName);
            this.universe.registerResident(resident);
            if (TownyEconomyHandler.isActive() && TownyEconomyHandler.getVersion().startsWith("iConomy 5")) {
                resident.getAccount().setName(resident.getName());
                resident.getAccount().setBalance(balance, "Rename Player - Transfer to new account");
            }
            this.saveResident(resident);
            for (TownBlock tb : resident.getTownBlocks()) {
                this.saveTownBlock(tb);
            }
            if (resident.isMayor()) {
                this.saveTown(resident.getTown());
            }
            Resident oldResident = new Resident(oldName);
            ArrayList<Resident> toSaveResident = new ArrayList<Resident>(this.universe.getResidents());
            for (Resident toCheck : toSaveResident) {
                if (!toCheck.hasFriend(oldResident)) continue;
                toCheck.removeFriend(oldResident);
                toCheck.addFriend(resident);
            }
            for (Resident toCheck : toSaveResident) {
                this.saveResident(toCheck);
            }
            ArrayList<Town> toSaveTown = new ArrayList<Town>(TownyUniverse.getInstance().getTowns());
            for (Town toCheckTown : toSaveTown) {
                if (!toCheckTown.hasOutlaw(oldResident)) continue;
                toCheckTown.removeOutlaw(oldResident);
                toCheckTown.addOutlaw(resident);
            }
            for (Town toCheckTown : toSaveTown) {
                this.saveTown(toCheckTown);
            }
            this.deleteResident(oldResident);
        }
        finally {
            this.lock.unlock();
        }
        BukkitTools.getPluginManager().callEvent((Event)new RenameResidentEvent(oldName, resident));
    }

    @Override
    public boolean savePlotData(PlotBlockData plotChunk) {
        String path = this.getPlotFilename(plotChunk);
        this.queryQueue.add(() -> {
            File file = new File(this.dataFolderPath + File.separator + "plot-block-data" + File.separator + plotChunk.getWorldName());
            FileMgmt.savePlotData(plotChunk, file, path);
        });
        return true;
    }

    @Override
    public PlotBlockData loadPlotData(String worldName, int x, int z) {
        try {
            TownyWorld world = this.getWorld(worldName);
            TownBlock townBlock = new TownBlock(x, z, world);
            return this.loadPlotData(townBlock);
        }
        catch (NotRegisteredException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public PlotBlockData loadPlotData(TownBlock townBlock) {
        PlotBlockData plotBlockData = null;
        try {
            plotBlockData = new PlotBlockData(townBlock);
        }
        catch (NullPointerException e1) {
            TownyMessaging.sendErrorMsg("Unable to load plotblockdata for townblock: " + townBlock.getWorldCoord().toString() + ". Skipping regeneration for this townBlock.");
            return null;
        }
        String fileName = this.getPlotFilename(townBlock);
        if (this.isFile(fileName)) {
            PlotBlockData plotBlockData2;
            ZipFile zipFile = new ZipFile(fileName);
            try {
                InputStream stream = zipFile.getInputStream(zipFile.entries().nextElement());
                plotBlockData2 = this.loadDataStream(plotBlockData, stream);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        zipFile.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return null;
                }
            }
            zipFile.close();
            return plotBlockData2;
        }
        if (this.isFile(this.getLegacyPlotFilename(townBlock))) {
            try {
                return this.loadDataStream(plotBlockData, new FileInputStream(this.getLegacyPlotFilename(townBlock)));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                return null;
            }
        }
        return null;
    }

    private PlotBlockData loadDataStream(PlotBlockData plotBlockData, InputStream stream) {
        int version = 0;
        ArrayList<String> blockArr = new ArrayList<String>();
        try (DataInputStream fin2 = new DataInputStream(stream);){
            fin2.mark(3);
            byte[] key = new byte[3];
            fin2.read(key, 0, 3);
            String test = new String(key);
            if (TownyFlatFileSource.elements.fromString(test) == TownyFlatFileSource.elements.VER) {
                version = fin2.read();
                plotBlockData.setVersion(version);
                plotBlockData.setHeight(fin2.readInt());
            } else {
                plotBlockData.setVersion(version);
                fin2.reset();
                plotBlockData.setHeight(fin2.readInt());
                blockArr.add(fin2.readUTF());
                blockArr.add(fin2.readUTF());
            }
            switch (version) {
                default: {
                    String value;
                    while ((value = fin2.readUTF()) != null) {
                        blockArr.add(value);
                    }
                    break;
                }
                case 2: {
                    int temp = 0;
                    while ((temp = fin2.readInt()) >= 0) {
                        blockArr.add(temp + "");
                    }
                    break;
                }
            }
        }
        catch (EOFException fin2) {
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        plotBlockData.setBlockList(blockArr);
        plotBlockData.resetBlockListRestored();
        return plotBlockData;
    }

    @Override
    public void deletePlotData(PlotBlockData plotChunk) {
        File file = new File(this.getPlotFilename(plotChunk));
        this.queryQueue.add(new DeleteFileTask(file, true));
    }

    private String getPlotFilename(PlotBlockData plotChunk) {
        return this.dataFolderPath + File.separator + "plot-block-data" + File.separator + plotChunk.getWorldName() + File.separator + plotChunk.getX() + "_" + plotChunk.getZ() + "_" + plotChunk.getSize() + ".zip";
    }

    private String getPlotFilename(TownBlock townBlock) {
        return this.dataFolderPath + File.separator + "plot-block-data" + File.separator + townBlock.getWorld().getName() + File.separator + townBlock.getX() + "_" + townBlock.getZ() + "_" + TownySettings.getTownBlockSize() + ".zip";
    }

    public String getLegacyPlotFilename(TownBlock townBlock) {
        return this.dataFolderPath + File.separator + "plot-block-data" + File.separator + townBlock.getWorld().getName() + File.separator + townBlock.getX() + "_" + townBlock.getZ() + "_" + TownySettings.getTownBlockSize() + ".data";
    }

    private boolean isFile(String fileName) {
        File file = new File(fileName);
        return file.exists() && file.isFile();
    }

    @Override
    public boolean loadRegenList() {
        boolean bl;
        TownyMessaging.sendDebugMsg("Loading Regen List");
        String line = null;
        BufferedReader fin = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.dataFolderPath + File.separator + "regen.txt"), StandardCharsets.UTF_8));
        try {
            while ((line = fin.readLine()) != null) {
                String[] split;
                PlotBlockData plotData;
                if (line.equals("") || (plotData = this.loadPlotData((split = line.split(","))[0], Integer.parseInt(split[1]), Integer.parseInt(split[2]))) == null) continue;
                TownyRegenAPI.addPlotChunk(plotData, false);
            }
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    fin.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                TownyMessaging.sendErrorMsg("Error Loading Regen List at " + line + ", in towny\\data\\regen.txt");
                e.printStackTrace();
                return false;
            }
        }
        fin.close();
        return bl;
    }

    @Override
    public boolean loadSnapshotList() {
        boolean bl;
        TownyMessaging.sendDebugMsg("Loading Snapshot Queue");
        String line = null;
        BufferedReader fin = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.dataFolderPath + File.separator + "snapshot_queue.txt"), StandardCharsets.UTF_8));
        try {
            while ((line = fin.readLine()) != null) {
                if (line.equals("")) continue;
                String[] split = line.split(",");
                WorldCoord worldCoord = new WorldCoord(split[0], Integer.parseInt(split[1]), Integer.parseInt(split[2]));
                TownyRegenAPI.addWorldCoord(worldCoord);
            }
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    fin.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                TownyMessaging.sendErrorMsg("Error Loading Snapshot Queue List at " + line + ", in towny\\data\\snapshot_queue.txt");
                e.printStackTrace();
                return false;
            }
        }
        fin.close();
        return bl;
    }

    protected final String serializeMetadata(TownyObject obj) {
        return DataFieldIO.serializeCDFs(obj.getMetadata());
    }

    @Override
    public boolean saveRegenList() {
        this.queryQueue.add(() -> {
            File file = new File(this.dataFolderPath + File.separator + "regen.txt");
            Collection lines = TownyRegenAPI.getPlotChunks().values().stream().map(data -> data.getWorldName() + "," + data.getX() + "," + data.getZ()).collect(Collectors.toList());
            FileMgmt.listToFile(lines, file.getPath());
        });
        return true;
    }

    @Override
    public boolean saveSnapshotList() {
        this.queryQueue.add(() -> {
            ArrayList<String> coords = new ArrayList<String>();
            while (TownyRegenAPI.hasWorldCoords()) {
                WorldCoord worldCoord = TownyRegenAPI.getWorldCoord();
                coords.add(worldCoord.getWorldName() + "," + worldCoord.getX() + "," + worldCoord.getZ());
            }
            FileMgmt.listToFile(coords, this.dataFolderPath + File.separator + "snapshot_queue.txt");
        });
        return true;
    }

    @Override
    public void deleteFile(String fileName) {
        File file = new File(fileName);
        this.queryQueue.add(new DeleteFileTask(file, true));
    }

    public static void validateTownOutposts(Town town) {
        ArrayList<Location> validoutpostspawns = new ArrayList<Location>();
        if (town != null && town.hasOutpostSpawn()) {
            for (Location outpostSpawn : town.getAllOutpostSpawns()) {
                TownBlock outpostSpawnTB = TownyAPI.getInstance().getTownBlock(outpostSpawn);
                if (outpostSpawnTB == null) continue;
                validoutpostspawns.add(outpostSpawn);
            }
            town.setOutpostSpawns(validoutpostspawns);
        }
    }

    @Override
    public void mergeNation(Nation succumbingNation, Nation prevailingNation) {
        if (TownyEconomyHandler.isActive()) {
            succumbingNation.getAccount().payTo(succumbingNation.getAccount().getHoldingBalance(), prevailingNation, "Nation merge bank accounts.");
        }
        this.lock.lock();
        ArrayList<Town> towns = new ArrayList<Town>(succumbingNation.getTowns());
        for (Town town : towns) {
            town.removeNation();
            try {
                town.setNation(prevailingNation);
            }
            catch (AlreadyRegisteredException alreadyRegisteredException) {
                // empty catch block
            }
            this.saveTown(town);
        }
        this.lock.unlock();
    }

    @Override
    public void mergeTown(Town mergeInto, Town mergeFrom) {
        if (TownyEconomyHandler.isActive() && mergeFrom.getAccount().getHoldingBalance() > 0.0) {
            mergeFrom.getAccount().payTo(mergeFrom.getAccount().getHoldingBalance(), mergeInto, Translation.of("msg_town_merge_transaction_reason"));
        }
        this.lock.lock();
        boolean isSameNation = false;
        if (mergeInto.hasNation() && mergeFrom.hasNation()) {
            try {
                isSameNation = mergeInto.getNation().hasTown(mergeFrom);
            }
            catch (NotRegisteredException notRegisteredException) {
                // empty catch block
            }
        }
        String mayorName = mergeFrom.getMayor().getName();
        List jails = TownyUniverse.getInstance().getJailUUIDMap().values().stream().filter(jail -> jail.getTown().equals(mergeFrom)).collect(Collectors.toList());
        ArrayList<Location> outposts = new ArrayList<Location>(mergeFrom.getAllOutpostSpawns());
        mergeInto.addPurchasedBlocks(mergeFrom.getPurchasedBlocks());
        mergeInto.addBonusBlocks(mergeFrom.getBonusBlocks());
        for (TownBlock tb : mergeFrom.getTownBlocks()) {
            tb.setTown(mergeInto);
            tb.save();
        }
        ArrayList residents = new ArrayList(mergeFrom.getResidents());
        for (Resident resident : residents) {
            try {
                if (mergeInto.hasOutlaw(resident)) {
                    resident.removeTown();
                    continue;
                }
                ArrayList<String> nationRanks = new ArrayList<String>(resident.getNationRanks());
                resident.removeTown();
                resident.setTown(mergeInto);
                if (isSameNation) {
                    for (String rank : nationRanks) {
                        resident.addNationRank(rank);
                    }
                }
                resident.save();
            }
            catch (TownyException nationRanks) {}
        }
        for (Resident outlaw : mergeFrom.getOutlaws()) {
            if (mergeInto.hasOutlaw(outlaw) || mergeInto.hasResident(outlaw)) continue;
            try {
                mergeInto.addOutlaw(outlaw);
            }
            catch (AlreadyRegisteredException nationRanks) {}
        }
        for (Jail jail2 : jails) {
            TownBlock jailPlot = jail2.getTownBlock();
            if (jailPlot.getType() != TownBlockType.JAIL) {
                jailPlot.setType(TownBlockType.JAIL);
            }
            jail2.setTown(mergeInto);
        }
        for (Location outpost : outposts) {
            mergeInto.addOutpostSpawn(outpost);
        }
        this.lock.unlock();
        this.removeTown(mergeFrom, false);
        mergeInto.save();
        TownyMessaging.sendGlobalMessage(Translatable.of("msg_town_merge_success", mergeFrom.getName(), mayorName, mergeInto.getName()));
    }

    public List<UUID> toUUIDList(Collection<Resident> residents) {
        return residents.stream().filter(Resident::hasUUID).map(Resident::getUUID).collect(Collectors.toList());
    }

    public UUID[] toUUIDArray(String[] uuidArray) {
        UUID[] uuids = new UUID[uuidArray.length];
        for (int i = 0; i < uuidArray.length; ++i) {
            try {
                uuids[i] = UUID.fromString(uuidArray[i]);
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return uuids;
    }

    public String generateReplacementName(boolean town) {
        Random r = new Random();
        String replacementName = "replacementname" + r.nextInt(99) + 1;
        try {
            replacementName = this.getNextName(town);
        }
        catch (TownyException e) {
            e.printStackTrace();
        }
        return replacementName;
    }

    private String getNextName(boolean town) throws TownyException {
        String name = town ? "Town" : "Nation";
        int i = 0;
        do {
            name = name + ++i;
            if (!town) continue;
            if (!TownyUniverse.getInstance().hasTown(name)) {
                return name;
            }
            if (TownyUniverse.getInstance().hasNation(name)) continue;
            return name;
        } while (i <= 100000);
        throw new TownyException("Too many replacement names.");
    }
}

