/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.command;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.TownyAsciiMap;
import com.palmergames.bukkit.towny.TownyCommandAddonAPI;
import com.palmergames.bukkit.towny.TownyEconomyHandler;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyTimerHandler;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.TownyUpdateChecker;
import com.palmergames.bukkit.towny.command.BaseCommand;
import com.palmergames.bukkit.towny.command.HelpMenu;
import com.palmergames.bukkit.towny.db.TownyDataSource;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.huds.HUDManager;
import com.palmergames.bukkit.towny.object.Government;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.ResidentList;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlockOwner;
import com.palmergames.bukkit.towny.object.TownyObject;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.object.Translatable;
import com.palmergames.bukkit.towny.object.Translation;
import com.palmergames.bukkit.towny.object.Translator;
import com.palmergames.bukkit.towny.object.comparators.GovernmentComparators;
import com.palmergames.bukkit.towny.permissions.PermissionNodes;
import com.palmergames.bukkit.towny.permissions.TownyPermissionSource;
import com.palmergames.bukkit.towny.utils.NameUtil;
import com.palmergames.bukkit.towny.utils.ResidentUtil;
import com.palmergames.bukkit.towny.war.eventwar.War;
import com.palmergames.bukkit.util.ChatTools;
import com.palmergames.bukkit.util.Colors;
import com.palmergames.util.KeyValue;
import com.palmergames.util.KeyValueTable;
import com.palmergames.util.StringMgmt;
import com.palmergames.util.TimeMgmt;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class TownyCommand
extends BaseCommand
implements CommandExecutor {
    private static Towny plugin;
    private static List<String> towny_top;
    private static List<String> towny_war;
    private static String towny_version;
    private static final List<String> townyTabCompletes;
    private static final List<String> townyConsoleTabCompletes;
    private static final List<String> townyWarTabCompletes;
    private static final List<String> townyTopTabCompletes;
    private static final List<String> townyTopTownNationCompletes;
    private static final List<String> townyTopLandTabCompletes;

    public TownyCommand(Towny instance) {
        plugin = instance;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String commandLabel, String[] args) {
        towny_version = "\u00a72Towny version: \u00a7a" + plugin.getVersion();
        towny_war.add(ChatTools.formatTitle("/towny war"));
        towny_war.add(ChatTools.formatCommand("", "/towny war", "stats", ""));
        towny_war.add(ChatTools.formatCommand("", "/towny war", "scores", ""));
        towny_war.add(ChatTools.formatCommand("", "/towny war", "participants [page #]", ""));
        towny_war.add(ChatTools.formatCommand("", "/towny war", "hud", ""));
        if (sender instanceof Player) {
            if (plugin.isError()) {
                TownyMessaging.sendMessage((Object)sender, "\u00a7c[Towny Error] Locked in Safe mode!");
                return false;
            }
            Player player = (Player)sender;
            this.parseTownyCommand(player, args);
        } else if (args.length == 0) {
            HelpMenu.GENERAL_HELP.send(sender);
        } else if (args[0].equalsIgnoreCase("tree")) {
            for (String line : TownyUniverse.getInstance().getTreeString(0)) {
                TownyMessaging.sendMessage((Object)sender, line);
            }
        } else if (args[0].equalsIgnoreCase("time")) {
            TownyMessaging.sendMsg(Translation.of("msg_time_until_a_new_day") + TimeMgmt.formatCountdownTime(TownyTimerHandler.townyTime()));
        } else if (args[0].equalsIgnoreCase("version") || args[0].equalsIgnoreCase("v")) {
            if (TownyUpdateChecker.shouldShowNotification()) {
                TownyMessaging.sendMessage((Object)sender, Colors.strip(Translation.of("msg_latest_version", plugin.getVersion(), TownyUpdateChecker.getNewVersion())));
            } else {
                TownyMessaging.sendMsg(sender, towny_version);
                if (TownyUpdateChecker.hasCheckedSuccessfully()) {
                    TownyMessaging.sendMsg(sender, Translation.of("msg_up_to_date"));
                }
            }
        } else if (args[0].equalsIgnoreCase("war")) {
            boolean war = this.TownyWar(StringMgmt.remFirstArg(args), null);
            if (war) {
                for (String line : towny_war) {
                    TownyMessaging.sendMessage((Object)sender, Colors.strip(line));
                }
            } else {
                TownyMessaging.sendMessage((Object)sender, "The world isn't currently at war.");
            }
        } else if (args[0].equalsIgnoreCase("universe")) {
            for (String line : this.getUniverseStats(Translation.getDefaultLocale())) {
                TownyMessaging.sendMessage((Object)sender, Colors.strip(line));
            }
        }
        towny_war.clear();
        return true;
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        switch (args[0].toLowerCase()) {
            case "top": {
                switch (args.length) {
                    case 2: {
                        return NameUtil.filterByStart(townyTopTabCompletes, args[1]);
                    }
                    case 3: {
                        switch (args[1].toLowerCase()) {
                            case "residents": 
                            case "balance": {
                                return NameUtil.filterByStart(townyTopTownNationCompletes, args[2]);
                            }
                            case "land": {
                                return NameUtil.filterByStart(townyTopLandTabCompletes, args[2]);
                            }
                        }
                    }
                }
                break;
            }
            case "war": {
                if (args.length != 2) break;
                return NameUtil.filterByStart(townyWarTabCompletes, args[1]);
            }
            case "map": {
                if (args.length != 2) break;
                return NameUtil.filterByStart(Arrays.asList("big", "hud"), args[1]);
            }
            default: {
                if (args.length == 1) {
                    if (sender instanceof Player) {
                        return NameUtil.filterByStart(TownyCommandAddonAPI.getTabCompletes(TownyCommandAddonAPI.CommandType.TOWNY, townyTabCompletes), args[0]);
                    }
                    return NameUtil.filterByStart(TownyCommandAddonAPI.getTabCompletes(TownyCommandAddonAPI.CommandType.TOWNY, townyConsoleTabCompletes), args[0]);
                }
                if (args.length <= 1 || !TownyCommandAddonAPI.hasCommand(TownyCommandAddonAPI.CommandType.TOWNY, args[0])) break;
                return NameUtil.filterByStart(TownyCommandAddonAPI.getAddonCommand(TownyCommandAddonAPI.CommandType.TOWNY, args[0]).getTabCompletion(args.length), args[args.length - 1]);
            }
        }
        return Collections.emptyList();
    }

    private void parseTownyCommand(Player player, String[] split) {
        TownyPermissionSource permSource = TownyUniverse.getInstance().getPermissionSource();
        if (split.length == 0) {
            HelpMenu.GENERAL_HELP.send((CommandSender)player);
            return;
        }
        if (split[0].equalsIgnoreCase("?") || split[0].equalsIgnoreCase("help")) {
            HelpMenu.HELP.send((CommandSender)player);
            return;
        }
        try {
            TownyWorld world = TownyAPI.getInstance().getTownyWorld(player.getWorld().getName());
            if (world == null && split[0].equalsIgnoreCase("wildsblocks") || split[0].equalsIgnoreCase("plotclearblocks")) {
                throw new TownyException(Translatable.of("msg_err_usingtowny_disabled"));
            }
            if (split[0].equalsIgnoreCase("map")) {
                if (!permSource.testPermission(player, PermissionNodes.TOWNY_COMMAND_TOWNY_MAP.getNode(split[0].toLowerCase()))) {
                    throw new TownyException(Translatable.of("msg_err_command_disable"));
                }
                if (split.length > 1 && split[1].equalsIgnoreCase("big")) {
                    TownyAsciiMap.generateAndSend(plugin, player, 18);
                } else if (split.length > 1 && split[1].equalsIgnoreCase("hud")) {
                    HUDManager.toggleMapHud(player);
                } else {
                    TownyCommand.showMap(player);
                }
            } else if (split[0].equalsIgnoreCase("prices")) {
                Town town = null;
                if (!TownyEconomyHandler.isActive()) {
                    throw new TownyException(Translatable.of("msg_err_no_economy"));
                }
                if (split.length > 1) {
                    town = TownyUniverse.getInstance().getTown(split[1]);
                    if (town == null) {
                        TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_not_registered_1", split[1]));
                        return;
                    }
                } else {
                    Optional<Resident> resOpt = TownyUniverse.getInstance().getResidentOpt(player.getUniqueId());
                    if (resOpt.isPresent() && resOpt.get().hasTown()) {
                        town = resOpt.get().getTownOrNull();
                    }
                }
                for (String line : this.getTownyPrices(town, Translation.getLocale((CommandSender)player))) {
                    TownyMessaging.sendMessage((Object)player, line);
                }
            } else if (split[0].equalsIgnoreCase("switches")) {
                Resident resident = TownyCommand.getResidentOrThrow(player.getUniqueId());
                ResidentUtil.openGUIInventory(resident, TownySettings.getSwitchMaterials(), Translatable.of("gui_title_towny_switch").forLocale((CommandSender)player));
            } else if (split[0].equalsIgnoreCase("itemuse")) {
                Resident resident = TownyCommand.getResidentOrThrow(player.getUniqueId());
                ResidentUtil.openGUIInventory(resident, TownySettings.getItemUseMaterials(), Translatable.of("gui_title_towny_itemuse").forLocale((CommandSender)player));
            } else if (split[0].equalsIgnoreCase("farmblocks")) {
                Resident resident = TownyCommand.getResidentOrThrow(player.getUniqueId());
                ResidentUtil.openGUIInventory(resident, TownySettings.getFarmPlotBlocks(), Translatable.of("gui_title_towny_farmblocks").forLocale((CommandSender)player));
            } else if (split[0].equalsIgnoreCase("wildsblocks")) {
                Resident resident = TownyCommand.getResidentOrThrow(player.getUniqueId());
                ResidentUtil.openGUIInventory(resident, world.getUnclaimedZoneIgnoreMaterials(), Translatable.of("gui_title_towny_wildsblocks").forLocale((CommandSender)player));
            } else if (split[0].equalsIgnoreCase("plotclearblocks")) {
                Resident resident = TownyCommand.getResidentOrThrow(player.getUniqueId());
                ResidentUtil.openGUIInventory(resident, world.getPlotManagementMayorDelete(), Translatable.of("gui_title_towny_plotclear").forLocale((CommandSender)player));
            } else if (split[0].equalsIgnoreCase("top")) {
                if (!permSource.testPermission(player, PermissionNodes.TOWNY_COMMAND_TOWNY_TOP.getNode(split[0].toLowerCase()))) {
                    throw new TownyException(Translatable.of("msg_err_command_disable"));
                }
                this.TopCommand(player, StringMgmt.remFirstArg(split));
            } else if (split[0].equalsIgnoreCase("tree")) {
                if (!permSource.testPermission(player, PermissionNodes.TOWNY_COMMAND_TOWNY_TREE.getNode(split[0].toLowerCase()))) {
                    throw new TownyException(Translatable.of("msg_err_command_disable"));
                }
                this.consoleUseOnly(player);
            } else if (split[0].equalsIgnoreCase("time")) {
                if (!permSource.testPermission(player, PermissionNodes.TOWNY_COMMAND_TOWNY_TIME.getNode(split[0].toLowerCase()))) {
                    throw new TownyException(Translatable.of("msg_err_command_disable"));
                }
                TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_time_until_a_new_day") + TimeMgmt.formatCountdownTime(TownyTimerHandler.townyTime()));
            } else if (split[0].equalsIgnoreCase("universe")) {
                if (!permSource.testPermission(player, PermissionNodes.TOWNY_COMMAND_TOWNY_UNIVERSE.getNode(split[0].toLowerCase()))) {
                    throw new TownyException(Translatable.of("msg_err_command_disable"));
                }
                for (String line : this.getUniverseStats(Translation.getLocale((CommandSender)player))) {
                    TownyMessaging.sendMessage((Object)player, line);
                }
            } else if (split[0].equalsIgnoreCase("version") || split[0].equalsIgnoreCase("v")) {
                if (!permSource.testPermission(player, PermissionNodes.TOWNY_COMMAND_TOWNY_VERSION.getNode(split[0].toLowerCase()))) {
                    throw new TownyException(Translatable.of("msg_err_command_disable"));
                }
                if (TownyUpdateChecker.shouldShowNotification()) {
                    TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_latest_version", plugin.getVersion(), TownyUpdateChecker.getNewVersion()).stripColors(true));
                } else {
                    TownyMessaging.sendMsg((CommandSender)player, towny_version);
                    if (TownyUpdateChecker.hasCheckedSuccessfully()) {
                        TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_up_to_date"));
                    }
                }
            } else if (split[0].equalsIgnoreCase("war")) {
                if (!permSource.testPermission(player, PermissionNodes.TOWNY_COMMAND_TOWNY_WAR.getNode(split[0].toLowerCase()))) {
                    throw new TownyException(Translatable.of("msg_err_command_disable"));
                }
                boolean war = this.TownyWar(StringMgmt.remFirstArg(split), player);
                if (war) {
                    for (String line : towny_war) {
                        TownyMessaging.sendMessage((Object)player, Colors.strip(line));
                    }
                } else {
                    TownyMessaging.sendErrorMsg((Object)player, "The world isn't currently at war.");
                }
                towny_war.clear();
            } else if (split[0].equalsIgnoreCase("spy")) {
                if (permSource.testPermission(player, PermissionNodes.TOWNY_CHAT_SPY.getNode())) {
                    Resident resident = TownyCommand.getResidentOrThrow(player.getUniqueId());
                    resident.toggleMode(split, true);
                } else {
                    TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_command_disable"));
                }
            } else if (TownyCommandAddonAPI.hasCommand(TownyCommandAddonAPI.CommandType.TOWNY, split[0])) {
                TownyCommandAddonAPI.getAddonCommand(TownyCommandAddonAPI.CommandType.TOWNY, split[0]).execute((CommandSender)player, "towny", split);
            } else {
                TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_invalid_sub"));
            }
        }
        catch (TownyException e) {
            TownyMessaging.sendErrorMsg((Object)player, e.getMessage((CommandSender)player));
        }
    }

    private boolean TownyWar(String[] args, Player p) {
        TownyUniverse townyUniverse = TownyUniverse.getInstance();
        if (TownyAPI.getInstance().isWarTime() && args.length > 0) {
            towny_war.clear();
            if (args[0].equalsIgnoreCase("stats")) {
                towny_war.addAll(townyUniverse.getWarEvent().getStats());
            } else if (args[0].equalsIgnoreCase("scores")) {
                towny_war.addAll(townyUniverse.getWarEvent().getScores(-1));
            } else {
                if (args[0].equalsIgnoreCase("participants")) {
                    this.parseWarParticipants(p, args);
                    return true;
                }
                if (args[0].equalsIgnoreCase("hud") && p == null) {
                    towny_war.add("No hud for console!");
                } else if (args[0].equalsIgnoreCase("hud") && p != null) {
                    if (townyUniverse.getPermissionSource().testPermission(p, PermissionNodes.TOWNY_COMMAND_TOWNY_WAR_HUD.getNode())) {
                        HUDManager.toggleWarHUD(p);
                    } else {
                        TownyMessaging.sendErrorMsg((CommandSender)p, Translatable.of("msg_err_command_disable"));
                    }
                }
            }
        }
        return TownyAPI.getInstance().isWarTime();
    }

    private void parseWarParticipants(Player player, String[] split) {
        Resident resident = TownyAPI.getInstance().getResident(player.getUniqueId());
        if (resident == null) {
            return;
        }
        List<Town> townsToSort = War.warringTowns;
        List<Nation> nationsToSort = War.warringNations;
        int page = 1;
        ArrayList<String> output = new ArrayList<String>();
        for (Nation nations : nationsToSort) {
            String nationLine = "\u00a76-" + nations.getName();
            if (resident.hasNation()) {
                if (resident.getTownOrNull().getNationOrNull().hasEnemy(nations)) {
                    nationLine = nationLine + "\u00a74 (Enemy)";
                } else if (resident.getTownOrNull().getNationOrNull().hasAlly(nations)) {
                    nationLine = nationLine + "\u00a72 (Ally)";
                }
            }
            output.add(nationLine);
            for (Town towns : townsToSort) {
                if (!towns.hasNation() || !towns.getNationOrNull().equals(nations)) continue;
                String townLine = "\u00a73  -" + towns.getName();
                if (towns.isCapital()) {
                    townLine = townLine + "\u00a7b (Capital)";
                }
                output.add(townLine);
            }
        }
        int total = (int)Math.ceil((double)output.size() / 10.0);
        if (split.length > 1) {
            try {
                page = Integer.parseInt(split[1]);
                if (page < 0) {
                    TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_negative"));
                    return;
                }
                if (page == 0) {
                    TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_error_must_be_int"));
                    return;
                }
            }
            catch (NumberFormatException e) {
                TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_error_must_be_int"));
                return;
            }
        }
        if (page > total) {
            TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("LIST_ERR_NOT_ENOUGH_PAGES", total));
            return;
        }
        int iMax = page * 10;
        if (page * 10 > output.size()) {
            iMax = output.size();
        }
        ArrayList<String> warparticipantsformatted = new ArrayList<String>();
        for (int i = (page - 1) * 10; i < iMax; ++i) {
            String line = (String)output.get(i);
            warparticipantsformatted.add(line);
        }
        TownyMessaging.sendMessage((Object)player, ChatTools.formatList("War Participants", "\u00a76Nation Name\u00a78 - \u00a73Town Names", warparticipantsformatted, Translatable.of("LIST_PAGE", page, total).forLocale((CommandSender)player)));
        output.clear();
    }

    private void TopCommand(Player player, String[] args) {
        ArrayList<TownyObject> list;
        TownyUniverse universe = TownyUniverse.getInstance();
        if (args.length == 0 || args[0].equalsIgnoreCase("?")) {
            towny_top.add(ChatTools.formatTitle("/towny top"));
            towny_top.add(ChatTools.formatCommand("", "/towny top", "residents [all/town/nation]", ""));
            towny_top.add(ChatTools.formatCommand("", "/towny top", "land [all/resident/town]", ""));
            towny_top.add(ChatTools.formatCommand("", "/towny top", "balance [all/town/nation]", ""));
        } else if (args[0].equalsIgnoreCase("residents")) {
            if (args.length == 1 || args[1].equalsIgnoreCase("all")) {
                list = new ArrayList<Town>(universe.getDataSource().getTowns());
                list.addAll(universe.getNations());
                towny_top.add(ChatTools.formatTitle("Most Residents"));
                towny_top.addAll(this.getMostResidents(list));
            } else if (args[1].equalsIgnoreCase("town")) {
                towny_top.add(ChatTools.formatTitle("Most Residents in a Town"));
                towny_top.addAll(this.getMostResidents(new ArrayList<ResidentList>(universe.getDataSource().getTowns())));
            } else if (args[1].equalsIgnoreCase("nation")) {
                towny_top.add(ChatTools.formatTitle("Most Residents in a Nation"));
                towny_top.addAll(this.getMostResidents(new ArrayList<ResidentList>(universe.getNations())));
            } else {
                TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_invalid_sub"));
            }
        } else if (args[0].equalsIgnoreCase("land")) {
            if (args.length == 1 || args[1].equalsIgnoreCase("all")) {
                list = new ArrayList<Resident>(universe.getResidents());
                list.addAll(universe.getDataSource().getTowns());
                towny_top.add(ChatTools.formatTitle("Most Land Owned"));
                towny_top.addAll(this.getMostLand(list));
            } else if (args[1].equalsIgnoreCase("resident")) {
                towny_top.add(ChatTools.formatTitle("Most Land Owned by Resident"));
                towny_top.addAll(this.getMostLand(new ArrayList<TownBlockOwner>(universe.getResidents())));
            } else if (args[1].equalsIgnoreCase("town")) {
                towny_top.add(ChatTools.formatTitle("Most Land Owned by Town"));
                towny_top.addAll(this.getMostLand(new ArrayList<TownBlockOwner>(universe.getDataSource().getTowns())));
            } else {
                TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_invalid_sub"));
            }
        } else if (args[0].equalsIgnoreCase("balance")) {
            if (args.length == 1 || args[1].equalsIgnoreCase("all")) {
                list = new ArrayList();
                list.addAll(universe.getTowns());
                list.addAll(universe.getNations());
                towny_top.add(ChatTools.formatTitle("Top Bank Balances"));
                towny_top.addAll(this.getTopBankBalance(list));
            } else if (args[1].equalsIgnoreCase("town")) {
                list = new ArrayList<Town>(universe.getTowns());
                towny_top.add(ChatTools.formatTitle("Top Bank Balances by Town"));
                towny_top.addAll(this.getTopBankBalance(list));
            } else if (args[1].equalsIgnoreCase("nation")) {
                list = new ArrayList<Nation>(universe.getNations());
                towny_top.add(ChatTools.formatTitle("Top Bank Balances by Nation"));
                towny_top.addAll(this.getTopBankBalance(list));
            } else {
                TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_invalid_sub"));
            }
        } else {
            TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_invalid_sub"));
        }
        for (String line : towny_top) {
            TownyMessaging.sendMessage((Object)player, line);
        }
        towny_top.clear();
    }

    public List<String> getUniverseStats(Locale locale) {
        Plugin siegeWar;
        Plugin flagWar;
        Plugin tHist;
        Plugin tFlight;
        Plugin tCult;
        Plugin townyChat;
        TownyUniverse townyUniverse = TownyUniverse.getInstance();
        TownyDataSource townyDS = townyUniverse.getDataSource();
        ArrayList<String> output = new ArrayList<String>();
        Translator translator = Translator.locale(locale);
        output.add("");
        output.add("\u00a70-\u00a74###\u00a70---\u00a74###\u00a70-   \u00a76[\u00a7eTowny \u00a72" + plugin.getVersion() + "\u00a76" + "]");
        output.add("\u00a74#\u00a7c###\u00a74#\u00a70-\u00a74#\u00a7c###\u00a74#\u00a70   \u00a73" + translator.of("msg_universe_attribution") + "\u00a7b" + "Chris H (Shade), ElgarL, LlmDl");
        output.add("\u00a74#\u00a7c####\u00a74#\u00a7c####\u00a74#   \u00a7b" + translator.of("msg_universe_contributors") + "\u00a7c" + translator.of("msg_universe_heart"));
        output.add("\u00a70-\u00a74#\u00a7c#######\u00a74#\u00a70-");
        output.add("\u00a70--\u00a74##\u00a7c###\u00a74##\u00a70--   \u00a73" + translator.of("res_list") + ": " + "\u00a7b" + townyUniverse.getNumResidents() + "\u00a78" + " | " + "\u00a73" + translator.of("town_plu") + ": " + "\u00a7b" + townyDS.getTowns().size() + "\u00a78" + " | " + "\u00a73" + translator.of("nation_plu") + ": " + "\u00a7b" + townyUniverse.getNumNations());
        output.add("\u00a70----\u00a74#\u00a7c#\u00a74#\u00a70----   \u00a73" + translator.of("world_plu") + ": " + "\u00a7b" + townyDS.getWorlds().size() + "\u00a78" + " | " + "\u00a73" + translator.of("townblock_plu") + ": " + "\u00a7b" + townyUniverse.getTownBlocks().size());
        output.add("\u00a70-----\u00a74#\u00a70-----   \u00a7ahttps://TownyAdvanced.github.io/");
        output.add("");
        int plugins = 0;
        String townyPlugins = "\u00a76[";
        Plugin tCamps = Bukkit.getServer().getPluginManager().getPlugin("TownyCamps");
        if (tCamps != null) {
            townyPlugins = townyPlugins + "\u00a7eTownyCamps \u00a72" + tCamps.getDescription().getVersion() + " ";
            ++plugins;
        }
        if ((townyChat = Bukkit.getServer().getPluginManager().getPlugin("TownyChat")) != null) {
            townyPlugins = townyPlugins + "\u00a7eTownyChat \u00a72" + townyChat.getDescription().getVersion() + " ";
            ++plugins;
        }
        if ((tCult = Bukkit.getServer().getPluginManager().getPlugin("TownyCultures")) != null) {
            townyPlugins = townyPlugins + "\u00a7eTownyCultures \u00a72" + tCult.getDescription().getVersion() + " ";
            ++plugins;
        }
        if ((tFlight = Bukkit.getServer().getPluginManager().getPlugin("TownyFlight")) != null) {
            townyPlugins = townyPlugins + "\u00a7eTownyFlight \u00a72" + tFlight.getDescription().getVersion() + " ";
            ++plugins;
        }
        if ((tHist = Bukkit.getServer().getPluginManager().getPlugin("TownyHistories")) != null) {
            townyPlugins = townyPlugins + "\u00a7eTownyHistories \u00a72" + tHist.getDescription().getVersion() + " ";
            ++plugins;
        }
        if ((flagWar = Bukkit.getServer().getPluginManager().getPlugin("FlagWar")) != null) {
            townyPlugins = townyPlugins + "\u00a7eFlagWar \u00a72" + flagWar.getDescription().getVersion() + " ";
            ++plugins;
        }
        if ((siegeWar = Bukkit.getServer().getPluginManager().getPlugin("SiegeWar")) != null) {
            townyPlugins = townyPlugins + "\u00a7eSiegeWar \u00a72" + siegeWar.getDescription().getVersion() + " ";
            ++plugins;
        }
        if (plugins > 0) {
            output.add(townyPlugins + "\u00a76" + "]");
        }
        return output;
    }

    public static void showMap(Player player) {
        TownyAsciiMap.generateAndSend(plugin, player, 7);
    }

    public List<String> getTownyPrices(Town town, Locale locale) {
        ArrayList<String> output = new ArrayList<String>();
        Translator translator = Translator.locale(locale);
        Nation nation = null;
        if (town != null && town.hasNation()) {
            nation = town.getNationOrNull();
        }
        output.add(ChatTools.formatTitle(translator.of("towny_prices_title")));
        output.add(translator.of("towny_prices_town_nation", TownyEconomyHandler.getFormattedBalance(TownySettings.getNewTownPrice()), TownyEconomyHandler.getFormattedBalance(TownySettings.getNewNationPrice())));
        output.add(translator.of("towny_prices_reclaim", TownyEconomyHandler.getFormattedBalance(TownySettings.getEcoPriceReclaimTown())));
        if (town != null) {
            output.add(translator.of("towny_prices_upkeep", TownyEconomyHandler.getFormattedBalance(TownySettings.getTownUpkeepCost(town)), TownyEconomyHandler.getFormattedBalance(TownySettings.getNationUpkeepCost(nation))));
            output.add(translator.of("towny_prices_upkeep_based_on", TownySettings.isUpkeepByPlot() ? translator.of("towny_prices_upkeep_num_plots") : translator.of("towny_prices_upkeep_town_level")));
            if (town.isOverClaimed() && TownySettings.getUpkeepPenalty() > 0.0) {
                output.add(translator.of("towny_prices_overclaimed_upkeep", TownyEconomyHandler.getFormattedBalance(TownySettings.getTownPenaltyUpkeepCost(town))));
            }
            if (TownySettings.getUpkeepPenalty() > 0.0) {
                output.add(translator.of("towny_prices_overclaimed_based_on", TownySettings.isUpkeepPenaltyByPlot() ? translator.of("towny_prices_overclaimed_num_plots") : translator.of("towny_prices_overclaimed_flat_cost"), TownySettings.getUpkeepPenalty()));
            }
            output.add(translator.of("towny_prices_town_merge", TownyEconomyHandler.getFormattedBalance(TownySettings.getBaseCostForTownMerge()), TownyEconomyHandler.getFormattedBalance(town.getTownBlockCost() / 2.0)));
            output.add(translator.of("towny_prices_claiming_townblock", TownyEconomyHandler.getFormattedBalance(town.getTownBlockCost()) + (Double.valueOf(TownySettings.getClaimPriceIncreaseValue()).equals(1.0) ? "" : translator.of("towny_prices_claiming_townblock_increase", new DecimalFormat("##.##%").format(TownySettings.getClaimPriceIncreaseValue() - 1.0)))));
            output.add(translator.of("towny_prices_claiming_outposts", TownyEconomyHandler.getFormattedBalance(TownySettings.getOutpostCost())));
        }
        if (town == null) {
            output.add(translator.of("towny_prices_upkeep", TownyEconomyHandler.getFormattedBalance(TownySettings.getTownUpkeep()), TownyEconomyHandler.getFormattedBalance(TownySettings.getNationUpkeep())));
        }
        if (town != null) {
            output.add(translator.of("towny_prices_townname", town.getFormattedName()));
            output.add(translator.of("towny_prices_price_plot", TownyEconomyHandler.getFormattedBalance(town.getPlotPrice()), TownyEconomyHandler.getFormattedBalance(TownySettings.getOutpostCost())));
            output.add(translator.of("towny_prices_price_shop", TownyEconomyHandler.getFormattedBalance(town.getCommercialPlotPrice()), TownyEconomyHandler.getFormattedBalance(town.getEmbassyPlotPrice())));
            output.add(translator.of("towny_prices_taxes_plot", town.isTaxPercentage() ? town.getTaxes() + "%" : TownyEconomyHandler.getFormattedBalance(town.getTaxes()), TownyEconomyHandler.getFormattedBalance(town.getPlotTax())));
            output.add(translator.of("towny_prices_taxes_shop", TownyEconomyHandler.getFormattedBalance(town.getCommercialPlotTax()), TownyEconomyHandler.getFormattedBalance(town.getEmbassyPlotTax())));
            output.add(translator.of("towny_prices_plots_shop", TownyEconomyHandler.getFormattedBalance(TownySettings.getPlotSetCommercialCost()), TownyEconomyHandler.getFormattedBalance(TownySettings.getPlotSetEmbassyCost())));
            output.add(translator.of("towny_prices_plots_wilds", TownyEconomyHandler.getFormattedBalance(TownySettings.getPlotSetWildsCost()), TownyEconomyHandler.getFormattedBalance(TownySettings.getPlotSetInnCost())));
            output.add(translator.of("towny_prices_plots_jail", TownyEconomyHandler.getFormattedBalance(TownySettings.getPlotSetJailCost()), TownyEconomyHandler.getFormattedBalance(TownySettings.getPlotSetFarmCost())));
            output.add(translator.of("towny_prices_plots_bank", TownyEconomyHandler.getFormattedBalance(TownySettings.getPlotSetBankCost())));
            if (nation != null) {
                output.add(translator.of("towny_prices_nationname", nation.getFormattedName()));
                output.add(translator.of("towny_prices_nation_tax", nation.getTaxes(), TownyEconomyHandler.getFormattedBalance(TownySettings.getNationNeutralityCost())));
            }
        }
        return output;
    }

    public List<String> getTopBankBalance(List<Government> governments) {
        int maxListing = TownySettings.getTownyTopSize();
        ArrayList<String> output = new ArrayList<String>();
        governments.sort(GovernmentComparators.BY_BANK_BALANCE);
        int index = 0;
        for (Government gov : governments) {
            if (maxListing != -1 && ++index > maxListing) break;
            output.add(String.format("\u00a77%-20s \u00a76|\u00a73 %s", gov.getFormattedName(), TownyEconomyHandler.getFormattedBalance(gov.getAccount().getCachedBalance())));
        }
        return output;
    }

    public List<String> getMostResidents(List<ResidentList> list) {
        int maxListing = TownySettings.getTownyTopSize();
        ArrayList<String> output = new ArrayList<String>();
        KeyValueTable<ResidentList, Integer> kvTable = new KeyValueTable<ResidentList, Integer>();
        for (ResidentList obj : list) {
            kvTable.put(obj, obj.getResidents().size());
        }
        kvTable.sortByValue();
        kvTable.reverse();
        int n = 0;
        for (KeyValue kv : kvTable.getKeyValues()) {
            if (maxListing != -1 && ++n > maxListing) break;
            ResidentList residentList = (ResidentList)kv.key;
            output.add(String.format("\u00a73%30s \u00a76|\u00a77 %10d", ((TownyObject)((Object)residentList)).getFormattedName(), kv.value));
        }
        return output;
    }

    public List<String> getMostLand(List<TownBlockOwner> list) {
        int maxListing = TownySettings.getTownyTopSize();
        ArrayList<String> output = new ArrayList<String>();
        KeyValueTable<TownBlockOwner, Integer> kvTable = new KeyValueTable<TownBlockOwner, Integer>();
        for (TownBlockOwner obj : list) {
            kvTable.put(obj, obj.getTownBlocks().size());
        }
        kvTable.sortByValue();
        kvTable.reverse();
        int n = 0;
        for (KeyValue kv : kvTable.getKeyValues()) {
            if (maxListing != -1 && ++n > maxListing) break;
            String name = null;
            name = kv.key instanceof Town ? ((Town)kv.key).getFormattedName() : ((Resident)kv.key).getFormattedName();
            output.add(String.format("\u00a73%30s \u00a76|\u00a77 %10d", name, kv.value));
        }
        return output;
    }

    public void consoleUseOnly(Player player) {
        TownyMessaging.sendErrorMsg((Object)player, "This command was designed for use in the console only.");
    }

    public void inGameUseOnly(CommandSender sender) {
        TownyMessaging.sendMessage((Object)sender, "[Towny] InputError: This command was designed for use in game only.");
    }

    static {
        towny_top = new ArrayList<String>();
        towny_war = new ArrayList<String>();
        townyTabCompletes = Arrays.asList("map", "prices", "time", "top", "spy", "universe", "v", "war", "switches", "itemuse", "farmblocks", "wildsblocks", "plotclearblocks");
        townyConsoleTabCompletes = Arrays.asList("prices", "time", "top", "spy", "universe", "tree", "v", "war");
        townyWarTabCompletes = Arrays.asList("stats", "scores", "hud", "participants");
        townyTopTabCompletes = Arrays.asList("residents", "land", "balance");
        townyTopTownNationCompletes = Arrays.asList("all", "town", "nation");
        townyTopLandTabCompletes = Arrays.asList("all", "resident", "town");
    }
}

