/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.tasks.CooldownTimerTask;
import com.palmergames.bukkit.towny.tasks.DailyTimerTask;
import com.palmergames.bukkit.towny.tasks.DrawSmokeTask;
import com.palmergames.bukkit.towny.tasks.DrawSpawnPointsTask;
import com.palmergames.bukkit.towny.tasks.GatherResidentUUIDTask;
import com.palmergames.bukkit.towny.tasks.HealthRegenTimerTask;
import com.palmergames.bukkit.towny.tasks.HourlyTimerTask;
import com.palmergames.bukkit.towny.tasks.MobRemovalTimerTask;
import com.palmergames.bukkit.towny.tasks.RepeatingTimerTask;
import com.palmergames.bukkit.towny.tasks.ShortTimerTask;
import com.palmergames.bukkit.towny.tasks.TeleportWarmupTimerTask;
import com.palmergames.bukkit.util.BukkitTools;
import com.palmergames.util.TimeMgmt;
import com.palmergames.util.TimeTools;
import java.util.Calendar;
import java.util.TimeZone;

public class TownyTimerHandler {
    private static Towny plugin;
    private static int townyRepeatingTask;
    private static int dailyTask;
    private static int hourlyTask;
    private static int shortTask;
    private static int mobRemoveTask;
    private static int healthRegenTask;
    private static int teleportWarmupTask;
    private static int cooldownTimerTask;
    private static int drawSmokeTask;
    private static int gatherResidentUUIDTask;
    private static int drawSpawnPointsTask;

    public static void initialize(Towny plugin) {
        TownyTimerHandler.plugin = plugin;
    }

    public static void newDay() {
        if (!TownyTimerHandler.isDailyTimerRunning()) {
            TownyTimerHandler.toggleDailyTimer(true);
        }
        if (TownySettings.isEconomyAsync()) {
            if (BukkitTools.scheduleAsyncDelayedTask(new DailyTimerTask(plugin), 0L) == -1) {
                TownyMessaging.sendErrorMsg("Could not schedule newDay.");
            }
        } else if (BukkitTools.scheduleSyncDelayedTask(new DailyTimerTask(plugin), 0L) == -1) {
            TownyMessaging.sendErrorMsg("Could not schedule newDay.");
        }
    }

    public static void newHour() {
        if (!TownyTimerHandler.isHourlyTimerRunning()) {
            TownyTimerHandler.toggleHourlyTimer(true);
        }
        if (BukkitTools.scheduleAsyncDelayedTask(new HourlyTimerTask(plugin), 0L) == -1) {
            TownyMessaging.sendErrorMsg("Could not schedule new hour.");
        }
    }

    public static void toggleTownyRepeatingTimer(boolean on) {
        if (on && !TownyTimerHandler.isTownyRepeatingTaskRunning()) {
            townyRepeatingTask = BukkitTools.scheduleSyncRepeatingTask(new RepeatingTimerTask(plugin), 0L, TimeTools.convertToTicks(1L));
            if (townyRepeatingTask == -1) {
                TownyMessaging.sendErrorMsg("Could not schedule Towny Timer Task.");
            }
        } else if (!on && TownyTimerHandler.isTownyRepeatingTaskRunning()) {
            BukkitTools.getScheduler().cancelTask(townyRepeatingTask);
            townyRepeatingTask = -1;
        }
    }

    public static void toggleMobRemoval(boolean on) {
        if (on && !TownyTimerHandler.isMobRemovalRunning()) {
            mobRemoveTask = BukkitTools.scheduleSyncRepeatingTask(new MobRemovalTimerTask(plugin, BukkitTools.getServer()), 0L, TimeTools.convertToTicks(TownySettings.getMobRemovalSpeed()));
            if (mobRemoveTask == -1) {
                TownyMessaging.sendErrorMsg("Could not schedule mob removal loop.");
            }
        } else if (!on && TownyTimerHandler.isMobRemovalRunning()) {
            BukkitTools.getScheduler().cancelTask(mobRemoveTask);
            mobRemoveTask = -1;
        }
    }

    public static void toggleDailyTimer(boolean on) {
        if (on && !TownyTimerHandler.isDailyTimerRunning()) {
            long timeTillNextDay = TownyTimerHandler.townyTime();
            plugin.getLogger().info("Time until a New Day: " + TimeMgmt.formatCountdownTime(timeTillNextDay));
            dailyTask = TownySettings.isEconomyAsync() ? BukkitTools.scheduleAsyncRepeatingTask(new DailyTimerTask(plugin), TimeTools.convertToTicks(timeTillNextDay), TimeTools.convertToTicks(TownySettings.getDayInterval())) : BukkitTools.scheduleSyncRepeatingTask(new DailyTimerTask(plugin), TimeTools.convertToTicks(timeTillNextDay), TimeTools.convertToTicks(TownySettings.getDayInterval()));
            if (dailyTask == -1) {
                TownyMessaging.sendErrorMsg("Could not schedule new day loop.");
            }
        } else if (!on && TownyTimerHandler.isDailyTimerRunning()) {
            BukkitTools.getScheduler().cancelTask(dailyTask);
            dailyTask = -1;
        }
    }

    public static void toggleHourlyTimer(boolean on) {
        if (on && !TownyTimerHandler.isHourlyTimerRunning()) {
            long timeUntilNextHourInSections = TownyTimerHandler.getTimeUntilNextHourInSeconds();
            hourlyTask = BukkitTools.scheduleAsyncRepeatingTask(new HourlyTimerTask(plugin), timeUntilNextHourInSections, TimeTools.convertToTicks(TownySettings.getHourInterval()));
            if (hourlyTask == -1) {
                TownyMessaging.sendErrorMsg("Could not schedule hourly timer.");
            }
        } else if (!on && TownyTimerHandler.isHourlyTimerRunning()) {
            BukkitTools.getScheduler().cancelTask(hourlyTask);
            hourlyTask = -1;
        }
    }

    public static void toggleShortTimer(boolean on) {
        if (on && !TownyTimerHandler.isShortTimerRunning()) {
            long delayTicks = TimeTools.convertToTicks(60L);
            shortTask = BukkitTools.scheduleAsyncRepeatingTask(new ShortTimerTask(plugin), delayTicks, TimeTools.convertToTicks(TownySettings.getShortInterval()));
            if (shortTask == -1) {
                TownyMessaging.sendErrorMsg("Could not schedule short timer.");
            }
        } else if (!on && TownyTimerHandler.isDailyTimerRunning()) {
            BukkitTools.getScheduler().cancelTask(shortTask);
            shortTask = -1;
        }
    }

    public static void toggleHealthRegen(boolean on) {
        if (on && !TownyTimerHandler.isHealthRegenRunning()) {
            healthRegenTask = BukkitTools.scheduleSyncRepeatingTask(new HealthRegenTimerTask(plugin, BukkitTools.getServer()), 0L, TimeTools.convertToTicks(TownySettings.getHealthRegenSpeed()));
            if (healthRegenTask == -1) {
                TownyMessaging.sendErrorMsg("Could not schedule health regen loop.");
            }
        } else if (!on && TownyTimerHandler.isHealthRegenRunning()) {
            BukkitTools.getScheduler().cancelTask(healthRegenTask);
            healthRegenTask = -1;
        }
    }

    public static void toggleTeleportWarmup(boolean on) {
        if (on && !TownyTimerHandler.isTeleportWarmupRunning()) {
            teleportWarmupTask = BukkitTools.scheduleSyncRepeatingTask(new TeleportWarmupTimerTask(plugin), 0L, 20L);
            if (teleportWarmupTask == -1) {
                TownyMessaging.sendErrorMsg("Could not schedule teleport warmup loop.");
            }
        } else if (!on && TownyTimerHandler.isTeleportWarmupRunning()) {
            BukkitTools.getScheduler().cancelTask(teleportWarmupTask);
            teleportWarmupTask = -1;
        }
    }

    public static void toggleCooldownTimer(boolean on) {
        if (on && !TownyTimerHandler.isCooldownTimerRunning()) {
            cooldownTimerTask = BukkitTools.scheduleAsyncRepeatingTask(new CooldownTimerTask(plugin), 0L, 20L);
            if (cooldownTimerTask == -1) {
                TownyMessaging.sendErrorMsg("Could not schedule cooldown timer loop.");
            }
        } else if (!on && TownyTimerHandler.isCooldownTimerRunning()) {
            BukkitTools.getScheduler().cancelTask(cooldownTimerTask);
            cooldownTimerTask = -1;
        }
    }

    public static void toggleDrawSmokeTask(boolean on) {
        if (on && !TownyTimerHandler.isDrawSmokeTaskRunning()) {
            drawSmokeTask = BukkitTools.scheduleAsyncRepeatingTask(new DrawSmokeTask(plugin), 0L, 100L);
            if (drawSmokeTask == -1) {
                TownyMessaging.sendErrorMsg("Could not schedule draw smoke loop");
            }
        } else if (!on && TownyTimerHandler.isDrawSmokeTaskRunning()) {
            BukkitTools.getScheduler().cancelTask(drawSmokeTask);
            drawSmokeTask = -1;
        }
    }

    public static void toggleGatherResidentUUIDTask(boolean on) {
        if (on && !TownyTimerHandler.isGatherResidentUUIDTaskRunning()) {
            gatherResidentUUIDTask = BukkitTools.scheduleAsyncRepeatingTask(new GatherResidentUUIDTask(plugin), 1200L, 40L);
            TownyMessaging.sendDebugMsg("Starting GatherResidentUUIDTask in 60 seconds.");
            if (gatherResidentUUIDTask == -1) {
                TownyMessaging.sendErrorMsg("Could not schedule gather resident UUID loop");
            }
        } else if (!on && TownyTimerHandler.isGatherResidentUUIDTaskRunning()) {
            BukkitTools.getScheduler().cancelTask(gatherResidentUUIDTask);
            gatherResidentUUIDTask = -1;
            TownyMessaging.sendDebugMsg("Shutting down GatherResidentUUIDTask.");
        }
    }

    public static void toggleDrawSpointsTask(boolean on) {
        if (on && !TownyTimerHandler.isDrawSpawnPointsTaskRunning()) {
            drawSpawnPointsTask = BukkitTools.scheduleAsyncRepeatingTask(new DrawSpawnPointsTask(plugin), 0L, 52L);
            if (drawSpawnPointsTask == -1) {
                TownyMessaging.sendErrorMsg("Could not schedule draw spawn points loop");
            }
        } else if (!on && TownyTimerHandler.isDrawSpawnPointsTaskRunning()) {
            BukkitTools.getScheduler().cancelTask(drawSpawnPointsTask);
            drawSpawnPointsTask = -1;
        }
    }

    public static boolean isTownyRepeatingTaskRunning() {
        return townyRepeatingTask != -1;
    }

    public static boolean isMobRemovalRunning() {
        return mobRemoveTask != -1;
    }

    public static boolean isDailyTimerRunning() {
        return dailyTask != -1;
    }

    public static boolean isHourlyTimerRunning() {
        return hourlyTask != -1;
    }

    public static boolean isShortTimerRunning() {
        return shortTask != -1;
    }

    public static boolean isHealthRegenRunning() {
        return healthRegenTask != -1;
    }

    public static boolean isTeleportWarmupRunning() {
        return teleportWarmupTask != -1;
    }

    public static boolean isCooldownTimerRunning() {
        return cooldownTimerTask != -1;
    }

    public static boolean isDrawSmokeTaskRunning() {
        return drawSmokeTask != -1;
    }

    public static boolean isGatherResidentUUIDTaskRunning() {
        return gatherResidentUUIDTask != -1;
    }

    public static boolean isDrawSpawnPointsTaskRunning() {
        return drawSpawnPointsTask != -1;
    }

    public static Long townyTime() {
        long secondsInDay = TownySettings.getDayInterval();
        Calendar now = Calendar.getInstance();
        TimeZone timeZone = now.getTimeZone();
        long timeMilli = System.currentTimeMillis();
        int timeOffset = timeZone.getOffset(timeMilli) / 1000;
        return (secondsInDay + (TownySettings.getNewDayTime() - timeMilli / 1000L % secondsInDay - (long)timeOffset)) % secondsInDay;
    }

    public static Long getTimeUntilNextHourInSeconds() {
        long timeSinceLastHourMillis = System.currentTimeMillis() % 3600000L;
        long timeSinceLastHourSeconds = timeSinceLastHourMillis / 1000L;
        long timeUntilNextHourSeconds = 3600L - timeSinceLastHourSeconds;
        return timeUntilNextHourSeconds;
    }

    static {
        townyRepeatingTask = -1;
        dailyTask = -1;
        hourlyTask = -1;
        shortTask = -1;
        mobRemoveTask = -1;
        healthRegenTask = -1;
        teleportWarmupTask = -1;
        cooldownTimerTask = -1;
        drawSmokeTask = -1;
        gatherResidentUUIDTask = -1;
        drawSpawnPointsTask = -1;
    }
}

