/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny;

import com.palmergames.bukkit.towny.object.AddonCommand;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.command.CommandExecutor;
import org.jetbrains.annotations.Nullable;

public class TownyCommandAddonAPI {
    private static List<AddonCommand> addedCommands = new ArrayList<AddonCommand>();

    public static boolean addSubCommand(CommandType commandType, String subCommandName, CommandExecutor commandExecutor) {
        return addedCommands.add(new AddonCommand(commandType, subCommandName, commandExecutor));
    }

    public static boolean addSubCommand(AddonCommand command) {
        return addedCommands.add(command);
    }

    public static boolean removeSubCommand(CommandType commandType, String name) {
        return addedCommands.remove((Object)TownyCommandAddonAPI.getAddonCommand(commandType, name));
    }

    public static boolean removeSubCommand(AddonCommand command) {
        return addedCommands.remove((Object)command);
    }

    public static boolean hasCommand(CommandType commandType, String name) {
        for (AddonCommand command : addedCommands) {
            if (command.getCommandType() != commandType || !command.getName().equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static AddonCommand getAddonCommand(CommandType commandType, String name) {
        for (AddonCommand command : addedCommands) {
            if (command.getCommandType() != commandType || !command.getName().equalsIgnoreCase(name)) continue;
            return command;
        }
        return null;
    }

    public static List<String> getTabCompletes(CommandType commandType, List<String> addFrom) {
        List<String> suggestions = addedCommands.stream().filter(command -> command.getCommandType() == commandType).map(AddonCommand::getName).collect(Collectors.toList());
        suggestions.addAll(addFrom);
        return suggestions;
    }

    public static List<AddonCommand> getAddedCommands() {
        return addedCommands;
    }

    public static enum CommandType {
        RESIDENT,
        RESIDENT_SET,
        RESIDENT_TOGGLE,
        NATION,
        NATION_SET,
        NATION_TOGGLE,
        TOWN,
        TOWN_SET,
        TOWN_TOGGLE,
        PLOT,
        PLOT_SET,
        PLOT_TOGGLE,
        TOWNY,
        TOWNYADMIN,
        TOWNYADMIN_SET,
        TOWNYADMIN_TOGGLE,
        TOWNYWORLD,
        TOWNYWORLD_SET,
        TOWNYWORLD_TOGGLE;

    }
}

