/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.config.migration;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.palmergames.bukkit.config.CommentedConfiguration;
import com.palmergames.bukkit.config.migration.Change;
import com.palmergames.bukkit.config.migration.MigrationType;
import com.palmergames.bukkit.config.migration.VersionDeserializer;
import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.permissions.TownyPerms;
import com.palmergames.bukkit.util.Version;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ConfigMigrator {
    private final String migrationFilename;
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(Version.class, (Object)new VersionDeserializer()).create();
    private final CommentedConfiguration config;
    private final CommentedConfiguration townyperms;

    public ConfigMigrator(CommentedConfiguration config, String filename) {
        Objects.requireNonNull(config, filename);
        this.migrationFilename = filename;
        this.config = config;
        this.townyperms = TownyPerms.getTownyPermsFile();
    }

    public void migrate() {
        Version configVersion = Version.fromString(TownySettings.getLastRunVersion());
        boolean saveTownyperms = false;
        for (Migration migration : this.readMigrator()) {
            if (configVersion.compareTo(migration.version) >= 0) continue;
            Towny.getPlugin().getLogger().info("Config: " + migration.version + " applying " + migration.changes.size() + " automatic update" + (migration.changes.size() == 1 ? "" : "s") + " ...");
            for (Change change : migration.changes) {
                this.performChange(change);
                if (change.type != MigrationType.TOWNYPERMS_ADD) continue;
                saveTownyperms = true;
            }
        }
        this.config.save();
        if (saveTownyperms) {
            this.townyperms.save();
        }
    }

    private void performChange(Change change) {
        switch (change.type) {
            case OVERWRITE: {
                this.config.set(change.path, change.value);
                TownyMessaging.sendDebugMsg("Reseting config.yml value at " + change.path + " to " + change.value + ".");
                break;
            }
            case APPEND: {
                String base = this.config.getString(change.path);
                this.config.set(change.path, base + change.value);
                TownyMessaging.sendDebugMsg("Adding " + change.value + " to config.yml value at " + change.path + ".");
                break;
            }
            case TOWN_LEVEL_ADD: {
                this.addTownLevelProperty(change.key, change.value);
                break;
            }
            case NATION_LEVEL_ADD: {
                this.addNationLevelProperty(change.key, change.value);
                break;
            }
            case TOWNYPERMS_ADD: {
                this.addPermissions(change.path, change.value);
                TownyMessaging.sendDebugMsg("Updating townyperms.yml, adding " + change.value + " to " + change.path + " group.");
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported Change type: " + change);
            }
        }
        if (change.worldAction != null) {
            for (TownyWorld world : TownyUniverse.getInstance().getWorldMap().values()) {
                TownyMessaging.sendDebugMsg("Updating " + world.getName() + " with " + change.value);
                change.worldAction.getAction().accept(world, change.value);
                world.save();
            }
        }
    }

    private void addPermissions(String key, String value) {
        List<String> groupNodes = TownyPerms.getPermsOfGroup(key);
        if (groupNodes.contains(value)) {
            return;
        }
        groupNodes.add(value);
        this.townyperms.set(key, groupNodes);
    }

    private List<Migration> readMigrator() {
        InputStream file = Towny.getPlugin().getResource(this.migrationFilename);
        if (file == null) {
            throw new UnsupportedOperationException(this.migrationFilename + " was not found cannot upgrade config");
        }
        InputStreamReader reader = new InputStreamReader(file);
        return (List)GSON.fromJson((Reader)reader, new TypeToken<List<Migration>>(){}.getType());
    }

    public void addTownLevelProperty(String key, String value) {
        List mapList = this.config.getMapList("levels.town_level");
        TownyMessaging.sendDebugMsg("Updating town_level with " + key + " set to " + value);
        for (Map map : mapList) {
            map.put(key, value);
        }
        this.config.set("levels.town_level", mapList);
    }

    public void addNationLevelProperty(String key, String value) {
        List mapList = this.config.getMapList("levels.nation_level");
        TownyMessaging.sendDebugMsg("Updating nation_level with " + key + " set to " + value);
        for (Map map : mapList) {
            map.put(key, value);
        }
        this.config.set("levels.nation_level", mapList);
    }

    static final class Migration {
        Version version;
        List<Change> changes;

        Migration() {
        }

        public String toString() {
            return "Migration{version=" + this.version + ", changes=" + this.changes + '}';
        }
    }
}

