/*
 * Decompiled with CFR 0.152.
 */
package com.uber.rib.core.lifecycle;

import android.os.Bundle;
import android.support.annotation.Nullable;
import com.uber.rib.core.lifecycle.ActivityEvent;
import java.util.Locale;

public class ActivityLifecycleEvent
implements ActivityEvent {
    private static final ActivityLifecycleEvent START_EVENT = new ActivityLifecycleEvent(Type.START);
    private static final ActivityLifecycleEvent RESUME_EVENT = new ActivityLifecycleEvent(Type.RESUME);
    private static final ActivityLifecycleEvent PAUSE_EVENT = new ActivityLifecycleEvent(Type.PAUSE);
    private static final ActivityLifecycleEvent STOP_EVENT = new ActivityLifecycleEvent(Type.STOP);
    private static final ActivityLifecycleEvent DESTROY_EVENT = new ActivityLifecycleEvent(Type.DESTROY);
    private final Type type;

    private ActivityLifecycleEvent(Type type) {
        this.type = type;
    }

    public static Create createOnCreateEvent(@Nullable Bundle stateData) {
        return new Create(stateData);
    }

    public static ActivityLifecycleEvent create(Type type) {
        switch (type) {
            case START: {
                return START_EVENT;
            }
            case RESUME: {
                return RESUME_EVENT;
            }
            case PAUSE: {
                return PAUSE_EVENT;
            }
            case STOP: {
                return STOP_EVENT;
            }
            case DESTROY: {
                return DESTROY_EVENT;
            }
        }
        throw new IllegalArgumentException("Use the createOn" + ActivityLifecycleEvent.capitalize(type.name().toLowerCase(Locale.US)) + "Event() method for this type!");
    }

    @Override
    public Type getType() {
        return this.type;
    }

    private static String capitalize(String line) {
        return Character.toUpperCase(line.charAt(0)) + line.substring(1);
    }

    public static class Create
    extends ActivityLifecycleEvent {
        @Nullable
        private final Bundle savedInstanceState;

        private Create(@Nullable Bundle savedInstanceState) {
            super(Type.CREATE);
            this.savedInstanceState = savedInstanceState;
        }

        @Nullable
        public Bundle getSavedInstanceState() {
            return this.savedInstanceState;
        }
    }

    public static enum Type implements ActivityEvent.BaseType
    {
        CREATE,
        START,
        RESUME,
        PAUSE,
        STOP,
        DESTROY;

    }
}

