/*
 * Decompiled with CFR 0.152.
 */
package unitauto.test;

import com.alibaba.fastjson.JSON;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import unitauto.Log;
import unitauto.MethodUtil;
import unitauto.StringUtil;

public class TestSDK {
    protected static final String TAG = "TestSDK";
    private static TestSDK INSTANCE = new TestSDK();
    private Map<String, String> config;
    private Callback callback;

    public static TestSDK getInstance() {
        return INSTANCE;
    }

    public void setLisenter(Callback callback) {
        this.callback = callback;
        if (callback == null) {
            throw new NullPointerException("callback \u4e0d\u5141\u8bb8\u4e3a null\uff01");
        }
    }

    public void init(Map<String, String> config) {
        this.config = config;
    }

    public void init(Map<String, String> config, Callback callback) {
        if (callback == null) {
            throw new NullPointerException("callback \u4e0d\u5141\u8bb8\u4e3a null\uff01");
        }
        this.config = config;
        this.callback = callback;
        HashMap<String, Object> info = new HashMap<String, Object>();
        try {
            Log.d(TAG, "init config = " + JSON.toJSONString(this.config));
            Thread.sleep(1000L);
            info.put("return_code", "SUCCESS");
            info.put("return_msg", "\u521d\u59cb\u5316\u6210\u529f");
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            info.put("return_code", "ERROR");
            info.put("return_msg", "\u7f51\u7edc\u8d85\u65f6");
        }
        callback.response(info);
    }

    public void pay(Map<String, String> req) {
        String price;
        if (this.callback == null) {
            throw new NullPointerException("\u672a\u521d\u59cb\u5316\uff01");
        }
        HashMap<String, Object> info = new HashMap<String, Object>();
        String orderId = req == null ? null : req.get("order_id");
        String string = price = req == null ? null : req.get("price");
        if (StringUtil.isEmpty(orderId, true) || StringUtil.isEmpty(price, true)) {
            info.put("return_code", "PARAM_ERROR");
            info.put("return_msg", StringUtil.isEmpty(orderId, true) ? "\u53c2\u6570\u7f3a\u5c11 order_id\uff01" : "\u53c2\u6570\u7f3a\u5c11 price\uff01");
            this.callback.response(info);
            return;
        }
        try {
            new BigDecimal(price);
        }
        catch (Exception e) {
            info.put("return_code", "PARAM_ERROR");
            info.put("return_msg", "\u53c2\u6570 price \u7684\u503c\u4e0d\u662f\u6570\u5b57\uff01");
            this.callback.response(info);
            return;
        }
        Log.d(TAG, "init req = " + JSON.toJSONString(req));
        try {
            Thread.sleep(3000L);
            if (Math.random() > 0.7) {
                throw new Exception("\u8bf7\u6c42\u8d85\u65f6");
            }
            if (Math.random() > 0.5) {
                throw new Exception("\u4f59\u989d\u4e0d\u8db3\uff0c\u8bf7\u5148\u5145\u503c\uff01");
            }
            info.put("return_code", "SUCCESS");
            info.put("return_msg", "\u652f\u4ed8\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            info.put("return_code", "ERROR");
            info.put("return_msg", "\u652f\u4ed8\u5931\u8d25\uff1a" + e.getMessage());
        }
        this.callback.response(info);
    }

    public static void main(String[] args) {
        MethodUtil.InterfaceProxy globalInterfaceProxy = MethodUtil.GLOBAL_CALLBACK_MAP.get(TestSDK.class);
        if (globalInterfaceProxy == null) {
            globalInterfaceProxy = new MethodUtil.InterfaceProxy();
        }
        globalInterfaceProxy.$_putCallback("response(Map<String, java.lang.Object>)", new MethodUtil.Listener<Object>(){

            @Override
            public void complete(Object data, Method method, MethodUtil.InterfaceProxy proxy, Object ... extras) throws Exception {
                Log.d(TestSDK.TAG, "main  globalInterfaceProxy.Listener.complete  method = " + method + "; data = " + JSON.toJSONString((Object)data));
            }
        });
        MethodUtil.GLOBAL_CALLBACK_MAP.put(TestSDK.class, globalInterfaceProxy);
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("ip", "192.168.1.1");
        config.put("port", "8888");
        final boolean[] called = new boolean[]{false};
        TestSDK.getInstance().init(config, new Callback(){

            @Override
            public void response(Map<String, Object> info) {
                MethodUtil.InterfaceProxy globalCallback = MethodUtil.GLOBAL_CALLBACK_MAP.get(TestSDK.class);
                try {
                    MethodUtil.Listener<?> listener = globalCallback.$_getCallback("response(Map<String, java.lang.Object>)");
                    listener.complete(info);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (info == null) {
                    System.out.println("TestSDK.main \u8c03\u7528\u8fd4\u56de\u4e3a\u7a7a, \u8bf7\u67e5\u770b\u65e5\u5fd7");
                    new RuntimeException("\u8c03\u7528\u8fd4\u56de\u4e3a\u7a7a").printStackTrace();
                    return;
                }
                String code = (String)info.get("return_code");
                String msg = (String)info.get("return_msg");
                Log.d(TestSDK.TAG, "main TestSDK.getInstance().Callback.response " + (called[0] ? "\u652f\u4ed8\u56de\u8c03" : "\u521d\u59cb\u5316\u5b8c\u6210") + "\uff1acode = " + code + "\uff1bmsg = " + msg);
                called[0] = true;
            }
        });
        try {
            Thread.sleep(2000L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        HashMap<String, String> req = new HashMap<String, String>();
        req.put("order_id", "123456");
        req.put("price", "15.9");
        TestSDK.getInstance().pay(req);
    }

    public static interface Callback {
        public void response(Map<String, Object> var1);
    }
}

