/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.curseapi.util;

import com.google.common.base.Splitter;
import java.util.List;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.jsoup.select.NodeVisitor;

final class FormattingVisitor
implements NodeVisitor {
    private static final Splitter whitespaceSplitter = Splitter.onPattern((String)"\\s+");
    private final int maxLineLength;
    private final StringBuilder text = new StringBuilder();
    private int currentLineLength = 0;
    private boolean shouldGetWholeText;

    FormattingVisitor(int maxLineLength) {
        this.maxLineLength = maxLineLength;
    }

    public String toString() {
        return this.text.toString();
    }

    public void head(Node node, int depth) {
        String name = node.nodeName();
        if ("pre".equals(name)) {
            this.shouldGetWholeText = true;
        } else if (node instanceof TextNode) {
            TextNode text = (TextNode)node;
            if (this.shouldGetWholeText) {
                this.append(text.getWholeText().trim());
            } else {
                this.append(text.text());
            }
        } else if ("a".equals(name)) {
            this.append("[");
        } else if ("li".equals(name)) {
            this.append("\n * ");
        } else if ("dt".equals(name)) {
            this.append("  ");
        } else if ("p".equals(name) || "h1".equals(name) || "h2".equals(name) || "h3".equals(name) || "h4".equals(name) || "h5".equals(name) || "tr".equals(name)) {
            this.append("\n");
        } else if ("img".equals(name)) {
            this.append("![");
        }
    }

    public void tail(Node node, int depth) {
        String name = node.nodeName();
        if ("br".equals(name) || "dd".equals(name) || "dt".equals(name) || "p".equals(name) || "h1".equals(name) || "h2".equals(name) || "h3".equals(name) || "h4".equals(name) || "h5".equals(name)) {
            this.append("\n");
        } else if ("a".equals(name)) {
            this.append(String.format("](%s)", node.absUrl("href")));
        } else if ("img".equals(name)) {
            this.append(String.format("%s](%s)", node.attr("alt"), node.absUrl("src")));
        } else if ("pre".equals(name)) {
            this.shouldGetWholeText = false;
        }
    }

    private void append(String string) {
        if (string.startsWith("\n")) {
            this.currentLineLength = 0;
        }
        if (string.length() + this.currentLineLength > this.maxLineLength) {
            this.wrapAndAppend(string);
        } else {
            this.text.append(string);
            this.currentLineLength += string.length();
        }
    }

    private void wrapAndAppend(String string) {
        List words = whitespaceSplitter.splitToList((CharSequence)string);
        for (int i = 0; i < words.size(); ++i) {
            String word = (String)words.get(i);
            if (string.length() + this.currentLineLength > this.maxLineLength) {
                this.text.append('\n').append(word);
                this.currentLineLength = word.length();
                continue;
            }
            this.text.append(word);
            if (i < words.size() - 1) {
                this.text.append(' ');
                ++this.currentLineLength;
            }
            this.currentLineLength += word.length();
        }
    }
}

