/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.curseapi.game;

import com.google.common.base.MoreObjects;
import com.therandomlabs.curseapi.CurseException;
import com.therandomlabs.curseapi.CursePreconditions;
import com.therandomlabs.curseapi.game.CurseCategory;
import com.therandomlabs.curseapi.game.CurseCategorySection;
import com.therandomlabs.curseapi.game.CurseGameVersion;
import java.util.NavigableSet;
import java.util.Optional;
import java.util.Set;
import okhttp3.HttpUrl;

public abstract class CurseGame
implements Comparable<CurseGame> {
    public final int hashCode() {
        return this.id();
    }

    public final boolean equals(Object object) {
        return this == object || object instanceof CurseGame && this.id() == ((CurseGame)object).id();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", this.id()).add("name", (Object)this.name()).toString();
    }

    @Override
    public final int compareTo(CurseGame game) {
        return this.name().compareTo(game.name());
    }

    public abstract int id();

    public abstract String name();

    public abstract String slug();

    public HttpUrl url() {
        return HttpUrl.get((String)("https://www.curseforge.com/" + this.slug()));
    }

    public abstract Set<CurseCategorySection> categorySections();

    public Optional<CurseCategorySection> categorySection(int id) {
        CursePreconditions.checkCategorySectionID(id, "id");
        return this.categorySections().stream().filter(section -> section.id() == id).findAny();
    }

    public abstract Set<CurseCategory> categories() throws CurseException;

    public abstract Set<CurseCategory> refreshCategories() throws CurseException;

    public abstract <V extends CurseGameVersion<?>> NavigableSet<V> versions() throws CurseException;

    public abstract <V extends CurseGameVersion<?>> NavigableSet<V> refreshVersions() throws CurseException;
}

