/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.curseapi.file;

import com.google.common.base.Preconditions;
import com.therandomlabs.curseapi.file.BasicCurseFile;
import com.therandomlabs.curseapi.file.CurseFileChange;
import com.therandomlabs.curseapi.file.CurseFiles;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;

public class CurseFilesComparison<F extends BasicCurseFile> {
    private final CurseFiles<F> unchanged;
    private final HashSet<CurseFileChange<F>> updated;
    private final HashSet<CurseFileChange<F>> downgraded;
    private final CurseFiles<F> removed;
    private final CurseFiles<F> added;

    protected CurseFilesComparison(Collection<F> unchanged, Collection<CurseFileChange<F>> updated, Collection<CurseFileChange<F>> downgraded, Collection<F> removed, Collection<F> added) {
        Preconditions.checkNotNull(unchanged, (Object)"unchanged should not be null");
        Preconditions.checkNotNull(updated, (Object)"updated should not be null");
        Preconditions.checkNotNull(downgraded, (Object)"downgraded should not be null");
        Preconditions.checkNotNull(removed, (Object)"removed should not be null");
        Preconditions.checkNotNull(added, (Object)"added should not be null");
        this.unchanged = new CurseFiles<F>(unchanged);
        this.updated = new HashSet<CurseFileChange<F>>(updated);
        this.downgraded = new HashSet<CurseFileChange<F>>(downgraded);
        this.removed = new CurseFiles<F>(removed);
        this.added = new CurseFiles<F>(added);
    }

    public CurseFiles<F> unchanged() {
        return this.unchanged.clone();
    }

    public Set<CurseFileChange<F>> updated() {
        return (Set)this.updated.clone();
    }

    public Set<CurseFileChange<F>> downgraded() {
        return (Set)this.downgraded.clone();
    }

    public CurseFiles<F> removed() {
        return this.removed.clone();
    }

    public CurseFiles<F> added() {
        return this.added.clone();
    }

    public static <F extends BasicCurseFile> CurseFilesComparison<F> of(Collection<? extends F> oldFiles, Collection<? extends F> newFiles) {
        Preconditions.checkNotNull(oldFiles, (Object)"oldFiles should not be null");
        Preconditions.checkNotNull(newFiles, (Object)"newFiles should not be null");
        oldFiles = CurseFilesComparison.removeDuplicateProjects(oldFiles);
        newFiles = CurseFilesComparison.removeDuplicateProjects(newFiles);
        HashSet<BasicCurseFile> unchanged = new HashSet<BasicCurseFile>();
        HashSet<CurseFileChange<F>> updated = new HashSet<CurseFileChange<F>>();
        HashSet<CurseFileChange<F>> downgraded = new HashSet<CurseFileChange<F>>();
        HashSet<BasicCurseFile> removed = new HashSet<BasicCurseFile>();
        HashSet<BasicCurseFile> added = new HashSet<BasicCurseFile>();
        for (BasicCurseFile oldFile : oldFiles) {
            Optional<BasicCurseFile> optionalNewFile = newFiles.stream().filter(oldFile::sameProject).findAny();
            if (!optionalNewFile.isPresent()) {
                removed.add(oldFile);
                continue;
            }
            BasicCurseFile newFile = optionalNewFile.get();
            if (oldFile.equals(newFile)) {
                unchanged.add(newFile);
                continue;
            }
            CurseFileChange<BasicCurseFile> fileChange = new CurseFileChange<BasicCurseFile>(oldFile, newFile);
            if (fileChange.isDowngrade()) {
                downgraded.add(fileChange);
                continue;
            }
            updated.add(fileChange);
        }
        for (BasicCurseFile newFile : newFiles) {
            if (!oldFiles.stream().noneMatch(newFile::sameProject)) continue;
            added.add(newFile);
        }
        return new CurseFilesComparison(unchanged, updated, downgraded, removed, added);
    }

    private static <F extends BasicCurseFile> Collection<F> removeDuplicateProjects(Collection<F> files) {
        HashMap<Integer, BasicCurseFile> projectIDFileMap = new HashMap<Integer, BasicCurseFile>();
        for (BasicCurseFile file : files) {
            BasicCurseFile duplicate = (BasicCurseFile)projectIDFileMap.get(file.projectID());
            if (duplicate != null && !file.newerThan(duplicate)) continue;
            projectIDFileMap.put(file.projectID(), file);
        }
        return projectIDFileMap.values();
    }
}

