/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.curseapi.file;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.therandomlabs.curseapi.CurseAPI;
import com.therandomlabs.curseapi.CurseException;
import com.therandomlabs.curseapi.file.BasicCurseFile;
import com.therandomlabs.curseapi.file.CurseAlternateFile;
import com.therandomlabs.curseapi.file.CurseDependency;
import com.therandomlabs.curseapi.file.CurseDependencyType;
import com.therandomlabs.curseapi.file.CurseFileStatus;
import com.therandomlabs.curseapi.file.CurseReleaseType;
import com.therandomlabs.curseapi.file.ExistingCurseFile;
import com.therandomlabs.curseapi.game.CurseGameVersion;
import com.therandomlabs.curseapi.game.CurseGameVersionGroup;
import com.therandomlabs.curseapi.project.CurseProject;
import java.time.ZonedDateTime;
import java.util.HashSet;
import java.util.NavigableSet;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import okhttp3.HttpUrl;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jsoup.nodes.Element;

public abstract class CurseFile
extends BasicCurseFile
implements ExistingCurseFile {
    private transient @Nullable NavigableSet<CurseGameVersion<?>> gameVersions;
    private transient @Nullable Element changelog;

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("projectID", this.projectID()).add("id", this.id()).add("displayName", (Object)this.displayName()).add("downloadURL", (Object)this.downloadURL()).toString();
    }

    @Override
    public abstract @NonNull CurseProject project() throws CurseException;

    @Override
    public HttpUrl url() throws CurseException {
        return this.project().fileURL(this.id());
    }

    @Override
    public CurseFile toCurseFile() {
        return this;
    }

    @Override
    public abstract HttpUrl downloadURL();

    @Override
    public final HttpUrl refreshDownloadURL() {
        return this.downloadURL();
    }

    @Override
    public Element changelog() throws CurseException {
        if (this.changelog == null) {
            Optional<Element> optionalChangelog = CurseAPI.fileChangelog(this.projectID(), this.id());
            if (!optionalChangelog.isPresent()) {
                throw new CurseException("Failed to retrieve changelog for file: " + this);
            }
            this.changelog = optionalChangelog.get();
        }
        return this.changelog;
    }

    @Override
    public Element refreshChangelog() throws CurseException {
        this.changelog = null;
        return this.changelog();
    }

    public abstract String displayName();

    public abstract String nameOnDisk();

    public abstract ZonedDateTime uploadTime();

    public abstract long fileSize();

    public abstract CurseReleaseType releaseType();

    public abstract CurseFileStatus status();

    public String mavenDependency() throws CurseException {
        return this.project().slug() + ':' + this.nameOnDisk().replace('-', ':').replaceAll("\\.[^/.]+$", "");
    }

    public boolean hasAlternateFile() {
        return this.alternateFileID() != 0;
    }

    public abstract int alternateFileID();

    public abstract @Nullable CurseAlternateFile alternateFile();

    public abstract Set<CurseDependency> dependencies();

    public Set<CurseDependency> dependencies(CurseDependencyType type) {
        Preconditions.checkNotNull((Object)((Object)type), (Object)"type should not be null");
        return this.dependencies().stream().filter(dependency -> dependency.type() == type).collect(Collectors.toCollection(HashSet::new));
    }

    public abstract Set<String> gameVersionStrings();

    public <V extends CurseGameVersion<?>> Set<CurseGameVersionGroup<V>> gameVersionGroups() throws CurseException {
        return CurseAPI.gameVersionGroups(this.gameVersions());
    }

    public <V extends CurseGameVersion<?>> NavigableSet<V> gameVersions() throws CurseException {
        if (this.gameVersions == null) {
            Set<String> versionStrings = this.gameVersionStrings();
            this.gameVersions = new TreeSet();
            int gameID = this.project().gameID();
            for (String versionString : versionStrings) {
                CurseAPI.gameVersion(gameID, versionString).ifPresent(this.gameVersions::add);
            }
        }
        return this.gameVersions;
    }

    public <V extends CurseGameVersion<?>> NavigableSet<V> refreshGameVersions() throws CurseException {
        this.gameVersions = null;
        return this.gameVersions();
    }
}

