/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.soter.wrapper.wrap_biometric;

import android.annotation.SuppressLint;
import android.os.Build;
import android.os.CancellationSignal;
import android.support.annotation.NonNull;
import com.tencent.soter.core.model.SLogger;
import com.tencent.soter.wrapper.wrap_task.SoterTaskManager;
import com.tencent.soter.wrapper.wrap_task.SoterTaskThread;

public class SoterBiometricCanceller {
    private static final String TAG = "Soter.SoterBiometricCanceller";
    private CancellationSignal mCancellationSignal = null;
    private static final long MAX_WAIT_EXECUTION_TIME = 350L;

    public SoterBiometricCanceller() {
        if (Build.VERSION.SDK_INT >= 16) {
            this.refreshCancellationSignal();
        }
    }

    public boolean asyncCancelBiometricAuthentication() {
        return this.asyncCancelBiometricAuthenticationInnerImp(true);
    }

    public boolean asyncCancelBiometricAuthentication(boolean shouldPublishCancel) {
        return this.asyncCancelBiometricAuthenticationInnerImp(shouldPublishCancel);
    }

    @SuppressLint(value={"NewApi"})
    public boolean asyncCancelBiometricAuthenticationInnerImp(final boolean shouldPublishCancel) {
        SLogger.i((String)TAG, (String)"soter: publishing cancellation. should publish: %b", (Object[])new Object[]{shouldPublishCancel});
        if (!this.mCancellationSignal.isCanceled()) {
            if (Build.VERSION.SDK_INT < 23) {
                SoterTaskThread.getInstance().postToWorker(new Runnable(){

                    @Override
                    public void run() {
                        SLogger.i((String)SoterBiometricCanceller.TAG, (String)"soter: cancellation signal 1", (Object[])new Object[0]);
                        SoterBiometricCanceller.this.mCancellationSignal.cancel();
                        if (shouldPublishCancel) {
                            SoterBiometricCanceller.this.publishCancel();
                        }
                    }
                });
            } else if (shouldPublishCancel) {
                SoterTaskThread.getInstance().postToWorker(new Runnable(){

                    @Override
                    public void run() {
                        SLogger.i((String)SoterBiometricCanceller.TAG, (String)"soter: cancellation signal 2", (Object[])new Object[0]);
                        SoterBiometricCanceller.this.mCancellationSignal.cancel();
                    }
                });
                SoterTaskThread.getInstance().postToWorkerDelayed(new Runnable(){

                    @Override
                    public void run() {
                        SLogger.w((String)SoterBiometricCanceller.TAG, (String)"hy: waiting for %s ms not callback to system callback. cancel manually", (Object[])new Object[]{350L});
                        SoterBiometricCanceller.this.publishCancel();
                    }
                }, 350L);
            } else {
                SLogger.i((String)TAG, (String)"soter: cancellation signal 3", (Object[])new Object[0]);
                this.mCancellationSignal.cancel();
                SoterTaskManager.getInstance().cancelAuthCancellationTask();
            }
            return true;
        }
        SLogger.i((String)TAG, (String)"soter: cancellation signal already expired.", (Object[])new Object[0]);
        return false;
    }

    private void publishCancel() {
        SoterTaskManager.getInstance().publishAuthCancellation();
    }

    @SuppressLint(value={"NewApi"})
    public void refreshCancellationSignal() {
        SLogger.i((String)TAG, (String)"qc: %s refreshCancellationSignal", (Object[])new Object[]{this});
        this.mCancellationSignal = new CancellationSignal();
    }

    @NonNull
    @SuppressLint(value={"NewApi"})
    public CancellationSignal getSignalObj() {
        if (this.mCancellationSignal != null) {
            SLogger.i((String)TAG, (String)"qc: %s getSignalObj isCanceled:%s", (Object[])new Object[]{this, this.mCancellationSignal.isCanceled()});
        } else {
            SLogger.i((String)TAG, (String)"qc: %s getSignalObj:null", (Object[])new Object[]{this});
        }
        return this.mCancellationSignal;
    }
}

