/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.soter.wrapper.wrap_key;

import com.tencent.soter.core.SoterCore;
import com.tencent.soter.core.model.SLogger;
import com.tencent.soter.core.model.SoterCoreResult;
import com.tencent.soter.core.model.SoterCoreUtil;
import com.tencent.soter.wrapper.wrap_callback.SoterProcessKeyPreparationResult;
import com.tencent.soter.wrapper.wrap_key.ISoterKeyGenerateCallback;
import com.tencent.soter.wrapper.wrap_task.SoterTaskThread;

public class SoterKeyGenerateEngine {
    private static final String TAG = "Soter.SoterKeyGenerateEngine";
    private static final int FLAG_GEN_ASK = 1;
    private static final int FLAG_GEN_AUTH_KEY = 2;
    private int mGenKeyFlag = 0;
    private String mAuthKeyName = "";
    private boolean mShouldDeleteAndReGenAskIfExists = false;
    private boolean mShouldDeleteAndReGenAuthKeyIfExists = false;
    private ISoterKeyGenerateCallback mCallback = null;
    private boolean mIsCallbacked = false;

    private SoterKeyGenerateEngine(int genKeyFlag, String authKeyName, boolean shouldDeleteAndReGenAskIfExists, boolean shouldDeleteAndReGenAuthKeyIfExists, ISoterKeyGenerateCallback callback) {
        this.mGenKeyFlag = genKeyFlag;
        this.mAuthKeyName = authKeyName;
        this.mShouldDeleteAndReGenAskIfExists = shouldDeleteAndReGenAskIfExists;
        this.mShouldDeleteAndReGenAuthKeyIfExists = shouldDeleteAndReGenAuthKeyIfExists;
        this.mCallback = callback;
    }

    public void generate() {
        SoterTaskThread.getInstance().postToWorker(new Runnable(){

            @Override
            public void run() {
                SoterProcessKeyPreparationResult preCheckResult = SoterKeyGenerateEngine.this.checkParams();
                if (!preCheckResult.isSuccess()) {
                    SoterKeyGenerateEngine.this.callback(preCheckResult);
                    return;
                }
                if (!SoterCore.isNativeSupportSoter()) {
                    SLogger.w((String)SoterKeyGenerateEngine.TAG, (String)"soter: native not support soter", (Object[])new Object[0]);
                    SoterKeyGenerateEngine.this.callback(new SoterProcessKeyPreparationResult(2));
                    return;
                }
                if ((SoterKeyGenerateEngine.this.mGenKeyFlag & 1) == 1) {
                    SoterCoreResult genAskResult;
                    SLogger.d((String)SoterKeyGenerateEngine.TAG, (String)"soter: require generate ask. start gen", (Object[])new Object[0]);
                    if (SoterKeyGenerateEngine.this.mShouldDeleteAndReGenAskIfExists && SoterCore.hasAppGlobalSecureKey()) {
                        SLogger.d((String)SoterKeyGenerateEngine.TAG, (String)"soter: request regen ask. remove former one", (Object[])new Object[0]);
                        SoterCoreResult removeAskResult = SoterCore.removeAppGlobalSecureKey();
                        if (!removeAskResult.isSuccess()) {
                            SLogger.w((String)SoterKeyGenerateEngine.TAG, (String)"soter: remove ask failed: %s", (Object[])new Object[]{removeAskResult.errMsg});
                            SoterKeyGenerateEngine.this.callback(removeAskResult);
                            return;
                        }
                    }
                    if (!(genAskResult = SoterCore.generateAppGlobalSecureKey()).isSuccess()) {
                        SLogger.w((String)SoterKeyGenerateEngine.TAG, (String)"soter: generate ask failed: %s", (Object[])new Object[]{genAskResult.errMsg});
                        SoterCore.removeAppGlobalSecureKey();
                        SoterKeyGenerateEngine.this.callback(genAskResult);
                        return;
                    }
                    SLogger.i((String)SoterKeyGenerateEngine.TAG, (String)"soter: generate ask success!", (Object[])new Object[0]);
                    SoterKeyGenerateEngine.this.callback(genAskResult);
                }
                if ((SoterKeyGenerateEngine.this.mGenKeyFlag & 2) == 2) {
                    SoterCoreResult genAuthKeyResult;
                    SLogger.d((String)SoterKeyGenerateEngine.TAG, (String)"soter: require generate auth key. start gen: %s", (Object[])new Object[]{SoterKeyGenerateEngine.this.mAuthKeyName});
                    if (!SoterCore.isAppGlobalSecureKeyValid()) {
                        SLogger.w((String)SoterKeyGenerateEngine.TAG, (String)"soter: no ask.", (Object[])new Object[0]);
                        SoterKeyGenerateEngine.this.callback(new SoterProcessKeyPreparationResult(3, "ASK not exists when generate auth key"));
                        return;
                    }
                    if (SoterKeyGenerateEngine.this.mShouldDeleteAndReGenAuthKeyIfExists && SoterCore.hasAuthKey((String)SoterKeyGenerateEngine.this.mAuthKeyName)) {
                        SLogger.d((String)SoterKeyGenerateEngine.TAG, (String)"soter: request regen auth key. remove former one", (Object[])new Object[0]);
                        SoterCoreResult removeAutKeyResult = SoterCore.removeAuthKey((String)SoterKeyGenerateEngine.this.mAuthKeyName, (boolean)false);
                        if (!removeAutKeyResult.isSuccess()) {
                            SLogger.w((String)SoterKeyGenerateEngine.TAG, (String)"soter: remove auth key %s, failed: %s", (Object[])new Object[]{SoterKeyGenerateEngine.this.mAuthKeyName, removeAutKeyResult.errMsg});
                            SoterKeyGenerateEngine.this.callback(removeAutKeyResult);
                            return;
                        }
                    }
                    if (!(genAuthKeyResult = SoterCore.generateAuthKey((String)SoterKeyGenerateEngine.this.mAuthKeyName)).isSuccess()) {
                        SLogger.w((String)SoterKeyGenerateEngine.TAG, (String)"soter: generate auth key %s failed: %s", (Object[])new Object[]{SoterKeyGenerateEngine.this.mAuthKeyName, genAuthKeyResult.errMsg});
                        SoterCore.removeAuthKey((String)SoterKeyGenerateEngine.this.mAuthKeyName, (boolean)true);
                        SoterKeyGenerateEngine.this.callback(genAuthKeyResult);
                    } else {
                        SLogger.i((String)SoterKeyGenerateEngine.TAG, (String)"soter: generate auth key success!", (Object[])new Object[0]);
                        SoterKeyGenerateEngine.this.callback(genAuthKeyResult);
                    }
                }
            }
        });
    }

    private SoterProcessKeyPreparationResult checkParams() {
        if ((this.mGenKeyFlag & 1) != 1) {
            if ((this.mGenKeyFlag & 2) == 2) {
                if (SoterCoreUtil.isNullOrNil((String)this.mAuthKeyName)) {
                    SLogger.e((String)TAG, (String)"soter: not pass auth key name", (Object[])new Object[0]);
                    return new SoterProcessKeyPreparationResult(1, "auth key name not specified");
                }
            } else {
                SLogger.e((String)TAG, (String)"soter: not specified purpose", (Object[])new Object[0]);
                return new SoterProcessKeyPreparationResult(1001, "not specified purpose. did you for get to call markGenAppSecureKey or/and markGenAuthKey?");
            }
        }
        return new SoterProcessKeyPreparationResult(0);
    }

    private void callback(SoterCoreResult result) {
        if (this.mCallback != null && !this.mIsCallbacked) {
            if (result != null) {
                if (result.isSuccess()) {
                    this.mCallback.onSuccess();
                } else {
                    this.mCallback.onError(result.errCode, result.errMsg);
                }
            } else {
                this.mCallback.onError(-1, "unknown");
            }
        }
        this.mIsCallbacked = true;
    }

    public static class SoterKeyGenerateEngineBuilder {
        private int mGenKeyFlag = 0;
        private String mAuthKeyName = "";
        private boolean mShouldDeleteAndReGenAskIfExists = false;
        private boolean mShouldDeleteAndReGenAuthKeyIfExists = false;
        private ISoterKeyGenerateCallback mCallback = null;

        public SoterKeyGenerateEngineBuilder markGenAppSecureKey(boolean shouldDeleteAndReGenAskIfExists) {
            this.mGenKeyFlag |= 1;
            this.mShouldDeleteAndReGenAskIfExists = shouldDeleteAndReGenAskIfExists;
            return this;
        }

        public SoterKeyGenerateEngineBuilder markGenAuthKey(String authKeyName, boolean shouldDeleteAndReGenAuthKeyIfExists) {
            this.mAuthKeyName = authKeyName;
            this.mShouldDeleteAndReGenAuthKeyIfExists = shouldDeleteAndReGenAuthKeyIfExists;
            this.mGenKeyFlag |= 2;
            return this;
        }

        public SoterKeyGenerateEngineBuilder setKeyGenCallback(ISoterKeyGenerateCallback callback) {
            this.mCallback = callback;
            return this;
        }

        public SoterKeyGenerateEngine build() {
            return new SoterKeyGenerateEngine(this.mGenKeyFlag, this.mAuthKeyName, this.mShouldDeleteAndReGenAskIfExists, this.mShouldDeleteAndReGenAuthKeyIfExists, this.mCallback);
        }
    }
}

