/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.soter.wrapper;

import android.app.Application;
import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;
import android.util.SparseArray;
import com.tencent.soter.core.SoterCore;
import com.tencent.soter.core.model.SLogger;
import com.tencent.soter.core.model.SoterCoreResult;
import com.tencent.soter.core.model.SoterCoreUtil;
import com.tencent.soter.wrapper.AppForegroundDetector;
import com.tencent.soter.wrapper.wrap_callback.SoterProcessAuthenticationResult;
import com.tencent.soter.wrapper.wrap_callback.SoterProcessCallback;
import com.tencent.soter.wrapper.wrap_callback.SoterProcessKeyPreparationResult;
import com.tencent.soter.wrapper.wrap_callback.SoterProcessNoExtResult;
import com.tencent.soter.wrapper.wrap_core.SoterDataCenter;
import com.tencent.soter.wrapper.wrap_core.SoterProcessErrCode;
import com.tencent.soter.wrapper.wrap_net.IWrapUploadKeyNet;
import com.tencent.soter.wrapper.wrap_task.AuthenticationParam;
import com.tencent.soter.wrapper.wrap_task.InitializeParam;
import com.tencent.soter.wrapper.wrap_task.SoterTaskManager;
import com.tencent.soter.wrapper.wrap_task.SoterTaskThread;
import com.tencent.soter.wrapper.wrap_task.TaskAuthentication;
import com.tencent.soter.wrapper.wrap_task.TaskBiometricAuthentication;
import com.tencent.soter.wrapper.wrap_task.TaskInit;
import com.tencent.soter.wrapper.wrap_task.TaskPrepareAppSecureKey;
import com.tencent.soter.wrapper.wrap_task.TaskPrepareAuthKey;

public class SoterWrapperApi
implements SoterProcessErrCode {
    private static final String TAG = "Soter.SoterWrapperApi";

    public static void init(final Context context, final SoterProcessCallback<SoterProcessNoExtResult> callback, final @NonNull InitializeParam param) {
        SoterTaskThread.getInstance().postToWorker(new Runnable(){

            @Override
            public void run() {
                TaskInit taskInit = new TaskInit(context, param);
                taskInit.setTaskCallback(callback);
                if (!SoterTaskManager.getInstance().addToTask(taskInit, new SoterProcessNoExtResult())) {
                    SLogger.e((String)SoterWrapperApi.TAG, (String)"soter: add init task failed.", (Object[])new Object[0]);
                }
            }
        });
    }

    @RequiresApi(api=14)
    public static void detectAppForeground(Application application) {
        application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)new AppForegroundDetector());
    }

    public static void prepareAppSecureKey(SoterProcessCallback<SoterProcessKeyPreparationResult> callback, boolean isAutoDeleteIfAlreadyExists, IWrapUploadKeyNet appSecureKeyNetWrapper) {
        SLogger.i((String)TAG, (String)"soter: starting prepare ask key. ", (Object[])new Object[0]);
        TaskPrepareAppSecureKey taskPrepareAppSecureKey = new TaskPrepareAppSecureKey(appSecureKeyNetWrapper, isAutoDeleteIfAlreadyExists);
        taskPrepareAppSecureKey.setTaskCallback(callback);
        if (!SoterTaskManager.getInstance().addToTask(taskPrepareAppSecureKey, new SoterProcessKeyPreparationResult())) {
            SLogger.d((String)TAG, (String)"soter: add prepareAppSecureKey task failed.", (Object[])new Object[0]);
        }
    }

    public static void prepareAuthKey(SoterProcessCallback<SoterProcessKeyPreparationResult> callback, boolean isAutoDeleteIfAlreadyExists, boolean isAutoPrepareASKWhenNotFound, int scene, IWrapUploadKeyNet authKeyNetWrapper, IWrapUploadKeyNet appSecureKeyNetWrapper) {
        SLogger.i((String)TAG, (String)"soter: starting prepare auth key: %d", (Object[])new Object[]{scene});
        TaskPrepareAuthKey taskPrepareAuthKey = new TaskPrepareAuthKey(scene, authKeyNetWrapper, appSecureKeyNetWrapper, isAutoDeleteIfAlreadyExists, isAutoPrepareASKWhenNotFound);
        taskPrepareAuthKey.setTaskCallback(callback);
        if (!SoterTaskManager.getInstance().addToTask(taskPrepareAuthKey, new SoterProcessKeyPreparationResult())) {
            SLogger.d((String)TAG, (String)"soter: add prepareAuthKey task failed.", (Object[])new Object[0]);
        }
    }

    public static void requestAuthorizeAndSign(SoterProcessCallback<SoterProcessAuthenticationResult> taskCallback, @NonNull AuthenticationParam param) {
        SLogger.i((String)TAG, (String)"soter: request authorize provide challenge. scene: %d", (Object[])new Object[]{param.getScene()});
        if (param.getBiometricType() == 1 || param.getBiometricType() == 2) {
            TaskBiometricAuthentication taskBiometricAuthentication = new TaskBiometricAuthentication(param);
            taskBiometricAuthentication.setTaskCallback(taskCallback);
            if (!SoterTaskManager.getInstance().addToTask(taskBiometricAuthentication, new SoterProcessAuthenticationResult())) {
                SLogger.d((String)TAG, (String)"soter: add 2.0 requestAuthorizeAndSign task failed.", (Object[])new Object[0]);
            }
        } else {
            TaskAuthentication taskAuthentication = new TaskAuthentication(param);
            taskAuthentication.setTaskCallback(taskCallback);
            if (!SoterTaskManager.getInstance().addToTask(taskAuthentication, new SoterProcessAuthenticationResult())) {
                SLogger.d((String)TAG, (String)"soter: add 1.0 requestAuthorizeAndSign task failed.", (Object[])new Object[0]);
            }
        }
    }

    public static boolean isSupportSoter() {
        return SoterDataCenter.getInstance().isInit() && SoterDataCenter.getInstance().isSupportSoter();
    }

    public static int getSupportType() {
        return SoterDataCenter.getInstance().getSupportType();
    }

    public static boolean isInitialized() {
        return SoterDataCenter.getInstance().isInit();
    }

    public static void ensureConnection() {
        if (SoterWrapperApi.isInitialized() && !SoterCore.isTrebleServiceConnected()) {
            SoterCore.triggerTrebleServiceConnecting();
        }
    }

    public static boolean removeAuthKeyByScene(int scene) {
        boolean isInit = SoterDataCenter.getInstance().isInit();
        String authKeyName = (String)SoterDataCenter.getInstance().getAuthKeyNames().get(scene);
        if (isInit && !SoterCoreUtil.isNullOrNil((String)authKeyName)) {
            SoterCoreResult result = SoterCore.removeAuthKey((String)authKeyName, (boolean)false);
            return result.errCode == 0;
        }
        if (!isInit) {
            SLogger.w((String)TAG, (String)"soter: not initialized yet", (Object[])new Object[0]);
            return false;
        }
        SLogger.w((String)TAG, (String)"soter: scene not registered in init. please make sure", (Object[])new Object[0]);
        return false;
    }

    public static void clearAllKey() {
        SparseArray<String> authKeyNames = SoterDataCenter.getInstance().getAuthKeyNames();
        int size = authKeyNames.size();
        for (int i = 0; i < size; ++i) {
            String authKeyName = (String)authKeyNames.valueAt(i);
            SoterCore.removeAuthKey((String)authKeyName, (boolean)false);
        }
        SoterCore.removeAppGlobalSecureKey();
    }

    public static void tryStopAllSoterTask() {
        SoterTaskManager.getInstance().cancelAllTask();
    }

    public static void release() {
        SoterWrapperApi.tryStopAllSoterTask();
        SoterDataCenter.getInstance().clearStatus();
    }
}

