/*
 * Decompiled with CFR 0.152.
 */
package gotap.com.tapglkitandroid.gl.Views;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.util.AttributeSet;
import gotap.com.tapglkitandroid.gl.R;
import gotap.com.tapglkitandroid.gl.Shaders.TapLoadingShader;
import gotap.com.tapglkitandroid.gl.Views.TapRender;
import gotap.com.tapglkitandroid.gl.Views.TapViewSurface;

public class TapLoadingView
extends TapViewSurface
implements TapRender.TapRenderListener {
    private FullProgressListener fullProgressListener;
    private float timer = 0.0f;
    private boolean forceStop = false;
    public int color = Color.parseColor((String)"#ffffff");
    public boolean useCustomColor = true;
    private boolean isStarted;
    private float percent;
    private boolean shouldUsePercent;

    @Override
    protected TapRender.TapRenderListener listener() {
        return this;
    }

    public TapLoadingView(Context context) {
        super(context);
    }

    @Override
    protected Class getShader() {
        return TapLoadingShader.class;
    }

    public TapLoadingView(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.TapLoadingView);
        this.useCustomColor = a.getBoolean(R.styleable.TapLoadingView_useCustomColor, false);
        this.color = a.getColor(R.styleable.TapLoadingView_customColor, -1);
        if (this.color != -1) {
            this.useCustomColor = true;
        }
        a.recycle();
    }

    @Override
    public float width() {
        return this.getMeasuredWidth();
    }

    @Override
    public float height() {
        return this.getMeasuredHeight();
    }

    @Override
    public int getColor() {
        return this.color;
    }

    @Override
    public boolean isForceStop() {
        return this.forceStop;
    }

    public void setForceStop(boolean forceStop) {
        this.forceStop = forceStop;
        this.isStarted = !forceStop;
        this.percent = 1.0f;
        this.shouldUsePercent = false;
    }

    public void setForceStop(boolean forceStop, FullProgressListener fullProgressListener) {
        this.fullProgressListener = fullProgressListener;
        this.setForceStop(forceStop);
    }

    public void setPercent(float percent) {
        this.shouldUsePercent = true;
        if (!this.isStarted) {
            this.percent = percent;
            super.start();
        }
    }

    @Override
    public void start() {
        this.timer = -1.0f;
        if (this.isForceStop()) {
            this.forceStop = false;
        }
        super.start();
        this.isStarted = true;
        this.shouldUsePercent = false;
    }

    public void startFromCurrent() {
        super.start();
        if (this.isForceStop()) {
            this.forceStop = false;
        }
        this.isStarted = true;
    }

    @Override
    public float getTimer() {
        if (this.isForceStop() && !this.shouldUsePercent) {
            boolean timerCondition;
            boolean bl = timerCondition = this.timer / 60.0f % 2.5f == 0.0f && this.timer / 60.0f % 5.0f != 0.0f;
            if (timerCondition || this.timer == -1.0f) {
                if (timerCondition && this.fullProgressListener != null) {
                    this.fullProgressListener.onFullProgress();
                    this.fullProgressListener = null;
                }
                this.timer = -1.0f;
                return 2.5f;
            }
            float f = this.timer;
            this.timer = f + 1.0f;
            return f / 60.0f;
        }
        if (this.isStarted) {
            float f = this.timer;
            this.timer = f + 1.0f;
            return f / 60.0f;
        }
        float value = 4.5f - 2.0f * this.percent;
        this.timer = (int)value * 60;
        return value;
    }

    @Override
    public boolean useCustomColor() {
        return this.useCustomColor;
    }

    public static interface FullProgressListener {
        public void onFullProgress();
    }
}

