/*
 * Decompiled with CFR 0.152.
 */
package gotap.com.tapglkitandroid.gl.Shaders;

import android.content.Context;
import android.opengl.GLES20;
import gotap.com.tapglkitandroid.gl.Shaders.FileUtils;

public class ShaderUtils {
    public static int createProgram(int vertexShaderId, int fragmentShaderId) {
        int programId = GLES20.glCreateProgram();
        if (programId == 0) {
            return 0;
        }
        GLES20.glAttachShader((int)programId, (int)vertexShaderId);
        GLES20.glAttachShader((int)programId, (int)fragmentShaderId);
        GLES20.glLinkProgram((int)programId);
        int[] linkStatus = new int[1];
        GLES20.glGetProgramiv((int)programId, (int)35714, (int[])linkStatus, (int)0);
        if (linkStatus[0] == 0) {
            GLES20.glDeleteProgram((int)programId);
            return 0;
        }
        return programId;
    }

    static int createShader(Context context, int type, int shaderRawId) {
        String shaderText = FileUtils.readTextFromRaw(context, shaderRawId);
        return ShaderUtils.createShader(type, shaderText);
    }

    static int createShader(int type, String shaderText) {
        int shaderId = GLES20.glCreateShader((int)type);
        if (shaderId == 0) {
            return 0;
        }
        GLES20.glShaderSource((int)shaderId, (String)shaderText);
        GLES20.glCompileShader((int)shaderId);
        int[] compileStatus = new int[1];
        GLES20.glGetShaderiv((int)shaderId, (int)35713, (int[])compileStatus, (int)0);
        if (compileStatus[0] == 0) {
            GLES20.glDeleteShader((int)shaderId);
            return 0;
        }
        return shaderId;
    }
}

