/*
 * Decompiled with CFR 0.152.
 */
package gotap.com.tapglkitandroid.gl.Shaders;

import android.content.Context;
import android.opengl.GLES20;
import gotap.com.tapglkitandroid.gl.Shaders.ShaderUtils;
import gotap.com.tapglkitandroid.gl.Views.TapRender;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;

public abstract class BaseShader {
    protected int programId;
    private FloatBuffer vertexData;
    private String kAttributePositionKey = "position";
    private String kUniformResolutionKey = "resolution";
    private int mPositionHandle;
    private int mResolutionHandle;
    protected TapRender.TapRenderListener listener;

    abstract void obtainAttributesAndUniformsForShader();

    abstract void drawElement();

    abstract int vertexShaderRaw();

    abstract int fragmentShaderRaw();

    public BaseShader(Context context, TapRender.TapRenderListener listener) {
        int vertexShaderId = ShaderUtils.createShader(context, 35633, this.vertexShaderRaw());
        int fragmentShaderId = ShaderUtils.createShader(context, 35632, this.fragmentShaderRaw());
        this.programId = ShaderUtils.createProgram(vertexShaderId, fragmentShaderId);
        GLES20.glUseProgram((int)this.programId);
        this.obtainAttributesAndUniforms();
        this.listener = listener;
    }

    void obtainAttributesAndUniforms() {
        float[] vertices = new float[]{-1.0f, -1.0f, -1.0f, 1.0f, 1.0f, -1.0f, 1.0f, 1.0f};
        this.vertexData = ByteBuffer.allocateDirect(vertices.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        this.vertexData.put(vertices);
        this.mPositionHandle = GLES20.glGetAttribLocation((int)this.programId, (String)this.kAttributePositionKey);
        this.mResolutionHandle = GLES20.glGetUniformLocation((int)this.programId, (String)this.kUniformResolutionKey);
        this.vertexData.position(0);
        this.obtainAttributesAndUniformsForShader();
        GLES20.glVertexAttribPointer((int)this.mPositionHandle, (int)2, (int)5126, (boolean)false, (int)0, (Buffer)this.vertexData);
        GLES20.glEnableVertexAttribArray((int)this.mPositionHandle);
    }

    public void draw() {
        GLES20.glClear((int)16384);
        if (this.listener != null) {
            GLES20.glUniform2f((int)this.mResolutionHandle, (float)this.listener.width(), (float)this.listener.height());
        } else {
            GLES20.glUniform2f((int)this.mResolutionHandle, (float)200.0f, (float)200.0f);
        }
        this.drawElement();
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
    }
}

