/*
 * Decompiled with CFR 0.152.
 */
package com.tr4android.support.extension.widget;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.support.annotation.ColorInt;
import android.support.annotation.DrawableRes;
import android.support.v4.graphics.drawable.RoundedBitmapDrawable;
import android.support.v4.graphics.drawable.RoundedBitmapDrawableFactory;
import android.support.v7.widget.AppCompatDrawableManager;
import android.support.v7.widget.AppCompatImageView;
import android.util.AttributeSet;
import android.util.Log;
import com.tr4android.appcompat.extension.R;
import com.tr4android.support.extension.drawable.PlaceholderDrawable;
import com.tr4android.support.extension.utils.ThemeUtils;

public class CircleImageView
extends AppCompatImageView {
    private static final String LOG_TAG = "CircleImageView";
    private boolean mIsCircleImageEnabled = true;
    private boolean mIsResolvingDrawable;
    private PlaceholderDrawable mPlaceholderDrawable;
    private int mPlaceholderCircleDefaultColor;

    public CircleImageView(Context context) {
        this(context, null);
    }

    public CircleImageView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public CircleImageView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.CircleImageView, defStyleAttr, 0);
        this.mIsCircleImageEnabled = a.getBoolean(R.styleable.CircleImageView_circleImageEnabled, true);
        this.mPlaceholderCircleDefaultColor = a.getColor(R.styleable.CircleImageView_placeholderCircleColor, ThemeUtils.getThemeAttrColor(this.getContext(), R.attr.colorAccent));
        int textColorPrimaryInverse = ThemeUtils.getThemeAttrColor(this.getContext(), 16842809);
        int mPlaceholderTextSize = a.getDimensionPixelSize(R.styleable.CircleImageView_placeholderTextSize, this.getResources().getDimensionPixelSize(R.dimen.defaultPlaceholderTextSize));
        int mPlaceholderTextColor = a.getColor(R.styleable.CircleImageView_placeholderTextColor, textColorPrimaryInverse);
        int mPlaceholderImageSize = a.getDimensionPixelSize(R.styleable.CircleImageView_placeholderIconSize, this.getResources().getDimensionPixelSize(R.dimen.defaultPlaceholderImageSize));
        int mPlaceholderImageColor = a.getColor(R.styleable.CircleImageView_placeholderIconColor, textColorPrimaryInverse);
        a.recycle();
        this.mPlaceholderDrawable = new PlaceholderDrawable(mPlaceholderTextSize, mPlaceholderTextColor, mPlaceholderImageSize, mPlaceholderImageColor);
    }

    public void setImageBitmap(Bitmap bm) {
        if (this.mIsCircleImageEnabled) {
            this.setImageDrawable((Drawable)CircleImageView.getCircleBitmapDrawable(this.getContext(), bm));
        } else {
            super.setImageBitmap(bm);
        }
    }

    public void setImageDrawable(Drawable drawable2) {
        if (this.mIsCircleImageEnabled && drawable2 != null && !(drawable2 instanceof RoundedBitmapDrawable) && !(drawable2 instanceof PlaceholderDrawable)) {
            this.setImageDrawable((Drawable)CircleImageView.getCircleBitmapDrawable(this.getContext(), CircleImageView.getBitmapFromDrawable(drawable2)));
        } else {
            super.setImageDrawable(drawable2);
        }
    }

    public void setImageResource(@DrawableRes int resId) {
        if (this.mIsCircleImageEnabled) {
            this.mIsResolvingDrawable = true;
            super.setImageResource(resId);
            this.mIsResolvingDrawable = false;
            this.setImageDrawable((Drawable)CircleImageView.getCircleBitmapDrawable(this.getContext(), CircleImageView.getBitmapFromDrawable(this.getDrawable())));
        } else {
            super.setImageResource(resId);
        }
    }

    public void setImageURI(Uri uri) {
        if (this.mIsCircleImageEnabled) {
            this.mIsResolvingDrawable = true;
            super.setImageURI(uri);
            this.mIsResolvingDrawable = false;
            this.setImageDrawable((Drawable)CircleImageView.getCircleBitmapDrawable(this.getContext(), CircleImageView.getBitmapFromDrawable(this.getDrawable())));
        } else {
            super.setImageURI(uri);
        }
    }

    public void setCircleImageEnabled(boolean enabled) {
        this.mIsCircleImageEnabled = enabled;
    }

    public boolean isCircleImageEnabled() {
        return this.mIsCircleImageEnabled;
    }

    public void setPlaceholder(String placeholderText) {
        this.setPlaceholder(placeholderText, this.mPlaceholderCircleDefaultColor);
    }

    public void setPlaceholder(String placeholderText, @ColorInt int circleColor) {
        this.mPlaceholderDrawable.setPlaceholder(placeholderText, circleColor);
        this.setImageDrawable(this.mPlaceholderDrawable);
    }

    public void setPlaceholder(@DrawableRes int resId) {
        this.setPlaceholder(AppCompatDrawableManager.get().getDrawable(this.getContext(), resId), this.mPlaceholderCircleDefaultColor);
    }

    public void setPlaceholder(Drawable drawable2) {
        this.setPlaceholder(drawable2, this.mPlaceholderCircleDefaultColor);
    }

    public void setPlaceholder(@DrawableRes int resId, @ColorInt int circleColor) {
        this.setPlaceholder(AppCompatDrawableManager.get().getDrawable(this.getContext(), resId), circleColor);
    }

    public void setPlaceholder(Drawable drawable2, @ColorInt int circleColor) {
        this.mPlaceholderDrawable.setPlaceholder(drawable2, circleColor);
        this.setImageDrawable(this.mPlaceholderDrawable);
    }

    public static String retrieveLetter(String text) {
        return String.valueOf(text.charAt(0)).toUpperCase();
    }

    public void onDraw(Canvas canvas) {
        if (this.mIsResolvingDrawable) {
            return;
        }
        super.onDraw(canvas);
    }

    public static RoundedBitmapDrawable getCircleBitmapDrawable(Context context, Bitmap bitmap) {
        RoundedBitmapDrawable drawable2 = RoundedBitmapDrawableFactory.create((Resources)context.getResources(), (Bitmap)bitmap);
        drawable2.setCornerRadius((float)Math.max(bitmap.getWidth() / 2, bitmap.getHeight() / 2));
        drawable2.setAntiAlias(true);
        return drawable2;
    }

    public static Bitmap getBitmapFromDrawable(Drawable drawable2) {
        if (drawable2 == null) {
            return null;
        }
        if (drawable2 instanceof BitmapDrawable) {
            Log.w((String)LOG_TAG, (String)"For better performance consider using setImageBitmap() instead!");
            return ((BitmapDrawable)drawable2).getBitmap();
        }
        Bitmap bitmap = Bitmap.createBitmap((int)Math.max(2, drawable2.getIntrinsicWidth()), (int)Math.max(2, drawable2.getIntrinsicHeight()), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        drawable2.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
        drawable2.draw(canvas);
        return bitmap;
    }
}

