/*
 * Decompiled with CFR 0.152.
 */
package com.tr4android.support.extension.picker;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.os.Build;
import android.support.annotation.ColorInt;
import android.support.v4.content.ContextCompat;
import android.support.v4.graphics.drawable.DrawableCompat;
import android.support.v7.widget.AppCompatDrawableManager;
import android.util.TypedValue;
import android.widget.ImageButton;
import com.tr4android.appcompat.extension.R;
import com.tr4android.support.extension.utils.ThemeUtils;

public class PickerThemeUtils {
    public static ColorStateList getHeaderTextColorStateList(Context context) {
        return new ColorStateList((int[][])new int[][]{{0x10100A1}, new int[0]}, new int[]{ContextCompat.getColor((Context)context, (int)R.color.abc_primary_text_material_dark), ContextCompat.getColor((Context)context, (int)R.color.abc_secondary_text_material_dark)});
    }

    public static Drawable getHeaderBackground(Context context, @ColorInt int color2) {
        if (Build.VERSION.SDK_INT < 21) {
            GradientDrawable drawable2 = (GradientDrawable)ContextCompat.getDrawable((Context)context, (int)R.drawable.picker_header_background);
            drawable2.setColor(color2);
            return drawable2;
        }
        return new ColorDrawable(color2);
    }

    public static ColorStateList getTextColorPrimaryActivatedStateList(Context context) {
        float disabledAlpha = PickerThemeUtils.getDisabledAlpha(context);
        int textColor = ThemeUtils.getThemeAttrColor(context, 16842806);
        int textColorActivated = ContextCompat.getColor((Context)context, (int)R.color.abc_primary_text_material_dark);
        return new ColorStateList((int[][])new int[][]{{-16842910, 0x10100A1}, {-16842910}, {0x10100A1}, new int[0]}, new int[]{PickerThemeUtils.setAlphaComponent(textColorActivated, disabledAlpha), PickerThemeUtils.setAlphaComponent(textColor, disabledAlpha), textColorActivated, textColor});
    }

    public static ColorStateList getTextColorSecondaryActivatedStateList(Context context) {
        float disabledAlpha = PickerThemeUtils.getDisabledAlpha(context);
        int textColor = ThemeUtils.getThemeAttrColor(context, 16842808);
        int textColorActivated = ContextCompat.getColor((Context)context, (int)R.color.abc_secondary_text_material_dark);
        return new ColorStateList((int[][])new int[][]{{-16842910, 0x10100A1}, {-16842910}, {0x10100A1}, new int[0]}, new int[]{PickerThemeUtils.setAlphaComponent(textColorActivated, disabledAlpha), PickerThemeUtils.setAlphaComponent(textColor, disabledAlpha), textColorActivated, textColor});
    }

    public static float getDisabledAlpha(Context context) {
        TypedValue outValue = new TypedValue();
        context.getTheme().resolveAttribute(0x1010033, outValue, true);
        return outValue.getFloat();
    }

    public static int setAlphaComponent(int color2, float alpha) {
        int srcRgb = color2 & 0xFFFFFF;
        int srcAlpha = color2 >> 24 & 0xFF;
        int dstAlpha = (int)((float)srcAlpha * alpha + 0.5f);
        return srcRgb | dstAlpha << 24;
    }

    public static ColorStateList getNavButtonColorStateList(Context context) {
        return new ColorStateList((int[][])new int[][]{{16842919}, {16842908}, new int[0]}, new int[]{ThemeUtils.getThemeAttrColor(context, R.attr.colorControlHighlight), ThemeUtils.getThemeAttrColor(context, R.attr.colorControlHighlight), ContextCompat.getColor((Context)context, (int)17170445)});
    }

    public static Drawable getNavButtonBackground(Context context) {
        Drawable drawable2 = ContextCompat.getDrawable((Context)context, (int)R.drawable.date_picker_nav_background);
        if (Build.VERSION.SDK_INT < 21) {
            drawable2 = DrawableCompat.wrap((Drawable)drawable2.mutate());
            DrawableCompat.setTintList((Drawable)drawable2, (ColorStateList)PickerThemeUtils.getNavButtonColorStateList(context));
        }
        return drawable2;
    }

    public static void setNavButtonDrawable(Context context, ImageButton left, ImageButton right, int monthTextAppearanceResId) {
        AppCompatDrawableManager dm = AppCompatDrawableManager.get();
        Drawable prevDrawable = dm.getDrawable(context, R.drawable.ic_chevron_left_black_24dp);
        Drawable nextDrawable = dm.getDrawable(context, R.drawable.ic_chevron_right_black_24dp);
        TypedArray ta = context.obtainStyledAttributes(null, new int[]{16842904}, 0, monthTextAppearanceResId);
        ColorStateList monthColor = ta.getColorStateList(0);
        if (monthColor != null) {
            DrawableCompat.setTint((Drawable)DrawableCompat.wrap((Drawable)prevDrawable), (int)monthColor.getDefaultColor());
            DrawableCompat.setTint((Drawable)DrawableCompat.wrap((Drawable)nextDrawable), (int)monthColor.getDefaultColor());
        }
        ta.recycle();
        left.setImageDrawable(prevDrawable);
        right.setImageDrawable(nextDrawable);
    }
}

