/*
 * Decompiled with CFR 0.152.
 */
package com.tr4android.support.extension.internal;

import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import com.tr4android.appcompat.extension.R;
import com.tr4android.support.extension.internal.Account;
import com.tr4android.support.extension.internal.IAccount;
import com.tr4android.support.extension.widget.CircleImageView;

public class AccountUtils {
    public static void applyAccountName(IAccount account, TextView tv) {
        tv.setText((CharSequence)account.getName());
    }

    public static void applyAccountEmail(IAccount account, TextView tv) {
        tv.setText((CharSequence)account.getEmail());
    }

    public static void applyAccountListTitle(IAccount account, TextView tv) {
        String title = account.getEmail();
        if (title == null) {
            title = account.getName();
        }
        tv.setText((CharSequence)title);
    }

    public static void applyAccountIcon(IAccount account, CircleImageView iv) {
        iv.setCircleImageEnabled(true);
        Drawable drawable2 = account.getIconDrawable();
        if (drawable2 != null) {
            iv.setImageDrawable(drawable2);
        } else if (account instanceof Account) {
            Account a = (Account)account;
            Bitmap iconBitmap = a.getIconBitmap();
            int iconResource = a.getIconResource();
            Uri iconUri = a.getIconUri();
            boolean placeholderIconEnabled = a.getPlaceholderIconEnabled();
            int placeholderCircleColor = a.getPlaceholderCircleColor();
            if (iconBitmap != null) {
                iv.setImageBitmap(iconBitmap);
            } else if (iconResource != 0) {
                iv.setImageResource(iconResource);
            } else if (iconUri != null) {
                iv.setImageURI(iconUri);
            } else if (placeholderIconEnabled) {
                if (placeholderCircleColor == -1) {
                    iv.setPlaceholder(R.drawable.ic_person_black_24dp);
                } else {
                    iv.setPlaceholder(R.drawable.ic_person_black_24dp, placeholderCircleColor);
                }
            } else if (placeholderCircleColor == -1) {
                iv.setPlaceholder(CircleImageView.retrieveLetter(account.getName()));
            } else {
                iv.setPlaceholder(CircleImageView.retrieveLetter(account.getName()), placeholderCircleColor);
            }
        } else {
            iv.setPlaceholder(CircleImageView.retrieveLetter(account.getName()));
        }
    }

    public static void applyAccountInfo(IAccount account, ViewGroup layout2, ImageView iv, TextView tv) {
        Drawable infoIconDrawable = account.getInfoIconDrawable();
        int infoIconResource = account instanceof Account ? ((Account)account).getInfoIconResource() : 0;
        String infoText = account.getInfoText();
        boolean hasIcon = infoIconResource != 0 || infoIconDrawable != null;
        boolean hasText = infoText != null;
        layout2.setVisibility(hasIcon || hasText ? 0 : 8);
        iv.setVisibility(hasIcon ? 0 : 8);
        tv.setVisibility(hasText ? 0 : 8);
        if (hasIcon) {
            if (infoIconResource != 0) {
                iv.setImageResource(infoIconResource);
            } else {
                iv.setImageDrawable(infoIconDrawable);
            }
        }
        if (hasText) {
            tv.setText((CharSequence)infoText);
        }
    }
}

