/*
 * Decompiled with CFR 0.152.
 */
package com.tr4android.support.extension.drawable;

import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.drawable.Drawable;
import android.support.annotation.ColorInt;
import android.support.v4.graphics.ColorUtils;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import com.tr4android.support.extension.animation.AnimationUtils;
import com.tr4android.support.extension.animation.ValueAnimatorCompat;

public class ColorTransitionDrawable
extends Drawable {
    private float mColorRatio;
    private int mColor;
    private int mColorStart;
    private int mColorEnd;
    private ValueAnimatorCompat mAnimator;
    private Interpolator mStartInterpolator;
    private Interpolator mReverseInterpolator;

    public ColorTransitionDrawable(@ColorInt int start, @ColorInt int end) {
        this.mReverseInterpolator = this.mStartInterpolator = new LinearInterpolator();
        this.mColorRatio = 0.0f;
        this.mColor = start;
        this.mColorStart = start;
        this.mColorEnd = end;
        this.mAnimator = AnimationUtils.createAnimator();
        this.mAnimator.setUpdateListener(new ValueAnimatorCompat.AnimatorUpdateListener(){

            @Override
            public void onAnimationUpdate(ValueAnimatorCompat animator) {
                ColorTransitionDrawable.this.setColorRatio(animator.getAnimatedFloatValue());
            }
        });
    }

    public void draw(Canvas canvas) {
        canvas.drawColor(this.mColor);
    }

    public void setAlpha(int i) {
    }

    public void setColorFilter(ColorFilter colorFilter) {
    }

    public int getOpacity() {
        return -3;
    }

    public float getColorRatio() {
        return this.mColorRatio;
    }

    public void setColorRatio(float ratio) {
        this.mColorRatio = Math.max(0.0f, Math.min(ratio, 1.0f));
        this.mColor = ColorUtils.blendARGB((int)this.mColorStart, (int)this.mColorEnd, (float)this.mColorRatio);
        this.invalidateSelf();
    }

    public void startTransition(int duration) {
        this.mAnimator.cancel();
        this.mAnimator.setFloatValues(this.mColorRatio, 1.0f);
        this.mAnimator.setDuration(duration);
        this.mAnimator.setInterpolator(this.mStartInterpolator);
        this.mAnimator.start();
    }

    public void reverseTransition(int duration) {
        this.mAnimator.cancel();
        this.mAnimator.setFloatValues(this.mColorRatio, 0.0f);
        this.mAnimator.setDuration(duration);
        this.mAnimator.setInterpolator(this.mReverseInterpolator);
        this.mAnimator.start();
    }
}

